/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.ACRemoveFigure;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.CheckerTool;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.nesting.NestingAgent;
import com.arcway.planagent.planmodel.reactions.IEntryOfCompressedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ACRemovePlanElementStructure
extends Action {
    private final List planElements;
    private int[] indexArray;

    public ACRemovePlanElementStructure(ActionContext actionContext, List planElements) {
        super(actionContext);
        assert (planElements.size() > 0) : "size of planElements <= 0";
        assert (CheckerTool.checkContainsIPMPlanElementRWsOnly(planElements));
        assert (CheckerTool.checkPlanElementsAreValid(planElements)) : "one ore more planElements are orphaned or the planElements do not belong to the same plan";
        this.planElements = planElements;
    }

    @Override
    protected void setStateToPost() {
        this.indexArray = new int[this.planElements.size()];
        int counter = 0;
        for (IPMPlanElementRW planElement : this.planElements) {
            this.indexArray[counter] = planElement.getPlanRW().getPlanElementIndex(planElement);
            planElement.getPlanRW().removePlanElement(this.indexArray[counter]);
            ++counter;
        }
    }

    @Override
    protected void setStateToPre() {
        int counter = this.planElements.size() - 1;
        while (counter >= 0) {
            IPMPlanElementRW planElement = (IPMPlanElementRW)this.planElements.get(counter);
            planElement.getPlanRW().addPlanElement(planElement, this.indexArray[counter]);
            --counter;
        }
    }

    @Override
    public boolean isDupe(Action a) {
        ACRemovePlanElementStructure dupeA;
        boolean isDupe = false;
        if (a instanceof ACRemovePlanElementStructure && (dupeA = (ACRemovePlanElementStructure)a).getPlanElements() == this.getPlanElements()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public boolean isNop() {
        return false;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        PredeterminedActionIterator removeFigureActions = new PredeterminedActionIterator();
        for (IPMPlanElementRW planElement : this.planElements) {
            int j = 0;
            while (j < planElement.getFigureCount()) {
                removeFigureActions.addAction(new ACRemoveFigure(this.getActionContext(), planElement.getFigureRW(j)));
                ++j;
            }
        }
        NestingAgent nestingAgent = this.getActionContext().getPlanModelMgr().getNestingAgent();
        ActionIterator removeContainmentsActions = nestingAgent.removeNestings(this.planElements, this.getActionContext());
        ActionIterator preActions = ActionIterator.concatenate(removeFigureActions, removeContainmentsActions);
        return preActions;
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(this.planElements.size());
        for (IPMPlanElementRW planElement : this.planElements) {
            changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(planElement, 3));
        }
        return changes;
    }

    public Collection getEntriesForCompressedReactionList() {
        ArrayList<IPMFigureRW> deletedFigures = new ArrayList<IPMFigureRW>();
        ArrayList<IPMGraphicalSupplementRW> deletedSupplements = new ArrayList<IPMGraphicalSupplementRW>();
        int e = 0;
        while (e < this.planElements.size()) {
            IPMPlanElementRW planElement = (IPMPlanElementRW)this.planElements.get(e);
            int i = 0;
            while (i < planElement.getFigureCount()) {
                IPMFigureRW figure = planElement.getFigureRW(i);
                deletedFigures.add(figure);
                int j = 0;
                while (j < figure.getGraphicalSupplementCount()) {
                    deletedSupplements.add(figure.getGraphicalSupplementRW(j));
                    ++j;
                }
                ++i;
            }
            ++e;
        }
        assert (deletedFigures.isEmpty());
        assert (deletedSupplements.isEmpty());
        HashSet<IEntryOfCompressedList> reactions = new HashSet<IEntryOfCompressedList>();
        reactions.add(this.getActionContext().getActionTypeAgentManager().getReactionDeleteSupplementAgent().getEntryForCompressedList(deletedSupplements, this.getActionContext()));
        reactions.add(this.getActionContext().getActionTypeAgentManager().getReactionDeleteFigureAgent().getEntryForCompressedList(deletedFigures, this.getActionContext()));
        return reactions;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        IPMPlanElementRW onePlanElement = (IPMPlanElementRW)this.planElements.get(0);
        IPMPlanRW semanticalUnit = onePlanElement.getPlanRW();
        return semanticalUnit;
    }

    public List getPlanElements() {
        return this.planElements;
    }

    public String toString() {
        return "ACRemovePlanElementStructure (plan elements " + this.planElements + ")";
    }
}

