/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.ACRemovePlanObject;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.anchoring.AnchoringContributorTraverser;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationContributor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceContributor;
import com.arcway.planagent.planmodel.reactions.IEntryOfCompressedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ACRemoveFigure
extends ACRemovePlanObject {
    private final IPMFigureRW figure;
    private IPMPlanElementRW planElement;
    private int index;

    public ACRemoveFigure(ActionContext actionContext, IPMFigureRW figure) {
        super(actionContext);
        assert (figure != null) : "ref to figure is null";
        this.figure = figure;
    }

    @Override
    protected void initializeState() {
        this.planElement = this.figure.getPlanElementRW();
        this.index = this.planElement.getFigureIndex(this.figure);
    }

    @Override
    protected void setStateToPost() {
        this.planElement.removeFigure(this.index);
    }

    @Override
    protected void setStateToPre() {
        this.planElement.addFigure(this.figure, this.index);
    }

    @Override
    public boolean isDupe(Action a) {
        ACRemoveFigure dupeA;
        boolean isDupe = false;
        if (a instanceof ACRemoveFigure && (dupeA = (ACRemoveFigure)a).getFigure() == this.getFigure()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public boolean isNop() {
        return false;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        Set<IAnchoringSourceContributor> sourceContributors = Collections.singleton(this.figure);
        Set<IAnchoringDestinationContributor> destinationContributors = Collections.singleton(this.figure);
        Collection<IAnchoring> anchoringsToRemove = AnchoringContributorTraverser.getAllAnchorings(sourceContributors, destinationContributors);
        ArrayList<Action> preActions = new ArrayList<Action>(anchoringsToRemove.size());
        for (IPMAnchoringRW iPMAnchoringRW : anchoringsToRemove) {
            preActions.add(ActionFactory.createACRemoveAnchoring(this.getActionContext(), iPMAnchoringRW));
        }
        PredeterminedActionIterator preActionIterator = new PredeterminedActionIterator(preActions.size());
        this.CopyFromSetToActionIterator(preActions, preActionIterator);
        return preActionIterator;
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.figure, 3));
        return changes;
    }

    public Collection getEntriesForCompressedReactionList() {
        ArrayList<IPMGraphicalSupplementRW> supplements = new ArrayList<IPMGraphicalSupplementRW>();
        int j = 0;
        while (j < this.figure.getGraphicalSupplementCount()) {
            IPMGraphicalSupplementRW supplement = this.figure.getGraphicalSupplementRW(j);
            supplements.add(supplement);
            ++j;
        }
        HashSet<IEntryOfCompressedList> reactions = new HashSet<IEntryOfCompressedList>();
        reactions.add(this.getActionContext().getActionTypeAgentManager().getReactionDeleteSupplementAgent().getEntryForCompressedList(supplements, this.getActionContext()));
        ArrayList<IPMFigureRW> deletedFigures = new ArrayList<IPMFigureRW>(1);
        deletedFigures.add(this.figure);
        reactions.add(this.getActionContext().getActionTypeAgentManager().getReactionDeleteFigureAgent().getEntryForCompressedList(deletedFigures, this.getActionContext()));
        return reactions;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        return this.figure.getPlanElementRW();
    }

    public IPMFigureRW getFigure() {
        return this.figure;
    }

    private void CopyFromSetToActionIterator(Collection actions, PredeterminedActionIterator actionIterator) {
        assert (actions != null) : "ret to set is null";
        assert (actionIterator != null) : "ref to actionIterator is null";
        Iterator j = actions.iterator();
        int i = 0;
        while (i < actions.size()) {
            if (j.hasNext()) assert (j.next() instanceof Action) : "the element of the set is not an Action";
            ++i;
        }
        Iterator k = actions.iterator();
        int i2 = 0;
        while (i2 < actions.size()) {
            if (k.hasNext()) {
                actionIterator.addAction((Action)k.next());
            }
            ++i2;
        }
    }

    public String toString() {
        return "ACRemoveFigure (figure " + this.figure + ")";
    }
}

