/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.java.New;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.ACAbstractModifyGeometryPointsInvariant;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.reactions.IEntryOfCompressedList;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ACCreate1Point
extends Action {
    private final IPMPointRW pointToDuplicate;
    private final IPMLineRW lineToSplit;
    private IPMPointRW createdPoint;
    private IPMLineRW createdLine;
    private boolean pointToDuplicateIsPoint1st;
    private int indexOfPointToDuplicate;
    private int indexOfCreatedPoint;
    private int indexOfCreatedLine;
    private List<PositionAndPoint> preStateGoemetry;

    public ACCreate1Point(ActionContext actionContext, IPMPointRW pointToDuplicate, IPMLineRW lineToSplit) {
        super(actionContext);
        assert (pointToDuplicate != null);
        assert (lineToSplit != null);
        assert (lineToSplit.getPoint1stRW() == pointToDuplicate || lineToSplit.getPoint2ndRW() == pointToDuplicate);
        this.lineToSplit = lineToSplit;
        this.pointToDuplicate = pointToDuplicate;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        return this.lineToSplit.getISemanticalUnitRW();
    }

    @Override
    public boolean isNop() {
        return false;
    }

    @Override
    public boolean isDupe(Action a) {
        return false;
    }

    @Override
    protected void initializeState() {
        this.preStateGoemetry = ACAbstractModifyGeometryPointsInvariant.getPreStateGeometry(this.pointToDuplicate.getPlanObjectRW());
        IPMPointListRW pointList = this.pointToDuplicate.getPointListRW();
        this.createdPoint = this.getActionContext().getPlanModelObjectFactory().createPMPointRW();
        this.createdLine = this.getActionContext().getPlanModelObjectFactory().createPMLineRW();
        this.indexOfPointToDuplicate = pointList.getPointIndex(this.pointToDuplicate);
        if (this.pointToDuplicate == this.lineToSplit.getPoint1stRW()) {
            this.pointToDuplicateIsPoint1st = true;
            this.indexOfCreatedPoint = this.indexOfPointToDuplicate + 1;
            this.indexOfCreatedLine = this.indexOfPointToDuplicate;
        } else {
            this.pointToDuplicateIsPoint1st = false;
            this.indexOfCreatedPoint = this.indexOfPointToDuplicate;
            this.indexOfCreatedLine = this.indexOfPointToDuplicate;
        }
        this.createdPoint.setPosition(this.pointToDuplicate.getPosition());
        if (this.pointToDuplicate.getCornerRadiusInherited()) {
            this.createdPoint.setCornerRadiusInherited();
        } else if (this.pointToDuplicate.getCornerRadiusInfinity()) {
            this.createdPoint.setCornerRadiusInfinity();
        } else {
            this.createdPoint.setCornerRadius(this.pointToDuplicate.getCornerRadius());
        }
        this.createdLine.setForce(this.lineToSplit.getForce());
        this.createdPoint.setPointList(pointList);
        this.createdLine.setPointList(pointList);
        if (this.pointToDuplicateIsPoint1st) {
            this.createdPoint.setLine1st(this.createdLine);
            this.createdPoint.setLine2nd(this.lineToSplit);
            this.createdLine.setPoint1st(this.pointToDuplicate);
            this.createdLine.setPoint2nd(this.createdPoint);
        } else {
            this.createdPoint.setLine1st(this.lineToSplit);
            this.createdPoint.setLine2nd(this.createdLine);
            this.createdLine.setPoint1st(this.createdPoint);
            this.createdLine.setPoint2nd(this.pointToDuplicate);
        }
    }

    @Override
    protected void setStateToPost() {
        IPMPointListRW pointList = this.pointToDuplicate.getPointListRW();
        pointList.addPoint(this.createdPoint, this.indexOfCreatedPoint);
        pointList.addLine(this.createdLine, this.indexOfCreatedLine);
        if (this.pointToDuplicateIsPoint1st) {
            this.pointToDuplicate.setLine2nd(this.createdLine);
            this.lineToSplit.setPoint1st(this.createdPoint);
        } else {
            this.lineToSplit.setPoint2nd(this.createdPoint);
            this.pointToDuplicate.setLine1st(this.createdLine);
        }
    }

    @Override
    protected void setStateToPre() {
        IPMPointListRW pointList = this.pointToDuplicate.getPointListRW();
        pointList.removePoint(this.indexOfCreatedPoint);
        pointList.removeLine(this.indexOfCreatedLine);
        if (this.pointToDuplicateIsPoint1st) {
            this.pointToDuplicate.setLine2nd(this.lineToSplit);
            this.lineToSplit.setPoint1st(this.pointToDuplicate);
        } else {
            this.lineToSplit.setPoint2nd(this.pointToDuplicate);
            this.pointToDuplicate.setLine1st(this.lineToSplit);
        }
    }

    @Override
    public ActionIterator getPreActionIterator() {
        return ActionIterator.EMPTY_ACTION_ITERATOR;
    }

    @Override
    public Collection<IEntryOfCompressedList> getEntriesForCompressedReactionList() {
        IPMPlanObjectRW planObject = this.pointToDuplicate.getPlanObjectRW();
        if (planObject instanceof IPMFigureRW) {
            IPMFigureRW figure = (IPMFigureRW)planObject;
            return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionChangeGeometryFigureAgent().getEntryForCompressedList(figure, this.preStateGoemetry, this.getActionContext()));
        }
        if (planObject instanceof IPMGraphicalSupplementRW) {
            HashMap changedSupplements = New.hashMap((int)1);
            changedSupplements.put((IPMGraphicalSupplementRW)planObject, this.preStateGoemetry);
            return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionModifySupplementAgent().getEntryForCompressedList(changedSupplements, this.getActionContext()));
        }
        assert (false) : "point not part of supplement or figure";
        return null;
    }

    @Override
    public Set<IModelChangeRW> getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(2);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.createdPoint, 1));
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.createdLine, 1));
        return changes;
    }

    public IPMPointRW getCreatedPoint() {
        return this.createdPoint;
    }

    public IPMLineRW getCreatedLine() {
        return this.createdLine;
    }
}

