/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.fmc.bd.reactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.graphics.linemarkers.LineMarker;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.PlanModelExtensionMgr;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureLineShapeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.actions.ACApplyAppearanceTpl;
import com.arcway.planagent.planmodel.actions.ACCreateFigureLineShape;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.ACRemoveFigure;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.DelayingActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedLengthActionIterator;
import com.arcway.planagent.planmodel.appearance.AppearanceTplApplier;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.IAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.ILineAppearance;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineEndMarkerAppearance;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineStartMarkerAppearance;
import com.arcway.planagent.planmodel.appearance.LineAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.LineMarkerAppearance;
import com.arcway.planagent.planmodel.appearance.LineMarkerAppearanceTpl;
import com.arcway.planagent.planmodel.base.transactions.LineHelper;
import com.arcway.planagent.planmodel.fmc.bd.access.readonly.IPMPlanElementFMCBDModifyingStorageAccessRO;
import com.arcway.planagent.planmodel.fmc.bd.access.readwrite.IPMPlanElementFMCBDModifyingStorageAccessRW;
import com.arcway.planagent.planmodel.reactions.FigureMovements;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryFigure;
import com.arcway.planagent.planmodel.reactions.IRAMoveFigure;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import java.util.ArrayList;
import java.util.List;

public class RAFixFMCBDModifyingAccessAfterModify
implements IRAChangeGeometryFigure,
IRAMoveFigure {
    private static final ILogger logger = Logger.getLogger(RAFixFMCBDModifyingAccessAfterModify.class);
    private static final Point Point_10_10 = new Point(10.0, 10.0);
    private IPMPlanElementFMCBDModifyingStorageAccessRO defaultTemplate = null;

    public ActionIterator createReactionsFigureGeometryChanged(final IPMFigureRW figure, List<PositionAndPoint> oldGeometry, final ActionContext actionContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("RAFixAnchoringsAfterFigureModify createReactions(" + figure + ") - start");
        }
        return new DelayingActionIterator(){

            protected ActionIterator createActionIterator() {
                return RAFixFMCBDModifyingAccessAfterModify.this.addFixActions(figure, actionContext);
            }
        };
    }

    public ActionIterator createReactionsFiguresMoved(FigureMovements figureMovements, final ActionContext context) {
        ActionIterator actions = ActionIterator.EMPTY_ACTION_ITERATOR;
        for (final IPMFigureRW figure : figureMovements) {
            actions = ActionIterator.concatenate((ActionIterator)actions, (ActionIterator)new DelayingActionIterator(){

                protected ActionIterator createActionIterator() {
                    return RAFixFMCBDModifyingAccessAfterModify.this.addFixActions(figure, context);
                }
            });
        }
        return actions;
    }

    private ActionIterator addFixActions(IPMFigureRW figure, final ActionContext actionContext) {
        Object actionsToReturn;
        IPMFigureLineShapeRW geometryLine;
        IPMFigureLineShapeRW geometryLineTemp = null;
        boolean route = true;
        if (route && !(figure.getPlanElementRW() instanceof IPMPlanElementFMCBDModifyingStorageAccessRW)) {
            route &= false;
        }
        if (route && !(figure instanceof IPMFigureLineShapeRW)) {
            route &= false;
        }
        if (route) {
            IPMFigureLineShapeRW lineShape = (IPMFigureLineShapeRW)figure;
            if (!lineShape.getRole().equals("geometryLine")) {
                route &= false;
            }
            if (route) {
                geometryLineTemp = lineShape;
            }
        }
        if ((geometryLine = geometryLineTemp) != null) {
            final IPMPlanElementFMCBDModifyingStorageAccessRW planElement = (IPMPlanElementFMCBDModifyingStorageAccessRW)geometryLine.getPlanElementRW();
            if (planElement.getEdge1FigureRW() != null) {
                if (geometryLine.getPointListRW().getLineCount() > 1) {
                    PredeterminedLengthActionIterator actions = new PredeterminedLengthActionIterator(){

                        public boolean hasNextAfter(int n) {
                            return n < 5;
                        }

                        public Action createNextAction(ArrayList<Action> previousActions, int n) {
                            return RAFixFMCBDModifyingAccessAfterModify.this.createActionInCaseOfBending(n, planElement, geometryLine, actionContext);
                        }
                    };
                    actionsToReturn = actions;
                } else {
                    ACMovePoint movePointAction;
                    GeoVector distanceToMove;
                    double centerWidth = planElement.getCenterWidth() / 2.0;
                    double endWidth = planElement.getEndWidth() / 2.0;
                    Points newUpperPoints = null;
                    Points newLowerPoints = null;
                    try {
                        newUpperPoints = LineHelper.createModifyingEdge((Points)geometryLine.getPointListRW().getPoints(), (double)centerWidth, (double)endWidth);
                        Points tmp = geometryLine.getPointListRW().getPoints();
                        Points inversePointList = new Points(2);
                        int i = 0;
                        while (i < 2) {
                            inversePointList.add(Point.getAsPoint((Point)tmp.get(1 - i)));
                            ++i;
                        }
                        newLowerPoints = LineHelper.createModifyingEdge((Points)inversePointList, (double)centerWidth, (double)endWidth);
                    }
                    catch (EXTransactionNotValidException e) {
                        logger.error("Invalid point calculation, this should not happen. Expect Nullpointers.", (Throwable)e);
                    }
                    IPMPointListRW upperPoints = planElement.getEdge1FigureRW().getPointListRW();
                    IPMPointListRW lowerPoints = planElement.getEdge2FigureRW().getPointListRW();
                    boolean removeSourceAnchorings = false;
                    PredeterminedActionIterator actions = new PredeterminedActionIterator(6);
                    int i = 0;
                    while (i < 3) {
                        assert (newUpperPoints != null) : "newUpperPoints is null";
                        distanceToMove = new GeoVector(upperPoints.getPointRW(i).getPosition(), newUpperPoints.get(i));
                        movePointAction = new ACMovePoint(actionContext, upperPoints.getPointRW(i), distanceToMove, removeSourceAnchorings);
                        actions.addAction((Action)movePointAction);
                        ++i;
                    }
                    i = 0;
                    while (i < 3) {
                        assert (newLowerPoints != null) : "newLowerPoints is null";
                        distanceToMove = new GeoVector(lowerPoints.getPointRW(i).getPosition(), newLowerPoints.get(i));
                        movePointAction = new ACMovePoint(actionContext, lowerPoints.getPointRW(i), distanceToMove, removeSourceAnchorings);
                        actions.addAction((Action)movePointAction);
                        ++i;
                    }
                    actionsToReturn = actions;
                }
            } else if (geometryLine.getPointListRW().getLineCount() == 1) {
                PredeterminedLengthActionIterator actions = new PredeterminedLengthActionIterator(){

                    public boolean hasNextAfter(int n) {
                        return n < 13;
                    }

                    public Action createNextAction(ArrayList<Action> previousActions, int n) {
                        return RAFixFMCBDModifyingAccessAfterModify.this.createActionInCaseOfStraightening(n, planElement, geometryLine, actionContext);
                    }
                };
                actionsToReturn = actions;
            } else {
                actionsToReturn = ActionIterator.EMPTY_ACTION_ITERATOR;
            }
        } else {
            actionsToReturn = ActionIterator.EMPTY_ACTION_ITERATOR;
        }
        return actionsToReturn;
    }

    private Action createActionInCaseOfStraightening(int n, IPMPlanElementFMCBDModifyingStorageAccessRW planElement, IPMFigureLineShapeRW geometryLine, ActionContext actionContext) {
        Action nextAction = null;
        switch (n) {
            case 0: {
                Points pointList = new Points(3);
                pointList.add(Point_10_10);
                pointList.add(Point_10_10);
                pointList.add(Point_10_10);
                int[] lineForce = new int[]{1, 1};
                ILineStartMarkerAppearance originalStart = geometryLine.getLineStartMarkerAppearanceRW();
                ILineEndMarkerAppearance originalEnd = geometryLine.getLineEndMarkerAppearanceRW();
                LineMarkerAppearance start = new LineMarkerAppearance((ILineMarkerAppearanceRO)originalStart);
                LineMarkerAppearance end = new LineMarkerAppearance((ILineMarkerAppearanceRO)originalEnd);
                start.setLineMarkerStyle(this.getDefaultTemplate().getEdge1FigureRO().getLineStartMarkerAppearanceRO().getLineMarkerStyle());
                end.setLineMarkerStyle(this.getDefaultTemplate().getEdge1FigureRO().getLineEndMarkerAppearanceRO().getLineMarkerStyle());
                nextAction = new ACCreateFigureLineShape(actionContext, "edge1", (IPMPlanElementRW)planElement, pointList, lineForce, (ILineAppearanceRO)geometryLine.getLineAppearanceRW(), (ILineMarkerAppearanceRO)start, (ILineMarkerAppearanceRO)end, false);
                break;
            }
            case 1: {
                LineAppearanceTpl newLineAppearanceTpl = new LineAppearanceTpl();
                newLineAppearanceTpl.setCornerRadiusInfinity();
                nextAction = new ACApplyAppearanceTpl(actionContext, (IPMPlanObjectRO)planElement.getEdge1FigureRW(), (IAppearanceRO)planElement.getEdge1FigureRW().getLineAppearanceRW(), (IAppearanceTpl)newLineAppearanceTpl);
                break;
            }
            case 2: {
                Points pointList = new Points(3);
                pointList.add(Point_10_10);
                pointList.add(Point_10_10);
                pointList.add(Point_10_10);
                int[] lineForce = new int[]{1, 1};
                ILineStartMarkerAppearance originalStart = geometryLine.getLineStartMarkerAppearanceRW();
                ILineEndMarkerAppearance originalEnd = geometryLine.getLineEndMarkerAppearanceRW();
                LineMarkerAppearance start = new LineMarkerAppearance((ILineMarkerAppearanceRO)originalStart);
                LineMarkerAppearance end = new LineMarkerAppearance((ILineMarkerAppearanceRO)originalEnd);
                start.setLineMarkerStyle(this.getDefaultTemplate().getEdge1FigureRO().getLineStartMarkerAppearanceRO().getLineMarkerStyle());
                end.setLineMarkerStyle(this.getDefaultTemplate().getEdge1FigureRO().getLineEndMarkerAppearanceRO().getLineMarkerStyle());
                nextAction = new ACCreateFigureLineShape(actionContext, "edge2", (IPMPlanElementRW)planElement, pointList, lineForce, (ILineAppearanceRO)geometryLine.getLineAppearanceRW(), (ILineMarkerAppearanceRO)start, (ILineMarkerAppearanceRO)end, false);
                break;
            }
            case 3: {
                LineAppearanceTpl newLineAppearanceTpl = new LineAppearanceTpl();
                newLineAppearanceTpl.setCornerRadiusInfinity();
                nextAction = new ACApplyAppearanceTpl(actionContext, (IPMPlanObjectRO)planElement.getEdge2FigureRW(), (IAppearanceRO)planElement.getEdge2FigureRW().getLineAppearanceRW(), (IAppearanceTpl)newLineAppearanceTpl);
                break;
            }
            case 4: {
                nextAction = this.createACMoveUpperPoint(n - 4, planElement, geometryLine, actionContext);
                break;
            }
            case 5: {
                nextAction = this.createACMoveUpperPoint(n - 4, planElement, geometryLine, actionContext);
                break;
            }
            case 6: {
                nextAction = this.createACMoveUpperPoint(n - 4, planElement, geometryLine, actionContext);
                break;
            }
            case 7: {
                nextAction = this.createACMoveLowerPoint(n - 7, planElement, geometryLine, actionContext);
                break;
            }
            case 8: {
                nextAction = this.createACMoveLowerPoint(n - 7, planElement, geometryLine, actionContext);
                break;
            }
            case 9: {
                nextAction = this.createACMoveLowerPoint(n - 7, planElement, geometryLine, actionContext);
                break;
            }
            case 10: {
                ILineAppearance geometryLineAppearence = planElement.getGeometryLineRW().getLineAppearanceRW();
                LineAppearanceTpl newLineAppearanceTpl = new LineAppearanceTpl();
                AppearanceTplApplier.line((ILineAppearanceRO)geometryLineAppearence, (LineAppearanceTpl)newLineAppearanceTpl);
                newLineAppearanceTpl.setLineStyle(LineStyle.NONE);
                nextAction = new ACApplyAppearanceTpl(actionContext, (IPMPlanObjectRO)planElement.getGeometryLineRW(), (IAppearanceRO)planElement.getGeometryLineRW().getLineAppearanceRW(), (IAppearanceTpl)newLineAppearanceTpl);
                break;
            }
            case 11: {
                LineMarkerAppearanceTpl newLineStartMarkerAppearance = new LineMarkerAppearanceTpl();
                newLineStartMarkerAppearance.setLineMarkerStyle(LineMarker.NONE);
                nextAction = new ACApplyAppearanceTpl(actionContext, (IPMPlanObjectRO)geometryLine, (IAppearanceRO)geometryLine.getLineStartMarkerAppearanceRW(), (IAppearanceTpl)newLineStartMarkerAppearance);
                break;
            }
            case 12: {
                LineMarkerAppearanceTpl newLineMarkerAppearance = new LineMarkerAppearanceTpl();
                newLineMarkerAppearance.setLineMarkerStyle(LineMarker.NONE);
                nextAction = new ACApplyAppearanceTpl(actionContext, (IPMPlanObjectRO)geometryLine, (IAppearanceRO)geometryLine.getLineEndMarkerAppearanceRW(), (IAppearanceTpl)newLineMarkerAppearance);
            }
        }
        return nextAction;
    }

    private Action createActionInCaseOfBending(int n, IPMPlanElementFMCBDModifyingStorageAccessRW planElement, IPMFigureLineShapeRW geometryLine, ActionContext actionContext) {
        ACRemoveFigure nextAction = null;
        switch (n) {
            case 0: {
                ILineAppearance edge1FigureLineAppearance = planElement.getEdge1FigureRW().getLineAppearanceRW();
                LineAppearanceTpl newLineAppearanceTpl = new LineAppearanceTpl();
                AppearanceTplApplier.line((ILineAppearanceRO)edge1FigureLineAppearance, (LineAppearanceTpl)newLineAppearanceTpl);
                newLineAppearanceTpl.setCornerRadiusTplHint(1);
                nextAction = new ACApplyAppearanceTpl(actionContext, (IPMPlanObjectRO)planElement.getGeometryLineRW(), (IAppearanceRO)geometryLine.getLineAppearanceRW(), (IAppearanceTpl)newLineAppearanceTpl);
                break;
            }
            case 1: {
                ILineStartMarkerAppearance edge1FigureLineStartMarkerAppearanceTpl = planElement.getEdge1FigureRW().getLineStartMarkerAppearanceRW();
                LineMarkerAppearanceTpl newLineStartMarkerAppearance = new LineMarkerAppearanceTpl();
                AppearanceTplApplier.lineMarker((ILineMarkerAppearanceRO)edge1FigureLineStartMarkerAppearanceTpl, (LineMarkerAppearanceTpl)newLineStartMarkerAppearance);
                newLineStartMarkerAppearance.setLineMarkerStyle(LineMarker.NONE);
                nextAction = new ACApplyAppearanceTpl(actionContext, (IPMPlanObjectRO)geometryLine, (IAppearanceRO)geometryLine.getLineStartMarkerAppearanceRW(), (IAppearanceTpl)newLineStartMarkerAppearance);
                break;
            }
            case 2: {
                ILineEndMarkerAppearance edge1FigureLineEndMarkerAppearanceTpl = planElement.getEdge1FigureRW().getLineEndMarkerAppearanceRW();
                LineMarkerAppearanceTpl newLineEndMarkerAppearance = new LineMarkerAppearanceTpl();
                AppearanceTplApplier.lineMarker((ILineMarkerAppearanceRO)edge1FigureLineEndMarkerAppearanceTpl, (LineMarkerAppearanceTpl)newLineEndMarkerAppearance);
                newLineEndMarkerAppearance.setLineMarkerStyle(LineMarker.NONE);
                nextAction = new ACApplyAppearanceTpl(actionContext, (IPMPlanObjectRO)geometryLine, (IAppearanceRO)geometryLine.getLineEndMarkerAppearanceRW(), (IAppearanceTpl)newLineEndMarkerAppearance);
                break;
            }
            case 3: {
                nextAction = new ACRemoveFigure(actionContext, (IPMFigureRW)planElement.getEdge1FigureRW());
                break;
            }
            case 4: {
                nextAction = new ACRemoveFigure(actionContext, (IPMFigureRW)planElement.getEdge2FigureRW());
            }
        }
        return nextAction;
    }

    private IPMPlanElementFMCBDModifyingStorageAccessRO getDefaultTemplate() {
        if (this.defaultTemplate == null) {
            this.defaultTemplate = (IPMPlanElementFMCBDModifyingStorageAccessRO)PlanModelExtensionMgr.getDefault().getFirstTemplate("fmc.bd.modifyingstorageaccess").getPlanElementRO(0);
        }
        return this.defaultTemplate;
    }

    private Action createACMoveUpperPoint(int n, IPMPlanElementFMCBDModifyingStorageAccessRW planElement, IPMFigureLineShapeRW geometryLine, ActionContext actionContext) {
        double centerWidth = planElement.getCenterWidth() / 2.0;
        double endWidth = planElement.getEndWidth() / 2.0;
        Points newUpperPoints = null;
        try {
            newUpperPoints = LineHelper.createModifyingEdge((Points)geometryLine.getPointListRW().getPoints(), (double)centerWidth, (double)endWidth);
            Points tmp = geometryLine.getPointListRW().getPoints();
            Points inversePointList = new Points(2);
            int i = 0;
            while (i < 2) {
                inversePointList.add(Point.getAsPoint((Point)tmp.get(1 - i)));
                ++i;
            }
        }
        catch (EXTransactionNotValidException e) {
            logger.error("Invalid point calculation, this should not happen. Expect Nullpointers.", (Throwable)e);
        }
        IPMPointListRW upperPoints = planElement.getEdge1FigureRW().getPointListRW();
        boolean removeSourceAnchorings = false;
        assert (newUpperPoints != null) : "newUpperPoints is null";
        GeoVector distanceToMove = new GeoVector(upperPoints.getPointRW(n).getPosition(), newUpperPoints.get(n));
        return new ACMovePoint(actionContext, upperPoints.getPointRW(n), distanceToMove, removeSourceAnchorings);
    }

    private Action createACMoveLowerPoint(int n, IPMPlanElementFMCBDModifyingStorageAccessRW planElement, IPMFigureLineShapeRW geometryLine, ActionContext actionContext) {
        double centerWidth = planElement.getCenterWidth() / 2.0;
        double endWidth = planElement.getEndWidth() / 2.0;
        Points newLowerPoints = null;
        try {
            Points tmp = geometryLine.getPointListRW().getPoints();
            Points inversePointList = new Points(2);
            int i = 0;
            while (i < 2) {
                inversePointList.add(Point.getAsPoint((Point)tmp.get(1 - i)));
                ++i;
            }
            newLowerPoints = LineHelper.createModifyingEdge((Points)inversePointList, (double)centerWidth, (double)endWidth);
        }
        catch (EXTransactionNotValidException e) {
            logger.error("Invalid point calculation, this should not happen. Expect Nullpointers.", (Throwable)e);
        }
        IPMPointListRW lowerPoints = planElement.getEdge2FigureRW().getPointListRW();
        boolean removeSourceAnchorings = false;
        assert (newLowerPoints != null) : "newLowerPoints is null";
        GeoVector distanceToMove = new GeoVector(lowerPoints.getPointRW(n).getPosition(), newLowerPoints.get(n));
        return new ACMovePoint(actionContext, lowerPoints.getPointRW(n), distanceToMove, removeSourceAnchorings);
    }
}

