/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpre.epc.transactions;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.actions.ACCreateFigurePlane;
import com.arcway.planagent.planmodel.actions.ACCreatePlanElement;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.appearance.FillAppearance;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import com.arcway.planagent.planmodel.base.transactions.LineHelper;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCEventRO;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;

public class TACreateBPREEPCEvent
extends PredeterminedLengthTransaction {
    public static final double OFFSET = 5.0;
    private static final int STEPS = 3;
    private final Points eventPoints;
    private final Rectangle geometryFigure;
    private final int[] eventForces;
    private final ILineAppearanceRO lineAppearance;
    private final IFillAppearanceRO fillAppearance;
    private IPMPlanElementBPREEPCEventRO createdEvent;

    public TACreateBPREEPCEvent(IPMPlanRO plan, ActionParameters actionParameters, Rectangle geometryFigure, ILineAppearanceRO lineAppearance, IFillAppearanceRO fillAppearance) {
        super(3, (IPMPlanModelObjectRW)((IPMPlanRW)plan), actionParameters);
        assert (geometryFigure != null) : "Rectangle is null";
        assert (lineAppearance != null) : "ILineAppearance is null";
        Point geometryUpperLeft = geometryFigure.upperLeft;
        Point geometryLowerRight = geometryFigure.lowerRight;
        this.transactionAssertion(geometryUpperLeft != null, "UpperLeft Point is null");
        this.transactionAssertion(geometryLowerRight != null, "LowerRight Point is null");
        this.transactionAssertion(Geo.equals((double)0.0, (double)lineAppearance.getCornerRadius()), "the agent's corner radius is not 0");
        this.geometryFigure = geometryFigure;
        this.eventPoints = new Points();
        this.eventPoints.add(new Point(geometryUpperLeft.x + 5.0, geometryUpperLeft.y));
        this.eventPoints.add(new Point(geometryUpperLeft.x + geometryFigure.w() - 5.0, geometryUpperLeft.y));
        this.eventPoints.add(new Point(geometryUpperLeft.x + geometryFigure.w(), geometryUpperLeft.y + geometryFigure.h() / 2.0));
        this.eventPoints.add(new Point(geometryLowerRight.x - 5.0, geometryLowerRight.y));
        this.eventPoints.add(new Point(geometryUpperLeft.x + 5.0, geometryLowerRight.y));
        this.eventPoints.add(new Point(geometryUpperLeft.x, geometryUpperLeft.y + geometryFigure.h() / 2.0));
        this.eventForces = new int[this.eventPoints.size()];
        int i = 0;
        while (i < this.eventPoints.size()) {
            this.eventForces[i] = 1;
            ++i;
        }
        this.lineAppearance = lineAppearance;
        this.fillAppearance = fillAppearance;
    }

    public Action createAction(int n, ArrayList<Action> previousActions) {
        switch (n) {
            case 0: {
                return this.createEventAction();
            }
            case 1: {
                this.createdEvent = (IPMPlanElementBPREEPCEventRO)((ACCreatePlanElement)previousActions.get(n - 1)).getCreatedPlanElement();
                return this.createEventOutlineAction((ACCreatePlanElement)previousActions.get(n - 1));
            }
            case 2: {
                return this.createGeometryOutlineAction((ACCreatePlanElement)previousActions.get(n - 2));
            }
        }
        return null;
    }

    private Action createEventAction() {
        return new ACCreatePlanElement(this.getActionContext(), (IPMPlanRW)this.getTransactionRoot(), "bpre.epc.event");
    }

    private Action createEventOutlineAction(ACCreatePlanElement previousAction) {
        return new ACCreateFigurePlane(this.getActionContext(), "event", previousAction.getCreatedPlanElement(), this.eventPoints, this.eventForces, this.lineAppearance, this.fillAppearance, false);
    }

    private Action createGeometryOutlineAction(ACCreatePlanElement previousAction) {
        FillAppearance geometryFillAppearance = new FillAppearance();
        geometryFillAppearance.setFillStyle(FillStyle.NONE);
        LineAppearance geometryLineAppearance = new LineAppearance();
        geometryLineAppearance.setLineStyle(LineStyle.NONE);
        Points points = new Points();
        points.add(this.geometryFigure.upperLeft);
        points.add(new Point(this.geometryFigure.lowerRight.x, this.geometryFigure.upperLeft.y));
        points.add(this.geometryFigure.lowerRight);
        points.add(new Point(this.geometryFigure.upperLeft.x, this.geometryFigure.lowerRight.y));
        int[] forces = new int[points.size()];
        try {
            forces = LineHelper.createAlternatingLineForcesClosed((Points)points);
        }
        catch (EXTransactionNotValidException e) {
            this.setInvalid(e);
        }
        return new ACCreateFigurePlane(this.getActionContext(), "geometryFigure", previousAction.getCreatedPlanElement(), points, forces, (ILineAppearanceRO)geometryLineAppearance, (IFillAppearanceRO)geometryFillAppearance, false);
    }

    public IPMPlanElementBPREEPCEventRO getCreatedEvent() {
        return this.createdEvent;
    }

    public String toString() {
        return "TACreateBREEPCEvent (Points " + this.eventPoints + ")";
    }
}

