/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpre.epc.check;

import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.anchoring.AnchoringContributorTraverser;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationContributor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCCompetencyRO;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCControlFlowRO;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCEventRO;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCFunctionRO;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCLogicalOperatorRO;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCStorageRO;
import com.arcway.planagent.planmodel.bpre.epc.implementation.PMPlanElementBPREEPCLogicalOperatorAND;
import com.arcway.planagent.planmodel.bpre.epc.implementation.PMPlanElementBPREEPCLogicalOperatorOR;
import com.arcway.planagent.planmodel.bpre.epc.implementation.PMPlanElementBPREEPCLogicalOperatorXOR;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMPlanElementDotsCommentRO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class BPREEPCValidityMatrix {
    public static boolean isPointToFigureAnchoringPossible(IAnchoringSourcePoint source, IAnchoringDestinationFigure destination) {
        boolean anchoringIsPossible = false;
        IPMFigureRO sourceFigure = source.getAnchoringFigure();
        IPMFigureRO destinationFigure = destination.getAnchoringFigure();
        if (BPREEPCValidityMatrix.isControlFlow(sourceFigure) && BPREEPCValidityMatrix.isFunction(destinationFigure)) {
            anchoringIsPossible |= true;
        } else if (BPREEPCValidityMatrix.isControlFlow(sourceFigure) && BPREEPCValidityMatrix.isEvent(destinationFigure)) {
            anchoringIsPossible |= true;
        } else if (BPREEPCValidityMatrix.isControlFlow(sourceFigure) && BPREEPCValidityMatrix.isLogicalOperator(destinationFigure)) {
            anchoringIsPossible |= true;
        } else if (BPREEPCValidityMatrix.isControlFlow(sourceFigure) && BPREEPCValidityMatrix.isStorage(destinationFigure)) {
            anchoringIsPossible |= true;
        } else if (BPREEPCValidityMatrix.isControlFlow(sourceFigure) && BPREEPCValidityMatrix.isCompetency(destinationFigure)) {
            anchoringIsPossible |= true;
        }
        return anchoringIsPossible &= source.getAnchoringFigure().getPlanElementRO() != destination.getAnchoringFigure().getPlanElementRO();
    }

    public static boolean isPointToPointAnchoringPossible() {
        return false;
    }

    public static boolean isTouchValid(IPMFigureRO figure1, IPMFigureRO figure2) {
        boolean touchIsValid = false;
        touchIsValid |= BPREEPCValidityMatrix.isDirectedTouchValid(figure1, figure2);
        return touchIsValid |= BPREEPCValidityMatrix.isDirectedTouchValid(figure2, figure1);
    }

    private static boolean isDirectedTouchValid(IPMFigureRO sourceFigure, IPMFigureRO destinationFigure) {
        boolean touchIsValid = true;
        touchIsValid = BPREEPCValidityMatrix.isControlFlow(sourceFigure) && BPREEPCValidityMatrix.isEvent(destinationFigure) ? (touchIsValid |= true) : (BPREEPCValidityMatrix.isControlFlow(sourceFigure) && BPREEPCValidityMatrix.isFunction(destinationFigure) ? (touchIsValid |= true) : (BPREEPCValidityMatrix.isControlFlow(sourceFigure) && BPREEPCValidityMatrix.isStorage(destinationFigure) ? (touchIsValid |= true) : (BPREEPCValidityMatrix.isControlFlow(sourceFigure) && BPREEPCValidityMatrix.isLogicalOperator(destinationFigure) ? (touchIsValid |= true) : (BPREEPCValidityMatrix.isDotsComment(sourceFigure) ? (touchIsValid &= BPREEPCValidityMatrix.isControlFlow(destinationFigure) || BPREEPCValidityMatrix.isFunction(destinationFigure) || BPREEPCValidityMatrix.isEvent(destinationFigure) || BPREEPCValidityMatrix.isStorage(destinationFigure) || BPREEPCValidityMatrix.isCompetency(destinationFigure)) : (touchIsValid &= false)))));
        return touchIsValid;
    }

    public static boolean isCombinationValid(IPMFigureRO figure1, IPMFigureRO figure2) {
        IPMPlanElementRO planElement1 = figure1.getPlanElementRO();
        IPMPlanElementRO planElement2 = figure2.getPlanElementRO();
        if (planElement1 instanceof IPMPlanElementBPREEPCStorageRO || planElement2 instanceof IPMPlanElementBPREEPCStorageRO) {
            return true;
        }
        if (planElement1 instanceof IPMPlanElementBPREEPCFunctionRO && planElement2 instanceof IPMPlanElementBPREEPCFunctionRO) {
            return false;
        }
        if (planElement1 instanceof IPMPlanElementBPREEPCEventRO && planElement2 instanceof IPMPlanElementBPREEPCEventRO) {
            return false;
        }
        if (planElement1 instanceof IPMPlanElementBPREEPCCompetencyRO || planElement2 instanceof IPMPlanElementBPREEPCCompetencyRO) {
            return false;
        }
        if (planElement1 instanceof IPMPlanElementBPREEPCEventRO && planElement2 instanceof IPMPlanElementBPREEPCLogicalOperatorRO) {
            return BPREEPCValidityMatrix.isEventLogicalOperatorCombinationValid(figure1, figure2);
        }
        return true;
    }

    public static boolean isLogicalOperatorConnectionValid(IPMFigureRO logicalOperator) {
        int numberOfIncomingEdges = logicalOperator.getPlanElementRO().getNumberOfIncomingEdges();
        int numberOfOutgoingEdges = logicalOperator.getPlanElementRO().getNumberOfOutgoingEdges();
        if (numberOfIncomingEdges != 1 && numberOfOutgoingEdges != 1 || numberOfIncomingEdges == 1 && numberOfOutgoingEdges == 1) {
            return false;
        }
        IPMPlanElementRO incomingPlanElement = null;
        IPMPlanElementRO outgoingPlanElement = null;
        ArrayList<IAnchoringDestinationContributor> destinationContributors = new ArrayList<IAnchoringDestinationContributor>();
        destinationContributors.add((IAnchoringDestinationContributor)logicalOperator);
        Collection anchorings = AnchoringContributorTraverser.getAllAnchorings((Collection)Collections.EMPTY_LIST, destinationContributors);
        if (numberOfIncomingEdges == 1) {
            for (IAnchoring anchoring : anchorings) {
                IPMAnchoringPointRO anchoringPoint;
                IPMFigureRO controlFlow = anchoring.getAnchoringSource().getAnchoringFigure();
                IPMPointListRO controlFlowPointList = controlFlow.getPointListRO();
                IPMPointRO startPoint = controlFlowPointList.getPointRO(0);
                IPMPointRO endPoint = controlFlowPointList.getPointRO(controlFlowPointList.getPointCount() - 1);
                if (logicalOperator.getPlanElementRO().isIncomingEdge(controlFlow)) {
                    anchoringPoint = startPoint.getAnchoringRO();
                    if (anchoringPoint == null) continue;
                    incomingPlanElement = anchoringPoint.getAnchoringDestination().getAnchoringFigure().getPlanElementRO();
                    continue;
                }
                anchoringPoint = endPoint.getAnchoringRO();
                if (anchoringPoint == null) continue;
                IPMPlanElementRO planElement = anchoringPoint.getAnchoringDestination().getAnchoringFigure().getPlanElementRO();
                if (outgoingPlanElement == null) {
                    outgoingPlanElement = planElement;
                    continue;
                }
                if (planElement == null || outgoingPlanElement.getType().equals(planElement.getType()) || planElement instanceof IPMPlanElementBPREEPCLogicalOperatorRO || outgoingPlanElement instanceof IPMPlanElementBPREEPCLogicalOperatorRO) continue;
                return false;
            }
            if (outgoingPlanElement != null && incomingPlanElement != null && outgoingPlanElement.getType().equals(incomingPlanElement.getType())) {
                return false;
            }
        } else if (numberOfOutgoingEdges == 1) {
            for (IAnchoring anchoring : anchorings) {
                IPMAnchoringPointRO anchoringPoint;
                IPMFigureRO controlFlow = anchoring.getAnchoringSource().getAnchoringFigure();
                IPMPointListRO controlFlowPointList = controlFlow.getPointListRO();
                IPMPointRO startPoint = controlFlowPointList.getPointRO(0);
                IPMPointRO endPoint = controlFlowPointList.getPointRO(controlFlowPointList.getPointCount() - 1);
                if (logicalOperator.getPlanElementRO().isOutgoingEdge(controlFlow)) {
                    anchoringPoint = endPoint.getAnchoringRO();
                    if (anchoringPoint == null) continue;
                    outgoingPlanElement = anchoringPoint.getAnchoringDestination().getAnchoringFigure().getPlanElementRO();
                    continue;
                }
                anchoringPoint = startPoint.getAnchoringRO();
                if (anchoringPoint == null) continue;
                IPMPlanElementRO planElement = anchoringPoint.getAnchoringDestination().getAnchoringFigure().getPlanElementRO();
                if (incomingPlanElement == null) {
                    incomingPlanElement = planElement;
                    continue;
                }
                if (planElement == null || incomingPlanElement.getType().equals(planElement.getType()) || planElement instanceof IPMPlanElementBPREEPCLogicalOperatorRO || outgoingPlanElement instanceof IPMPlanElementBPREEPCLogicalOperatorRO) continue;
                return false;
            }
            if (outgoingPlanElement != null && incomingPlanElement != null && outgoingPlanElement.getType().equals(incomingPlanElement.getType())) {
                return false;
            }
        }
        return true;
    }

    private static boolean isEventLogicalOperatorCombinationValid(IPMFigureRO eventFigure, IPMFigureRO logicalOperator) {
        boolean isValid = true;
        IPMPlanElementRO logicalOperatorPE = logicalOperator.getPlanElementRO();
        if (logicalOperatorPE instanceof PMPlanElementBPREEPCLogicalOperatorAND) {
            return true;
        }
        if ((logicalOperatorPE instanceof PMPlanElementBPREEPCLogicalOperatorOR || logicalOperatorPE instanceof PMPlanElementBPREEPCLogicalOperatorXOR) && logicalOperatorPE.getNumberOfIncomingEdges() == 1) {
            ArrayList<IAnchoringDestinationContributor> destinationContributors = new ArrayList<IAnchoringDestinationContributor>();
            destinationContributors.add((IAnchoringDestinationContributor)logicalOperator);
            Collection anchorings = AnchoringContributorTraverser.getAllAnchorings((Collection)Collections.EMPTY_LIST, destinationContributors);
            for (IAnchoring anchoring : anchorings) {
                IPMFigureRO controlFlow = anchoring.getAnchoringSource().getAnchoringFigure();
                if (!eventFigure.getPlanElementRO().isOutgoingEdge(controlFlow)) continue;
                isValid = false;
            }
        }
        return isValid;
    }

    private static boolean isControlFlow(IPMFigureRO figure) {
        boolean isControlFlow = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        return isControlFlow |= planElement instanceof IPMPlanElementBPREEPCControlFlowRO;
    }

    private static boolean isEvent(IPMFigureRO figure) {
        boolean isEvent = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        if (planElement instanceof IPMPlanElementBPREEPCEventRO) {
            IPMPlanElementBPREEPCEventRO event = (IPMPlanElementBPREEPCEventRO)planElement;
            isEvent |= event.getEventFigureRO() == figure;
        }
        return isEvent;
    }

    private static boolean isStorage(IPMFigureRO figure) {
        boolean isStorage = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        if (planElement instanceof IPMPlanElementBPREEPCStorageRO) {
            IPMPlanElementBPREEPCStorageRO storage = (IPMPlanElementBPREEPCStorageRO)planElement;
            isStorage |= storage.getOutlineFigureRO() == figure;
        }
        return isStorage;
    }

    private static boolean isFunction(IPMFigureRO figure) {
        boolean isFunction = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        if (planElement instanceof IPMPlanElementBPREEPCFunctionRO) {
            IPMPlanElementBPREEPCFunctionRO function = (IPMPlanElementBPREEPCFunctionRO)planElement;
            isFunction |= function.getOutlineFigureRO() == figure;
        }
        return isFunction;
    }

    private static boolean isCompetency(IPMFigureRO figure) {
        boolean isCompetency = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        if (planElement instanceof IPMPlanElementBPREEPCCompetencyRO) {
            IPMPlanElementBPREEPCCompetencyRO competency = (IPMPlanElementBPREEPCCompetencyRO)planElement;
            isCompetency |= competency.getOutlineFigureRO() == figure;
        }
        return isCompetency;
    }

    private static boolean isLogicalOperator(IPMFigureRO figure) {
        boolean isLogicalOperator = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        if (planElement instanceof IPMPlanElementBPREEPCLogicalOperatorRO) {
            IPMPlanElementBPREEPCLogicalOperatorRO logicalOperator = (IPMPlanElementBPREEPCLogicalOperatorRO)planElement;
            isLogicalOperator |= logicalOperator.getOutlineFigureRO() == figure;
        }
        return isLogicalOperator;
    }

    private static boolean isDotsComment(IPMFigureRO figure) {
        boolean isComment = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        return isComment |= planElement instanceof IPMPlanElementDotsCommentRO;
    }
}

