/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpmn.bpd.transactions;

import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.actions.ACNOP;
import com.arcway.planagent.planmodel.actions.ACRemoveGraphicalSupplement;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.base.transactions.LineHelper;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readwrite.IPMGraphicalSupplementBPMNBPDEventTypeSymbolRW;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readwrite.IPMPlanElementBPMNBPDEventRW;
import com.arcway.planagent.planmodel.bpmn.bpd.actions.ACChangeBPMNBPDEventVariant;
import com.arcway.planagent.planmodel.bpmn.bpd.actions.ACCreateBPMNBPDGraphicalSupplementEventTypeSymbol;
import com.arcway.planagent.planmodel.bpmn.bpd.check.BPMNBPDEventVariantTypeValidityMatrix;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;

public class TAChangeBPMNBPDEventVariant
extends PredeterminedLengthTransaction {
    private static final int STEPS = 3;
    private final IPMPlanElementBPMNBPDEventRW eventToReplace;
    private final IPMPlanElementBPMNBPDEventRW.EventVariant newEventVariant;
    private String eventXmlType = null;
    private int[] force = null;
    private Points boundPoints = null;
    private IPMFigureRW figure = null;
    private IPMGraphicalSupplementBPMNBPDEventTypeSymbolRW currentType = null;

    public TAChangeBPMNBPDEventVariant(IPMPlanElementBPMNBPDEventRW eventToReplace, IPMPlanElementBPMNBPDEventRW.EventVariant newEventVariant, ActionParameters actionParameters) {
        super(3, (IPMPlanModelObjectRW)eventToReplace, actionParameters);
        this.eventToReplace = eventToReplace;
        this.newEventVariant = newEventVariant;
        this.currentType = eventToReplace.getEventTypeSymbolRW();
        if (this.currentType != null && BPMNBPDEventVariantTypeValidityMatrix.isCombinationValid(newEventVariant, this.currentType.getClass())) {
            this.eventXmlType = this.currentType.getXmlTyp();
            this.figure = eventToReplace.getFigureForEventTypeSymbol();
            this.boundPoints = this.figure.getPointListRW().getPoints().getBounds().toPoints();
            try {
                this.force = LineHelper.createAlternatingLineForcesClosed((Points)this.boundPoints);
            }
            catch (EXTransactionNotValidException e) {
                this.setInvalid(e);
            }
        }
    }

    public Action createAction(int n, ArrayList<Action> previousActions) {
        switch (n) {
            case 0: {
                if (this.currentType != null) {
                    return new ACRemoveGraphicalSupplement(this.getActionContext(), (IPMGraphicalSupplementRW)this.currentType);
                }
                return new ACNOP((IPMPlanModelObjectRW)this.eventToReplace, this.getActionContext());
            }
            case 1: {
                return new ACChangeBPMNBPDEventVariant(this.getActionContext(), this.eventToReplace, this.newEventVariant);
            }
            case 2: {
                if (this.eventXmlType != null) {
                    return new ACCreateBPMNBPDGraphicalSupplementEventTypeSymbol(this.getActionContext(), this.boundPoints, this.force, this.figure, this.eventToReplace.getEventTypeSymbolRole(), this.newEventVariant, this.eventXmlType);
                }
                return new ACNOP((IPMPlanModelObjectRW)this.eventToReplace, this.getActionContext());
            }
        }
        return null;
    }
}

