/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpmn.bpd.reactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureDotRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigurePlaneRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readwrite.IPMPlanElementBPMNBPDEventRW;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryFigure;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import java.util.List;

public class RAResizeEvent
implements IRAChangeGeometryFigure {
    private static final ILogger logger = Logger.getLogger(RAResizeEvent.class);

    public ActionIterator createReactionsFigureGeometryChanged(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext context) {
        if (logger.isTraceEnabled()) {
            logger.trace("RAResizeEvent createReactions(" + figure + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator(1);
        RAResizeEvent.addFixActions(figure, context, actions);
        if (actions.isEmpty()) {
            actions = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    private static void addFixActions(IPMFigureRW figure, ActionContext actionContext, PredeterminedActionIterator actions) {
        IPMFigurePlaneRW outlineFigure = null;
        if (!(figure.getPlanElementRW() instanceof IPMPlanElementBPMNBPDEventRW)) {
            return;
        }
        if (!(figure instanceof IPMFigurePlaneRW)) {
            return;
        }
        outlineFigure = (IPMFigurePlaneRW)figure;
        if (!outlineFigure.getRole().equals("outline")) {
            return;
        }
        IPMPlanElementBPMNBPDEventRW eventPE = (IPMPlanElementBPMNBPDEventRW)outlineFigure.getPlanElementRW();
        Rectangle bounds = outlineFigure.getPointListRW().getPoints().getBounds();
        IPMFigureDotRW centerDotFigure = eventPE.getCenterPointFigureRW();
        if (centerDotFigure != null) {
            IPMPointListRW centerDotFigurePoints = centerDotFigure.getPointListRW();
            assert (centerDotFigurePoints.getPointCount() == 1) : "center dot does not consist of exactly 1 point";
            ACMovePoint moveAction = new ACMovePoint(actionContext, centerDotFigurePoints.getPointRW(0), new GeoVector(centerDotFigurePoints.getPointRW(0).getPosition(), bounds.center()), true);
            actions.addAction((Action)moveAction);
        }
    }
}

