/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.dialogs;

import com.arcway.lib.geometry.Geo;
import com.arcway.planagent.planeditor.Messages;
import de.plans.lib.util.LocalisationUtils;

public class DoublePattern {
    private final double minValue;
    private final double maxValue;
    private final boolean mustBeInteger;

    public DoublePattern(double minValue, double maxValue, boolean mustBeInteger) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.mustBeInteger = mustBeInteger;
        assert (maxValue + 1.0E-10 > minValue - 1.0E-10) : "maxValue < minValue";
    }

    public boolean isValue(double value) {
        return this.isInRange(value) && this.isIntegerCheckOk(value);
    }

    private boolean isInRange(double value) {
        return value > this.minValue - 1.0E-10 && value < this.maxValue + 1.0E-10;
    }

    private boolean isIntegerCheckOk(double value) {
        return !this.mustBeInteger || this.isInteger(value);
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public boolean mustBeInteger() {
        return this.mustBeInteger;
    }

    private boolean isInteger(double value) {
        return Geo.equals((double)value, (double)Math.round(value));
    }

    public String errorMessage(double value) {
        int digits = this.mustBeInteger ? 0 : 10;
        String stringMinValue = LocalisationUtils.roundLocalized((double)this.minValue, (int)digits, (boolean)true);
        String stringMaxValue = LocalisationUtils.roundLocalized((double)this.maxValue, (int)digits, (boolean)true);
        String error = !this.isInRange(value) ? "(" + Messages.getString("DoublePattern.must_be_between") + stringMinValue + Messages.getString("DoublePattern.and") + stringMaxValue + ")" : (!this.isIntegerCheckOk(value) ? Messages.getString("DoublePattern.must_be_an_integer_value") : "");
        return error;
    }
}

