/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.commands;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.commands.SnappablePoint;
import com.arcway.planagent.planeditor.commands.TransactionCommand;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.transactions.TAMovePlanElementStructure;
import com.arcway.planagent.planmodel.transactions.Transaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CMMovePlanElementStructure
extends TransactionCommand {
    private static final String COMMAND_LABEL_SINGULAR = Messages.getString("CMMovePlanElementStructure.Move_Plan_Element");
    private static final String COMMAND_LABEL_PLURAL = Messages.getString("CMMovePlanElementStructure.Move_Plan_Elements");

    public CMMovePlanElementStructure(List<IPMPlanElementRO> pmPlanElements, GeoVector dist, boolean moveChildrenAlso, ICommandContext commandContext) {
        super(commandContext);
        GeoVector distance = dist;
        assert (pmPlanElements != null);
        if (pmPlanElements.size() > 0) {
            if (moveChildrenAlso) {
                this.addContainedPlanElements(pmPlanElements);
            }
            ArrayList<SnappablePoint> points = new ArrayList<SnappablePoint>();
            int i = 0;
            while (i < pmPlanElements.size()) {
                Collection figures = pmPlanElements.get(i).getEditIPMFiguresRO();
                points.addAll(SnappablePoint.gatherPoints(figures));
                ++i;
            }
            distance = commandContext.getGrid().snapObjectTranslation(points, distance);
            TAMovePlanElementStructure transaction = new TAMovePlanElementStructure(pmPlanElements, distance, this.getActionParameters());
            if (pmPlanElements.size() == 1) {
                super.construct(COMMAND_LABEL_SINGULAR, (Transaction)transaction);
            } else {
                super.construct(COMMAND_LABEL_PLURAL, (Transaction)transaction);
            }
        }
    }
}

