/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.check;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.FMCAPlanEditorPlugin;
import com.arcway.planagent.planeditor.check.ISyntaxChecker;
import com.arcway.planagent.planeditor.edit.PEPlan;
import com.arcway.planagent.planmodel.check.ISyntaxProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class SyntaxChecker {
    private static ILogger logger = Logger.getLogger(SyntaxChecker.class);
    private static SyntaxChecker instance;
    private final ArrayList<ISyntaxChecker> checkersForAllPlanTypes = new ArrayList();
    private final HashMap<String, ArrayList<ISyntaxChecker>> checkersForPlanTypeLists = new HashMap();

    public static SyntaxChecker getInstance() {
        if (instance == null) {
            instance = new SyntaxChecker();
        }
        return instance;
    }

    protected SyntaxChecker() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] syntaxCheckers = registry.getExtensionPoint(FMCAPlanEditorPlugin.getPluginID(), "syntaxcheckers").getExtensions();
        if (syntaxCheckers == null) {
            return;
        }
        IExtension[] iExtensionArray = syntaxCheckers;
        int n = syntaxCheckers.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension element = iExtensionArray[n2];
            IConfigurationElement[] configurationElements = element.getConfigurationElements();
            assert (configurationElements != null) : "invalid extension";
            IConfigurationElement[] iConfigurationElementArray = configurationElements;
            int n3 = configurationElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element2 = iConfigurationElementArray[n4];
                try {
                    ISyntaxChecker syntaxChecker = (ISyntaxChecker)element2.createExecutableExtension("class");
                    String[] planTypes = syntaxChecker.getCheckablePlanTypes();
                    if (planTypes == null) {
                        this.checkersForAllPlanTypes.add(syntaxChecker);
                    } else {
                        int k = 0;
                        while (k < planTypes.length) {
                            if (!this.checkersForPlanTypeLists.containsKey(planTypes[k])) {
                                this.checkersForPlanTypeLists.put(planTypes[k], new ArrayList());
                            }
                            ArrayList<ISyntaxChecker> checkersForPlanTypes = this.checkersForPlanTypeLists.get(planTypes[k]);
                            checkersForPlanTypes.add(syntaxChecker);
                            ++k;
                        }
                    }
                }
                catch (CoreException e) {
                    logger.error("Could not create syntax checker.", (Throwable)e);
                }
                catch (ClassCastException e) {
                    logger.error("Syntax checker does not implement ISyntaxChecer.", (Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public HashMap checkSyntax(PEPlan plan) {
        HashMap<ISyntaxProblem, ISyntaxChecker> results = new HashMap<ISyntaxProblem, ISyntaxChecker>();
        int i = 0;
        while (i < this.checkersForAllPlanTypes.size()) {
            ISyntaxChecker checker = this.checkersForAllPlanTypes.get(i);
            for (ISyntaxProblem iSyntaxProblem : checker.checkSyntax(plan)) {
                if (logger.isDebugEnabled(72)) {
                    logger.debug(72, "[SYNTAX CHECK, all plan types] Problem reportet by checker " + checker + ": " + iSyntaxProblem);
                }
                results.put(iSyntaxProblem, checker);
            }
            ++i;
        }
        String planTypeID = plan.getPMPlan().getType();
        ArrayList<ISyntaxChecker> checkersForPlanType = this.checkersForPlanTypeLists.get(planTypeID);
        if (checkersForPlanType != null) {
            int i2 = 0;
            while (i2 < checkersForPlanType.size()) {
                ISyntaxChecker iSyntaxChecker = checkersForPlanType.get(i2);
                for (ISyntaxProblem iSyntaxProblem : iSyntaxChecker.checkSyntax(plan)) {
                    if (logger.isDebugEnabled(72)) {
                        logger.debug(72, "[SYNTAX CHECK, plan type " + planTypeID + "] Problem reportet by checker " + iSyntaxChecker + ": " + iSyntaxProblem);
                    }
                    results.put(iSyntaxProblem, iSyntaxChecker);
                }
                ++i2;
            }
        }
        return results;
    }

    public ISyntaxChecker findSyntaxChecker(Class type) {
        ISyntaxChecker foundChecker = null;
        Iterator<Object> i = this.checkersForAllPlanTypes.iterator();
        while (foundChecker == null && i.hasNext()) {
            ISyntaxChecker currentChecker = i.next();
            if (!type.isInstance(currentChecker)) continue;
            foundChecker = currentChecker;
        }
        i = this.checkersForPlanTypeLists.values().iterator();
        while (foundChecker == null && i.hasNext()) {
            Collection currentCheckers = (Collection)i.next();
            Iterator checkerIt = currentCheckers.iterator();
            while (foundChecker == null && checkerIt.hasNext()) {
                ISyntaxChecker currentChecker = (ISyntaxChecker)checkerIt.next();
                if (!type.isInstance(currentChecker)) continue;
                foundChecker = currentChecker;
            }
        }
        return foundChecker;
    }
}

