/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.lib.eclipse.graphics.devicedrivers.DeviceDriverSWTGC;
import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriver;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planeditor.FMCAPlanEditorPlugin;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecorationWithMenu;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.IAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearanceTpl;
import de.plans.lib.eclipse.ResourceLoader;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class LineStyleDecoration
implements IAppearanceButtonDecorationWithMenu {
    private static LineStyleDecoration singelton;
    private static ImageDescriptor image;

    static {
        image = ResourceLoader.getImageDescriptor((String)"linestyle.gif", (Plugin)FMCAPlanEditorPlugin.getDefault());
    }

    private LineStyleDecoration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LineStyleDecoration getInstance() {
        Class<LineStyleDecoration> clazz = LineStyleDecoration.class;
        synchronized (LineStyleDecoration.class) {
            if (singelton == null) {
                singelton = new LineStyleDecoration();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singelton;
        }
    }

    @Override
    public Class[] getAppearanceClasses() {
        return new Class[]{ILineAppearanceRO.class};
    }

    @Override
    public Object getStateOfAppearance(IAppearanceRO appearance) {
        return ((ILineAppearanceRO)appearance).getLineStyle();
    }

    @Override
    public String getToolTipText(Object state) {
        return this.getMenuEntryText(state);
    }

    @Override
    public ImageDescriptor getButtonImageDescriptor(Object state) {
        return image;
    }

    @Override
    public ImageDescriptor getMenuEntryImage(Object state) {
        ImageData subImageData = image.getImageData();
        Image subImage = new Image(null, subImageData);
        int w = subImageData.width;
        int h = subImageData.height;
        subImage.dispose();
        Image labelImage = new Image((Device)Display.getCurrent(), w, h);
        GC g = new GC((Drawable)labelImage);
        Color bc = new Color(null, 0, 8, 8);
        g.setForeground(bc);
        g.setBackground(bc);
        g.fillRectangle(0, 0, w, h);
        bc.dispose();
        int transparentPixel = labelImage.getImageData().getPixel(0, 0);
        this.drawMuster(g, 2, 2, w - 4, h - 4, (LineStyle)state);
        g.dispose();
        final ImageData imageData = labelImage.getImageData();
        imageData.transparentPixel = transparentPixel;
        labelImage.dispose();
        ImageDescriptor desc = new ImageDescriptor(){

            public ImageData getImageData() {
                return imageData;
            }
        };
        return desc;
    }

    @Override
    public String getMenuEntryText(Object state) {
        LineStyle lineStyle = (LineStyle)state;
        String name = lineStyle == LineStyle.NONE ? Messages.getString("LineStyleDecoration.none") : (lineStyle == LineStyle.DOT ? Messages.getString("LineStyleDecoration.dot") : (lineStyle == LineStyle.DASH ? Messages.getString("LineStyleDecoration.dash") : (lineStyle == LineStyle.DASHDASH ? Messages.getString("LineStyleDecoration.longdash") : (lineStyle == LineStyle.DASHDASHDOT ? Messages.getString("LineStyleDecoration.dashdashdot") : (lineStyle == LineStyle.DASHDOT ? Messages.getString("LineStyleDecoration.dashdot") : (lineStyle == LineStyle.DASHDOTDOT ? Messages.getString("LineStyleDecoration.dashdotdot") : (lineStyle == LineStyle.DASHSHORT ? Messages.getString("LineStyleDecoration.shortdash") : (lineStyle == LineStyle.SOLID ? Messages.getString("LineStyleDecoration.solid") : (lineStyle == LineStyle.DOUBLESTROKE ? Messages.getString("LineStyleDecoration.doublestroke") : (lineStyle == LineStyle.TRIPLESTROKE ? Messages.getString("LineStyleDecoration.triplestroke") : (lineStyle == LineStyle.DOUBLESTROKEDASH ? Messages.getString("LineStyleDecoration.doublestrokedash") : (lineStyle == LineStyle.DOUBLESTROKEDASHSHORT ? Messages.getString("LineStyleDecoration.doublestrokedashshort") : lineStyle.getName()))))))))))));
        return name;
    }

    @Override
    public IAppearanceTpl[] getAppearanceTemplates(Object state) {
        LineAppearanceTpl template = new LineAppearanceTpl();
        template.setLineStyle((LineStyle)state);
        return new IAppearanceTpl[]{template};
    }

    private void drawMuster(GC gc, int x, int y, int w, int h, LineStyle state) {
        DeviceDriverSWTGC deviceDriverSWTGC = new DeviceDriverSWTGC((Device)Display.getDefault(), gc, true);
        TransformationAffiliate trafo = Transformation.createTransformation((Rectangle)new Rectangle(0.0, 0.0, 100.0, 100.0), (Rectangle)new Rectangle((double)x, (double)y, new Dimension((double)w, (double)h)));
        com.arcway.lib.graphics.device.Device device = new com.arcway.lib.graphics.device.Device((IDeviceDriver)deviceDriverSWTGC, (Transformation)trafo);
        Corners corners = new Corners();
        corners.add((Point)new Corner(0.0, 0.0));
        corners.add((Point)new Corner(100.0, 0.0));
        corners.add((Point)new Corner(100.0, 50.0));
        corners.add((Point)new Corner(0.0, 50.0));
        corners.add((Point)new Corner(0.0, 100.0));
        corners.add((Point)new Corner(100.0, 100.0));
        device.polyline(corners, 10.0, com.arcway.lib.graphics.Color.BLACK, state);
        deviceDriverSWTGC.dispose();
    }
}

