/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.lib.java.tuples.Tuple;
import com.arcway.planagent.planeditor.actions.ExecutableCommand;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecoration;
import com.arcway.planagent.planeditor.commands.CMApplyTemplates;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.edit.PEPlan;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planmodel.appearance.IAppearanceProvider;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.IAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.TemplateApplicationTuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class AppearanceUtil {
    private AppearanceUtil() {
    }

    protected static ExecutableCommand getCommand(SelectionInfoProvider selectionInfo, IAppearanceButtonDecoration buttonType, Object state) {
        ExecutableCommand command;
        PEPlan pePlan = selectionInfo.getPlanContainingTheSelectedElements();
        if (pePlan != null && pePlan.getMode() == 1) {
            Tuple<PEPlan, HashMap<Class<? extends IAppearanceRO>, List<TemplateApplicationTuple>>> templateApplicationTuplesMapForCurrentSelection = selectionInfo.getTemplateApplicationTuplesMap();
            IAppearanceTpl[] templates = buttonType.getAppearanceTemplates(state);
            Class[] appearanceClasses = buttonType.getAppearanceClasses();
            assert (templates.length == appearanceClasses.length);
            HashMap<IAppearanceTpl, Collection<TemplateApplicationTuple>> templatesToTemplateApplicationTuples = new HashMap<IAppearanceTpl, Collection<TemplateApplicationTuple>>();
            int i = 0;
            while (i < templates.length) {
                IAppearanceTpl template = templates[i];
                Class appearanceClass = appearanceClasses[i];
                if (template != null && appearanceClass != null) {
                    ArrayList<TemplateApplicationTuple> templateApplicationTuples = new ArrayList<TemplateApplicationTuple>();
                    for (Map.Entry entry : ((HashMap)templateApplicationTuplesMapForCurrentSelection.getT2()).entrySet()) {
                        if (!appearanceClass.isAssignableFrom((Class)entry.getKey())) continue;
                        for (TemplateApplicationTuple templateApplicationTuple : (List)entry.getValue()) {
                            Object stateOfAppearance = buttonType.getStateOfAppearance(templateApplicationTuple.getAppearance());
                            if (stateOfAppearance == null) continue;
                            templateApplicationTuples.add(templateApplicationTuple);
                        }
                    }
                    if (templateApplicationTuples.size() > 0) {
                        templatesToTemplateApplicationTuples.put(template, templateApplicationTuples);
                    }
                }
                ++i;
            }
            if (!templatesToTemplateApplicationTuples.isEmpty()) {
                ICommandContext commandContext = pePlan.getCommandContext();
                CommandStack commandStack = pePlan.getCommandStack();
                CMApplyTemplates applyTemplatesCommand = new CMApplyTemplates(templatesToTemplateApplicationTuples, commandContext);
                command = new ExecutableCommand(applyTemplatesCommand, commandStack);
            } else {
                command = null;
            }
        } else {
            command = null;
        }
        return command;
    }

    public static Set<Object> getSelectedStates(Tuple<PEPlan, HashMap<Class<? extends IAppearanceRO>, List<TemplateApplicationTuple>>> templateApplicationTuplesMapForCurrentSelection, IAppearanceButtonDecoration buttonType) {
        Class[] appearanceClasses = buttonType.getAppearanceClasses();
        HashSet<Object> selectedStates = new HashSet<Object>(20, 0.5f);
        for (Map.Entry entry : ((HashMap)templateApplicationTuplesMapForCurrentSelection.getT2()).entrySet()) {
            boolean appearanceClassMatchFound = false;
            Class[] classArray = appearanceClasses;
            int n = appearanceClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class appearanceClass = classArray[n2];
                if (appearanceClass.isAssignableFrom((Class)entry.getKey())) {
                    appearanceClassMatchFound = true;
                    break;
                }
                ++n2;
            }
            if (!appearanceClassMatchFound) continue;
            for (TemplateApplicationTuple templateApplicationTuple : (List)entry.getValue()) {
                Object selectedstate = buttonType.getStateOfAppearance(templateApplicationTuple.getAppearance());
                if (selectedstate == null) continue;
                selectedStates.add(selectedstate);
            }
        }
        return selectedStates;
    }

    public static Tuple<PEPlan, HashMap<Class<? extends IAppearanceRO>, List<TemplateApplicationTuple>>> getTemplateApplicationTuplesMapForCurrentSelection(CollectionAndPEPlan<IAppearanceProvider> filteredPlanEditPartsndContext) {
        HashMap result = new HashMap();
        Collection<IAppearanceProvider> selectedAppearanceProviders = filteredPlanEditPartsndContext.getCollection();
        for (IAppearanceProvider appearanceProvider : selectedAppearanceProviders) {
            for (TemplateApplicationTuple templateApplicationTuple : appearanceProvider.getTemplateApplicationTuples()) {
                IAppearanceRO appearance = templateApplicationTuple.getAppearance();
                Class<?> appearanceClass = appearance.getClass();
                ArrayList<TemplateApplicationTuple> list = (ArrayList<TemplateApplicationTuple>)result.get(appearance.getClass());
                if (list == null) {
                    list = new ArrayList<TemplateApplicationTuple>();
                    result.put(appearanceClass, list);
                }
                list.add(templateApplicationTuple);
            }
        }
        return new Tuple((Object)filteredPlanEditPartsndContext.getPEPlan(), result);
    }

    public static PEPlan getPEPlanOfFilteredPlanEditParts(ISelection selection, Class<?> mustBeInstanceOfClass) {
        CollectionAndPEPlan<?> filteredPlanEditParts = AppearanceUtil.getFilteredPlanEditParts(selection, mustBeInstanceOfClass);
        return filteredPlanEditParts.getPEPlan();
    }

    private static <E> CollectionAndPEPlan<E> getFilteredPlanEditParts(ISelection selection, Class<? extends E> mustBeInstanceOfClass) {
        assert (mustBeInstanceOfClass != null);
        List selectedEditParts = Collections.emptyList();
        ICommandContext commandContext = null;
        PEPlan pePlan = null;
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            selectedEditParts = new ArrayList(structuredSelection.size());
            for (Object selectedObject : structuredSelection.toList()) {
                PEPlan currentPEPlan;
                Object selectedE;
                if (!mustBeInstanceOfClass.isInstance(selectedObject) || !((selectedE = selectedObject) instanceof PEPlanEditPart)) continue;
                boolean remove = false;
                PEPlanEditPart pEPlanEditPart = (PEPlanEditPart)selectedE;
                ICommandContext currentCommandContext = pEPlanEditPart.getCommandContext();
                if (currentCommandContext == null || commandContext != null && currentCommandContext != commandContext) {
                    remove = true;
                }
                if ((currentPEPlan = pEPlanEditPart.getPEPlan()) == null || pePlan != null && currentPEPlan != pePlan) {
                    remove = true;
                }
                if (remove) continue;
                commandContext = currentCommandContext;
                pePlan = currentPEPlan;
                selectedEditParts.add(selectedE);
            }
        }
        return new CollectionAndPEPlan(selectedEditParts, pePlan);
    }

    private static class CollectionAndPEPlan<E> {
        private final Collection<E> collection;
        private final PEPlan pePlan;

        public CollectionAndPEPlan(Collection<E> filteredPlanElements, PEPlan pePlan) {
            this.collection = filteredPlanElements;
            this.pePlan = pePlan;
        }

        public Collection<E> getCollection() {
            return this.collection;
        }

        public PEPlan getPEPlan() {
            return this.pePlan;
        }
    }

    public static class SelectionInfoProvider {
        private final IAppearanceButtonDecoration buttonType;
        private final ISelection selection;
        private CollectionAndPEPlan<IAppearanceProvider> filteredPlanEditParts;
        private Tuple<PEPlan, HashMap<Class<? extends IAppearanceRO>, List<TemplateApplicationTuple>>> templateApplicationTuplesMapForCurrentSelection;
        private Set<Object> selectedStates;

        public SelectionInfoProvider(IAppearanceButtonDecoration buttonType, ISelection selection) {
            this.buttonType = buttonType;
            this.selection = selection;
        }

        private CollectionAndPEPlan<IAppearanceProvider> getFilteredPlanEditParts() {
            if (this.filteredPlanEditParts == null) {
                this.filteredPlanEditParts = AppearanceUtil.getFilteredPlanEditParts(this.selection, IAppearanceProvider.class);
            }
            return this.filteredPlanEditParts;
        }

        public PEPlan getPlanContainingTheSelectedElements() {
            return this.getFilteredPlanEditParts().getPEPlan();
        }

        public Tuple<PEPlan, HashMap<Class<? extends IAppearanceRO>, List<TemplateApplicationTuple>>> getTemplateApplicationTuplesMap() {
            if (this.templateApplicationTuplesMapForCurrentSelection == null) {
                this.templateApplicationTuplesMapForCurrentSelection = AppearanceUtil.getTemplateApplicationTuplesMapForCurrentSelection(this.getFilteredPlanEditParts());
            }
            return this.templateApplicationTuplesMapForCurrentSelection;
        }

        public Set<Object> getSelectedStates() {
            if (this.selectedStates == null) {
                this.selectedStates = Collections.unmodifiableSet(AppearanceUtil.getSelectedStates(this.getTemplateApplicationTuplesMap(), this.buttonType));
            }
            return this.selectedStates;
        }
    }
}

