/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.cm.actions;

import com.arcway.lib.geometry.Direction;
import com.arcway.planagent.planeditor.FMCAPlanEditorCommonPlugin;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecoration;
import com.arcway.planagent.planeditor.cm.Messages;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.IAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceRO;
import com.arcway.planagent.planmodel.appearance.TextAppearanceTpl;
import de.plans.lib.eclipse.ResourceLoader;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;

public class TextAngle90Decoration
implements IAppearanceButtonDecoration {
    private static TextAngle90Decoration instance = new TextAngle90Decoration();
    private static ImageDescriptor angleto90Image = TextAngle90Decoration.createAngleto90ImageDescriptor();
    private static ImageDescriptor angle90to0Image = TextAngle90Decoration.createAngle90to0ImageDescriptor();

    public static TextAngle90Decoration getInstance() {
        return instance;
    }

    private static ImageDescriptor createAngleto90ImageDescriptor() {
        ImageDescriptor loaded = ResourceLoader.getImageDescriptor((String)"cm/textangle_to90.gif", (Plugin)FMCAPlanEditorCommonPlugin.getDefault());
        return loaded;
    }

    private static ImageDescriptor createAngle90to0ImageDescriptor() {
        ImageDescriptor loaded = ResourceLoader.getImageDescriptor((String)"cm/textangle_90to0.gif", (Plugin)FMCAPlanEditorCommonPlugin.getDefault());
        return loaded;
    }

    public Class<? extends IAppearanceRO>[] getAppearanceClasses() {
        return new Class[]{ITextAppearanceRO.class};
    }

    public Object getStateOfAppearance(IAppearanceRO appearance) {
        return ((ITextAppearanceRO)appearance).getDirection().equalsDirection(Direction.ANGLE_90);
    }

    public String getToolTipText(Object state) {
        return (Boolean)state != false ? Messages.getString("TextAngleDecoration.90to0") : Messages.getString("TextAngleDecoration.to90");
    }

    public ImageDescriptor getButtonImageDescriptor(Object state) {
        return (Boolean)state != false ? angle90to0Image : angleto90Image;
    }

    public IAppearanceTpl[] getAppearanceTemplates(Object state) {
        boolean is90 = (Boolean)state == false;
        TextAppearanceTpl template = new TextAppearanceTpl();
        if (is90) {
            template.setDirection(Direction.ANGLE_90);
        } else {
            template.setDirection(Direction.ANGLE_0);
        }
        return new IAppearanceTpl[]{template};
    }
}

