/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.base.actions;

import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import com.arcway.lib.resource.FileResource;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.planagent.controllinginterface.planeditor.plugin.ContextMenuContext;
import com.arcway.planagent.planeditor.FMCAPlanEditorCommonPlugin;
import com.arcway.planagent.planeditor.base.Messages;
import com.arcway.planagent.planeditor.base.actions.UIAbstractImageAction;
import com.arcway.planagent.planeditor.base.commands.CMSetCommentImage;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithImageSupplementRO;
import de.plans.lib.eclipse.ResourceLoader;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.commands.Command;

public class UISetCommentImage
extends UIAbstractImageAction {
    private static final String ID = "de.plans.fmca.planagent.planeditor.fmc.bd.actions.uisetcommentimage";

    public UISetCommentImage(ContextMenuContext context) {
        super(context);
        this.setText(Messages.getString("UISetCommentImage.Set_Comment_Image"));
        this.setToolTipText(Messages.getString("UISetCommentImage.Sets_the_image"));
        this.setId(ID);
        this.setImageDescriptor(ResourceLoader.getImageDescriptor((String)"picture_edit.png", (Plugin)FMCAPlanEditorCommonPlugin.getDefault()));
    }

    protected boolean isVisibleIfDisabled() {
        return false;
    }

    protected boolean isVisibleInProjectionMode() {
        return false;
    }

    protected Command getCommand(List<PEPlanElement> items) {
        assert (items != null) : "items is null";
        if (this.calculateEnabled() && !items.isEmpty()) {
            IPMPlanElementWithImageSupplementRO planElementWithImage = this.getSelectedPlanElementWithImage(items);
            IStreamResource pngByteArrayAsStreamResource = null;
            FileChooserDialog fileChooser = new FileChooserDialog(new String[]{"*.gif; *.jpg; *.jpeg; *.png; *.ico; *.bmp"}, this.getShell());
            File file = fileChooser.openForLoad();
            if (file != null) {
                FileResource streamResource = new FileResource(file);
                pngByteArrayAsStreamResource = this.loadIntoTempFile((IStreamResource)streamResource);
            }
            if (pngByteArrayAsStreamResource != null) {
                return new CMSetCommentImage(planElementWithImage, pngByteArrayAsStreamResource, super.getCommandContext());
            }
            return null;
        }
        return null;
    }

    @Override
    protected boolean calculateEnabled() {
        IPMPlanElementWithImageSupplementRO planElementWithImage;
        boolean toReturn = false;
        if (super.calculateEnabled() && (planElementWithImage = this.getSelectedPlanElementWithImage()).getImageSupplementRO() != null) {
            toReturn = true;
        }
        return toReturn;
    }
}

