/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.controllinginterface.planagent.plugin;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentFactory;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanAgentExtensionTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanAgentTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanElementTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanTypeNotSupported;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentControllingInterfacePlugin;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentExtensionTypeDescription;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentExtensionTypePlanTypeAssignment;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentTypeDescription;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentTypePlanAgentExtensionTypeAssignment;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanElementTypeDescription;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanFileFactoryDescription;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanTypeDescription;
import com.arcway.planagent.controllinginterface.planfilefactory.IPlanFileFactory;
import com.arcway.planagent.controllinginterface.planviewer.IProjectionType;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class PlanAgentExtensionMgr {
    private static final ILogger LOGGER = Logger.getLogger(PlanAgentExtensionMgr.class);
    private static PlanAgentExtensionMgr singleton;
    private static final String DEFAULT_PLAN_TYPE = "fmc.bd";
    private static final String EXTENSION_POINT_ID_PLAN_TYPES = "plantypes";
    private static final String CONFIG_ELEMENT_NAME_PLAN_TYPE = "PlanTypeDescription";
    private static final String ATTR_PLAN_TYPE_ID = "id";
    private static final String ATTR_PLAN_TYPE_NAME_KEY = "namekey";
    private static final String ATTR_PLAN_TYPE_NAMES_KEY = "nameskey";
    private static final String ATTR_PLAN_TYPE_ICON = "icon";
    private static final String ATTR_PLAN_TYPE_FILE_EXTENSION = "fileExtension";
    private static final String EXTENSION_POINT_ID_PLAN_FILE_FACTORIES = "planfilefactories";
    private static final String CONFIG_ELEMENT_NAME_PLAN_FILE_FACTORIES = "PlanFileFactoryDescription";
    private static final String ATTR_PLAN_FILE_FACTORY_PLAN_TYPE_ID = "planTypeID";
    private static final String ATTR_PLAN_FILE_FACTORY_TEMPLATE_NAME = "templateName";
    private static final String ATTR_PLAN_FILE_FACTORY_PLAN_FILE_FACTORY = "planFileFactory";
    private static final String ATTR_PLAN_FILE_FACTORY_PRIORITY = "priority";
    private static final String EXTENSION_POINT_ID_PLAN_ELEMENT_TYPES = "planelementtypes";
    private static final String CONFIG_ELEMENT_NAME_PLAN_ELEMENT_TYPE = "PlanElementTypeDescription";
    private static final String ATTR_PLAN_ELEMENT_TYPE_ID = "id";
    private static final String ATTR_PLAN_ELEMENT_TYPE_NAME_KEY = "namekey";
    private static final String ATTR_PLAN_ELEMENT_TYPE_NAMES_KEY = "nameskey";
    private static final String ATTR_PLAN_ELEMENT_TYPE_ICON = "icon";
    private static final String ATTR_PLAN_ELEMENT_TYPE_PRORITY = "priority";
    private static final String EXTENSION_POINT_ID_PLAN_AGENT_TYPES = "planagenttypes";
    private static final String CONFIG_ELEMENT_NAME_PLAN_AGENT_TYPE = "PlanAgentTypeDescription";
    private static final String ATTR_PLAN_AGENT_TYPE_ID = "planAgentTypeID";
    private static final String ATTR_PLAN_AGENT_TYPE_NAME = "name";
    private static final String ATTR_PLAN_AGENT_TYPE_ICON = "icon";
    private static final String ATTR_PLAN_AGENT_TYPE_ICON_LARGE = "icon_large";
    private static final String ATTR_PLAN_AGENT_TYPE_FACTORY = "planAgentFactory";
    private static final String EXTENSION_POINT_ID_PLAN_AGENT_EXTENION_TYPES = "planagentextensiontypes";
    private static final String CONFIG_ELEMENT_NAME_PLAN_AGENT_EXTENSION_TYPE = "PlanAgentExtensionTypeDescription";
    private static final String ATTR_PLAN_AGENT_EXTENSION_TYPE_PLAN_AGENT_EXTENSION_TYPE_ID = "planAgentExtensionTypeID";
    private static final String EXTENSION_POINT_ID_PLAN_AGENT_EXTENSION_TYPE_PLAN_TYPE_ASSIGNMENTS = "planagentextensiontypeplantypeassignments";
    private static final String CONFIG_ELEMENT_NAME_PLAN_AGENT_EXTENSION_TYPE_PLAN_TYPE_ASSIGNMENT = "PlanAgentExtensionTypePlanTypeAssignment";
    private static final String ATTR_PLAN_AGENT_EXTENSION_TYPE_PLAN_TYPE_ASSIGNMENT_PLAN_AGENT_EXTENSION_ID = "planAgentExtensionTypeID";
    private static final String ATTR_PLAN_AGENT_EXTENSION_TYPE_PLAN_TYPE_ASSIGNMENT_PLAN_TYPE_ID = "planTypeID";
    private static final String EXTENSION_POINT_ID_PLAN_AGENT_TYPE_PLAN_AGENT_EXTENSION_TYPE_ASSIGNMENTS = "planagenttypeplanagentextensiontypeassignments";
    private static final String CONFIG_ELEMENT_NAME_PLAN_AGENT_TYPE_PLAN_AGENT_EXTENSION_TYPE_ASSIGNMENT = "PlanAgentTypePlanAgentExtensionTypeAssignment";
    private static final String ATTR_PLAN_AGENT_TYPE_PLAN_AGENT_EXTENSION_TYPE_ASSIGNMENT_PLAN_AGENT_TYPE_ID = "planAgentTypeID";
    private static final String ATTR_PLAN_AGENT_TYPE_PLAN_AGENT_EXTENSION_TYPE_ASSIGNMENT_PLAN_AGENT_EXTENSION_TYPE_ID = "planAgentExtensionTypeID";
    private static final String EXTENSION_POINT_ID_PROJECTION_TYPES = "projectiontype";
    private static final String CONFIG_ELEMENT_NAME_PROJECTION_TYPE = "projectiontype";
    private static final String ATTR_PROJECTION_TYPE_PROJECTION_TYPE_ID = "id";
    private static final String ATTR_PROJECTION_TYPE_PROJECTION_TYPE = "projectiontype";
    private List<PlanTypeDescription> planTypes;
    private List<PlanFileFactoryDescription> planFileFactories;
    private List<PlanElementTypeDescription> planElementTypes;
    private List<PlanAgentExtensionTypeDescription> planAgentExtensionTypes;
    private List<PlanAgentExtensionTypePlanTypeAssignment> planAgentExtensionTypePlanTypeAssignments;
    private List<PlanAgentTypeDescription> planAgentTypes;
    private List<PlanAgentTypePlanAgentExtensionTypeAssignment> planAgentTypePlanAgentExtensionTypeAssignments;
    private Map<String, IProjectionType> projectionTypeID2projectionTypes;

    private PlanAgentExtensionMgr() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlanAgentExtensionMgr getDefault() {
        Class<PlanAgentExtensionMgr> clazz = PlanAgentExtensionMgr.class;
        synchronized (PlanAgentExtensionMgr.class) {
            if (singleton == null) {
                singleton = new PlanAgentExtensionMgr();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private String getPlugInID() {
        return PlanAgentControllingInterfacePlugin.getDefault().getPlugInID();
    }

    public List<PlanTypeDescription> getPlanTypeDescriptions() {
        if (this.planTypes == null) {
            IExtension[] extensions;
            this.planTypes = new ArrayList<PlanTypeDescription>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            assert (registry != null) : "registry must not be null";
            IExtensionPoint extensionPoint = registry.getExtensionPoint(this.getPlugInID(), EXTENSION_POINT_ID_PLAN_TYPES);
            assert (extensionPoint != null) : "extensionPoint must not be null";
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension currentExtension = iExtensionArray[n2];
                Bundle bundle = Platform.getBundle((String)currentExtension.getContributor().getName());
                URL pluginURL = bundle.getEntry("/");
                URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{pluginURL});
                IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                    if (CONFIG_ELEMENT_NAME_PLAN_TYPE.equals(currentConfigElement.getName())) {
                        String planTypeID = currentConfigElement.getAttribute("id");
                        String planTypeNameKey = currentConfigElement.getAttribute("namekey");
                        String planTypeNamesKey = currentConfigElement.getAttribute("nameskey");
                        String iconFilePath = currentConfigElement.getAttribute("icon");
                        String iconLargeFilePath = currentConfigElement.getAttribute(ATTR_PLAN_AGENT_TYPE_ICON_LARGE);
                        String fileExtension = currentConfigElement.getAttribute(ATTR_PLAN_TYPE_FILE_EXTENSION);
                        if (planTypeID != null && planTypeNameKey != null && planTypeNamesKey != null && iconFilePath != null && iconLargeFilePath != null && fileExtension != null) {
                            try {
                                URL iconURL = new URL(pluginURL, iconFilePath);
                                URL iconLargeURL = new URL(pluginURL, iconLargeFilePath);
                                PlanTypeDescription planTypeDescription = new PlanTypeDescription(urlClassLoader, planTypeID, planTypeNameKey, planTypeNamesKey, iconURL, iconLargeURL, fileExtension);
                                this.planTypes.add(planTypeDescription);
                            }
                            catch (MalformedURLException e) {
                                LOGGER.error("Malformed icon file path in Extension " + currentExtension.getUniqueIdentifier() + "(" + currentExtension.getLabel() + ")");
                            }
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return this.planTypes;
    }

    public List<PlanFileFactoryDescription> getPlanFileFactoryDescriptions() {
        if (this.planFileFactories == null) {
            IExtension[] extensions;
            this.planFileFactories = new ArrayList<PlanFileFactoryDescription>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            assert (registry != null) : "registry must not be null";
            IExtensionPoint extensionPoint = registry.getExtensionPoint(this.getPlugInID(), EXTENSION_POINT_ID_PLAN_FILE_FACTORIES);
            assert (extensionPoint != null) : "extensionPoint must not be null";
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension currentExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                    if (CONFIG_ELEMENT_NAME_PLAN_FILE_FACTORIES.equals(currentConfigElement.getName())) {
                        String planTypeID = currentConfigElement.getAttribute("planTypeID");
                        String templateName = currentConfigElement.getAttribute(ATTR_PLAN_FILE_FACTORY_TEMPLATE_NAME);
                        String priorityAsString = currentConfigElement.getAttribute("priority");
                        int priority = Integer.parseInt(priorityAsString);
                        IPlanFileFactory planFileFactory = null;
                        try {
                            Object instance = currentConfigElement.createExecutableExtension(ATTR_PLAN_FILE_FACTORY_PLAN_FILE_FACTORY);
                            if (instance instanceof IPlanFileFactory) {
                                planFileFactory = (IPlanFileFactory)instance;
                            } else {
                                LOGGER.error("Created instance of plan file factory is not of type IPlanFileFactory.");
                            }
                        }
                        catch (CoreException e) {
                            LOGGER.error("Cannot instanciate plan file factory.");
                        }
                        if (planTypeID != null && templateName != null && planFileFactory != null) {
                            PlanFileFactoryDescription planFileFactoryDescription = new PlanFileFactoryDescription(planTypeID, templateName, planFileFactory, priority);
                            this.planFileFactories.add(planFileFactoryDescription);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            Collections.sort(this.planFileFactories);
        }
        return this.planFileFactories;
    }

    public List<PlanElementTypeDescription> getPlanElementTypeDescriptions() {
        if (this.planElementTypes == null) {
            IExtension[] extensions;
            this.planElementTypes = new ArrayList<PlanElementTypeDescription>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            assert (registry != null) : "registry must not be null";
            IExtensionPoint extensionPoint = registry.getExtensionPoint(this.getPlugInID(), EXTENSION_POINT_ID_PLAN_ELEMENT_TYPES);
            assert (extensionPoint != null) : "extensionPoint must not be null";
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension currentExtension = iExtensionArray[n2];
                Bundle bundle = Platform.getBundle((String)currentExtension.getContributor().getName());
                URL pluginURL = bundle.getEntry("/");
                URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{pluginURL});
                IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                    if (CONFIG_ELEMENT_NAME_PLAN_ELEMENT_TYPE.equals(currentConfigElement.getName())) {
                        String planElementTypeID = currentConfigElement.getAttribute("id");
                        String planElementTypeNameKey = currentConfigElement.getAttribute("namekey");
                        String planElementTypeNamesKey = currentConfigElement.getAttribute("nameskey");
                        String planElementTypeIcon = currentConfigElement.getAttribute("icon");
                        String planElementTypePriority = currentConfigElement.getAttribute("priority");
                        if (planElementTypeID != null && planElementTypeNameKey != null && planElementTypeNamesKey != null) {
                            URL iconURL = null;
                            if (planElementTypeIcon != null && planElementTypeIcon.length() > 0) {
                                try {
                                    iconURL = new URL(pluginURL, planElementTypeIcon);
                                }
                                catch (MalformedURLException e) {
                                    LOGGER.error("Malformed icon file path in Extension " + currentExtension.getUniqueIdentifier() + "(" + currentExtension.getLabel() + ")");
                                }
                            }
                            PlanElementTypeDescription planElementDescription = new PlanElementTypeDescription(urlClassLoader, planElementTypeID, planElementTypeNameKey, planElementTypeNamesKey, iconURL, Integer.parseInt(planElementTypePriority));
                            this.planElementTypes.add(planElementDescription);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            Collections.sort(this.planElementTypes, new Comparator(){

                public int compare(Object o1, Object o2) {
                    PlanElementTypeDescription planElementTypeDescription1 = (PlanElementTypeDescription)o1;
                    PlanElementTypeDescription planElementTypeDescription2 = (PlanElementTypeDescription)o2;
                    return planElementTypeDescription1.getPriority() - planElementTypeDescription2.getPriority();
                }
            });
        }
        return this.planElementTypes;
    }

    public URL getPlanElementIconForType(String planElementTypeID) throws EXPlanElementTypeUnknown {
        assert (planElementTypeID != null);
        PlanElementTypeDescription description = this.getPlanElementTypeDescriptionForType(planElementTypeID);
        return description.getIconURL();
    }

    public URL getPlanIconForType(String planTypeID) throws EXPlanTypeUnknown {
        assert (planTypeID != null);
        PlanTypeDescription description = this.getPlanTypeDescriptionForType(planTypeID);
        return description.getIconURL();
    }

    public String getPlanElementNameForType(String planElementTypeID, Locale contentLocale) throws EXPlanElementTypeUnknown {
        assert (planElementTypeID != null);
        PlanElementTypeDescription description = this.getPlanElementTypeDescriptionForType(planElementTypeID);
        return description.getPlanElementTypeName(contentLocale);
    }

    public PlanElementTypeDescription getPlanElementTypeDescriptionForType(String planElementTypeID) throws EXPlanElementTypeUnknown {
        assert (planElementTypeID != null);
        PlanElementTypeDescription description = null;
        Iterator<PlanElementTypeDescription> i = this.getPlanElementTypeDescriptions().iterator();
        while (description == null && i.hasNext()) {
            PlanElementTypeDescription currentDescription = i.next();
            if (!currentDescription.getPlanElementTypeID().equals(planElementTypeID)) continue;
            description = currentDescription;
        }
        if (description == null) {
            throw new EXPlanElementTypeUnknown(planElementTypeID);
        }
        return description;
    }

    public PlanTypeDescription getPlanTypeDescriptionForType(String planTypeID) throws EXPlanTypeUnknown {
        assert (planTypeID != null) : "planTypeID can't be null";
        PlanTypeDescription description = null;
        Iterator<PlanTypeDescription> i = this.getPlanTypeDescriptions().iterator();
        while (description == null && i.hasNext()) {
            PlanTypeDescription currentDescription = i.next();
            if (!currentDescription.getPlanTypeID().equals(planTypeID)) continue;
            description = currentDescription;
        }
        if (description == null) {
            throw new EXPlanTypeUnknown(planTypeID);
        }
        return description;
    }

    public List<PlanAgentExtensionTypeDescription> getPlanAgentExtensionTypeDescriptions() {
        if (this.planAgentExtensionTypes == null) {
            IExtension[] extensions;
            this.planAgentExtensionTypes = new ArrayList<PlanAgentExtensionTypeDescription>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            assert (registry != null) : "registry must not be null";
            IExtensionPoint extensionPoint = registry.getExtensionPoint(this.getPlugInID(), EXTENSION_POINT_ID_PLAN_AGENT_EXTENION_TYPES);
            assert (extensionPoint != null) : "extensionPoint must not be null";
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension currentExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    String planAgentExtensionTypeID;
                    IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                    if (CONFIG_ELEMENT_NAME_PLAN_AGENT_EXTENSION_TYPE.equals(currentConfigElement.getName()) && (planAgentExtensionTypeID = currentConfigElement.getAttribute("planAgentExtensionTypeID")) != null) {
                        PlanAgentExtensionTypeDescription planAgentExtensionTypeDescription = new PlanAgentExtensionTypeDescription(planAgentExtensionTypeID);
                        this.planAgentExtensionTypes.add(planAgentExtensionTypeDescription);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return this.planAgentExtensionTypes;
    }

    public List<PlanAgentExtensionTypePlanTypeAssignment> getPlanAgentExtensionTypePlanTypeAssignments() {
        if (this.planAgentExtensionTypePlanTypeAssignments == null) {
            IExtension[] extensions;
            this.planAgentExtensionTypePlanTypeAssignments = new ArrayList<PlanAgentExtensionTypePlanTypeAssignment>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            assert (registry != null) : "registry must not be null";
            IExtensionPoint extensionPoint = registry.getExtensionPoint(this.getPlugInID(), EXTENSION_POINT_ID_PLAN_AGENT_EXTENSION_TYPE_PLAN_TYPE_ASSIGNMENTS);
            assert (extensionPoint != null) : "extensionPoint must not be null";
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension currentExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                    if (CONFIG_ELEMENT_NAME_PLAN_AGENT_EXTENSION_TYPE_PLAN_TYPE_ASSIGNMENT.equals(currentConfigElement.getName())) {
                        String planAgentExtensionTypeID = currentConfigElement.getAttribute("planAgentExtensionTypeID");
                        String planTypeID = currentConfigElement.getAttribute("planTypeID");
                        if (planAgentExtensionTypeID != null && planTypeID != null) {
                            PlanAgentExtensionTypePlanTypeAssignment planAgentExtensionTypePlanTypeAssignment = new PlanAgentExtensionTypePlanTypeAssignment(planAgentExtensionTypeID, planTypeID);
                            this.planAgentExtensionTypePlanTypeAssignments.add(planAgentExtensionTypePlanTypeAssignment);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return this.planAgentExtensionTypePlanTypeAssignments;
    }

    public List<PlanAgentTypeDescription> getPlanAgentTypeDescriptions() {
        if (this.planAgentTypes == null) {
            IExtension[] extensions;
            this.planAgentTypes = new ArrayList<PlanAgentTypeDescription>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            assert (registry != null) : "registry must not be null";
            IExtensionPoint extensionPoint = registry.getExtensionPoint(this.getPlugInID(), EXTENSION_POINT_ID_PLAN_AGENT_TYPES);
            assert (extensionPoint != null) : "extensionPoint must not be null";
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension currentExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                    if (CONFIG_ELEMENT_NAME_PLAN_AGENT_TYPE.equals(currentConfigElement.getName())) {
                        String planAgentTypeID = currentConfigElement.getAttribute("planAgentTypeID");
                        String planAgentTypeName = currentConfigElement.getAttribute(ATTR_PLAN_AGENT_TYPE_NAME);
                        String iconFilePath = currentConfigElement.getAttribute("icon");
                        IPlanAgentFactory planAgentFactory = null;
                        try {
                            Object instance = currentConfigElement.createExecutableExtension(ATTR_PLAN_AGENT_TYPE_FACTORY);
                            if (instance instanceof IPlanAgentFactory) {
                                planAgentFactory = (IPlanAgentFactory)instance;
                            } else {
                                LOGGER.error("Created instance of plan agent factory is not of type IPlanAgentFactory.");
                            }
                        }
                        catch (CoreException e) {
                            LOGGER.error("Cannot instanciate plan agent factory.");
                        }
                        if (planAgentTypeID != null && planAgentTypeName != null && iconFilePath != null && planAgentFactory != null) {
                            try {
                                String namespace = currentExtension.getContributor().getName();
                                Bundle bundle = Platform.getBundle((String)namespace);
                                URL pluginURL = bundle.getEntry("/");
                                URL iconURL = new URL(pluginURL, iconFilePath);
                                PlanAgentTypeDescription planAgentTypeDescription = new PlanAgentTypeDescription(planAgentTypeID, planAgentTypeName, iconURL, planAgentFactory);
                                this.planAgentTypes.add(planAgentTypeDescription);
                            }
                            catch (MalformedURLException e) {
                                LOGGER.error("Malformed icon file path in Extension " + currentExtension.getUniqueIdentifier() + "(" + currentExtension.getLabel() + ")");
                            }
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return this.planAgentTypes;
    }

    public List<PlanAgentTypePlanAgentExtensionTypeAssignment> getPlanAgentTypePlanAgentExtensionTypeAssignments() {
        if (this.planAgentTypePlanAgentExtensionTypeAssignments == null) {
            IExtension[] extensions;
            this.planAgentTypePlanAgentExtensionTypeAssignments = new ArrayList<PlanAgentTypePlanAgentExtensionTypeAssignment>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            assert (registry != null) : "registry must not be null";
            IExtensionPoint extensionPoint = registry.getExtensionPoint(this.getPlugInID(), EXTENSION_POINT_ID_PLAN_AGENT_TYPE_PLAN_AGENT_EXTENSION_TYPE_ASSIGNMENTS);
            assert (extensionPoint != null) : "extensionPoint must not be null";
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension currentExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                    if (CONFIG_ELEMENT_NAME_PLAN_AGENT_TYPE_PLAN_AGENT_EXTENSION_TYPE_ASSIGNMENT.equals(currentConfigElement.getName())) {
                        String planAgentTypeID = currentConfigElement.getAttribute("planAgentTypeID");
                        String planAgentExtensionTypeID = currentConfigElement.getAttribute("planAgentExtensionTypeID");
                        if (planAgentTypeID != null && planAgentExtensionTypeID != null) {
                            PlanAgentTypePlanAgentExtensionTypeAssignment planAgentTypePlanAgentExtensionTypeAssignment = new PlanAgentTypePlanAgentExtensionTypeAssignment(planAgentTypeID, planAgentExtensionTypeID);
                            this.planAgentTypePlanAgentExtensionTypeAssignments.add(planAgentTypePlanAgentExtensionTypeAssignment);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return this.planAgentTypePlanAgentExtensionTypeAssignments;
    }

    public PlanAgentTypeDescription getPlanAgentTypeDescriptionForType(String planAgentTypeID) throws EXPlanAgentTypeUnknown {
        assert (planAgentTypeID != null);
        PlanAgentTypeDescription planAgentTypeDescription = null;
        Iterator<PlanAgentTypeDescription> i = this.getPlanAgentTypeDescriptions().iterator();
        while (planAgentTypeDescription == null && i.hasNext()) {
            PlanAgentTypeDescription currentPlanAgentTypeDescription = i.next();
            if (!planAgentTypeID.equals(currentPlanAgentTypeDescription.getPlanAgentTypeID())) continue;
            planAgentTypeDescription = currentPlanAgentTypeDescription;
        }
        if (planAgentTypeDescription == null) {
            throw new EXPlanAgentTypeUnknown(planAgentTypeID);
        }
        return planAgentTypeDescription;
    }

    public PlanAgentExtensionTypeDescription getPlanAgentExtensionTypeDescriptionsForType(String planAgentExtensionTypeID) throws EXPlanAgentExtensionTypeUnknown {
        assert (planAgentExtensionTypeID != null);
        PlanAgentExtensionTypeDescription planAgentExtensionTypeDescription = null;
        Iterator<PlanAgentExtensionTypeDescription> i = this.getPlanAgentExtensionTypeDescriptions().iterator();
        while (planAgentExtensionTypeDescription == null && i.hasNext()) {
            PlanAgentExtensionTypeDescription currentPlanAgentExtensionTypeDescription = i.next();
            if (!planAgentExtensionTypeID.equals(currentPlanAgentExtensionTypeDescription.getPlanAgentExtensionTypeID())) continue;
            planAgentExtensionTypeDescription = currentPlanAgentExtensionTypeDescription;
        }
        if (planAgentExtensionTypeDescription == null) {
            throw new EXPlanAgentExtensionTypeUnknown(planAgentExtensionTypeID);
        }
        return planAgentExtensionTypeDescription;
    }

    public Collection<PlanAgentExtensionTypeDescription> getNeededPlanAgentExtensionTypes(String planAgentTypeID) throws EXPlanAgentTypeUnknown, EXPlanAgentExtensionTypeUnknown {
        assert (planAgentTypeID != null);
        ArrayList<PlanAgentExtensionTypeDescription> neededExtensionTypes = new ArrayList<PlanAgentExtensionTypeDescription>();
        PlanAgentTypeDescription planAgentTypeDescription = this.getPlanAgentTypeDescriptionForType(planAgentTypeID);
        assert (planAgentTypeDescription.getPlanAgentTypeID().equals(planAgentTypeID));
        for (PlanAgentTypePlanAgentExtensionTypeAssignment assignment : this.getPlanAgentTypePlanAgentExtensionTypeAssignments()) {
            if (!planAgentTypeID.equals(assignment.getPlanAgentTypeID())) continue;
            String planAgentExtensionTypeID = assignment.getPlanAgentExtensionTypeID();
            PlanAgentExtensionTypeDescription planAgentExtensionTypeDescription = this.getPlanAgentExtensionTypeDescriptionsForType(planAgentExtensionTypeID);
            neededExtensionTypes.add(planAgentExtensionTypeDescription);
        }
        return neededExtensionTypes;
    }

    public PlanAgentExtensionTypePlanTypeAssignment getPlanAgentExtensionTypePlanTypeAssignmentForTypes(String planTypeID, String planAgentExtensionTypeID) throws EXPlanTypeNotSupported {
        assert (planTypeID != null);
        assert (planAgentExtensionTypeID != null);
        PlanAgentExtensionTypePlanTypeAssignment assignment = null;
        Iterator<PlanAgentExtensionTypePlanTypeAssignment> i = this.getPlanAgentExtensionTypePlanTypeAssignments().iterator();
        while (assignment == null && i.hasNext()) {
            PlanAgentExtensionTypePlanTypeAssignment currentAssignment = i.next();
            if (!currentAssignment.getPlanTypeID().equals(planTypeID) || !currentAssignment.getPlanExtensionTypeID().equals(planAgentExtensionTypeID)) continue;
            assignment = currentAssignment;
        }
        if (assignment == null) {
            throw new EXPlanTypeNotSupported(planTypeID, planAgentExtensionTypeID);
        }
        return assignment;
    }

    public PlanAgentTypeDescription getPlanAgentTypeDescriptionAndCheckAvailability(String planAgentTypeID, String planTypeID) throws EXPlanTypeUnknown, EXPlanAgentTypeUnknown, EXPlanAgentExtensionTypeUnknown, EXPlanTypeNotSupported {
        assert (planAgentTypeID != null);
        assert (planTypeID != null);
        this.getPlanTypeDescriptionForType(planTypeID);
        for (PlanAgentExtensionTypeDescription planAgentExtensionTypeDescription : this.getNeededPlanAgentExtensionTypes(planAgentTypeID)) {
            this.getPlanAgentExtensionTypePlanTypeAssignmentForTypes(planTypeID, planAgentExtensionTypeDescription.getPlanAgentExtensionTypeID());
        }
        return this.getPlanAgentTypeDescriptionForType(planAgentTypeID);
    }

    public String getDefaultPlanTypeID() {
        return DEFAULT_PLAN_TYPE;
    }

    public IProjectionType getProjectionType(String projectionTypeID) {
        if (this.projectionTypeID2projectionTypes == null) {
            IExtension[] extensions;
            this.projectionTypeID2projectionTypes = new HashMap<String, IProjectionType>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            assert (registry != null) : "registry must not be null";
            IExtensionPoint extensionPoint = registry.getExtensionPoint(this.getPlugInID(), "projectiontype");
            assert (extensionPoint != null) : "extensionPoint must not be null";
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension currentExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                    if ("projectiontype".equals(currentConfigElement.getName())) {
                        String readProjectionTypeID = currentConfigElement.getAttribute("id");
                        IProjectionType projectionType = null;
                        try {
                            Object instance = currentConfigElement.createExecutableExtension("projectiontype");
                            if (instance instanceof IProjectionType) {
                                projectionType = (IProjectionType)instance;
                            } else {
                                LOGGER.error("Created instance of projection type is not of type IProjectionType.");
                            }
                        }
                        catch (CoreException e) {
                            LOGGER.error("Cannot instanciate projection type.");
                        }
                        if (readProjectionTypeID != null && projectionType != null) {
                            this.projectionTypeID2projectionTypes.put(readProjectionTypeID, projectionType);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return this.projectionTypeID2projectionTypes.get(projectionTypeID);
    }
}

