/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.controllinginterface.lib.projections;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.devicedrivers.DeviceDriverGetBounds;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriver;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.planagent.controllinginterface.planviewer.IProjection;

public class CounterProjection
implements IProjection {
    private static final double spacing = 0.7;
    private static final double cornerRadius = 10.0;
    private static final FillStyle backgroundFillStyle = FillStyle.SOLID;
    private static final FillColor backgroundFillColor = new FillColor(Color.RED.gotoBlack(0.2));
    private static final LineStyle backgroundLineStyle = LineStyle.SOLID;
    private static final Color backgroundLineColor = Color.WHITE;
    private static final double backgroundLineThickness = 0.2;
    private static final Alignment textAlignment = new Alignment(2, 16);
    private static final TextStyle textStyle = new TextStyle("Arial", true, false);
    private static final Color textColorBright = Color.WHITE;
    private static final Color textColorDark = Color.BLACK;
    private final String countString;
    private final double backgroundWidth = 13.0;
    private final double backgroundHeight = 6.0;
    private final FillColor color;
    private final double backgroundWidthScaled;

    public CounterProjection(int count) {
        this(String.valueOf(count), null);
    }

    public CounterProjection(int count, Color color) {
        this(String.valueOf(count), color);
    }

    public CounterProjection(String text, Color color) {
        this.countString = text;
        this.color = new FillColor(color);
        DeviceDriverGetBounds deviceDriver = new DeviceDriverGetBounds(null);
        Device device = new Device((IDeviceDriver)deviceDriver, (Transformation)Transformation.NOP);
        double yOffset = 0.7;
        double height = 6.0 - 2.0 * yOffset;
        double textLength = device.getTextLength(this.countString, textStyle, height);
        this.backgroundWidthScaled = Math.max(textLength + 1.4, 13.0);
        deviceDriver.dispose();
    }

    @Override
    public String getProjectionTypeID() {
        return "counter";
    }

    public String getText() {
        return this.countString;
    }

    public Color getColor() {
        return this.color.foregroundColor;
    }

    @Override
    public void drawProjection(Device device) {
        double yOffset = 0.7;
        double height = 6.0 - 2.0 * yOffset;
        Corners background = new Corners();
        background.add((Point)new Corner(0.0, 0.0, 10.0));
        background.add((Point)new Corner(this.backgroundWidthScaled, 0.0, 10.0));
        background.add((Point)new Corner(this.backgroundWidthScaled, 6.0, 10.0));
        background.add((Point)new Corner(0.0, 6.0, 10.0));
        device.polygon(background, this.color == null ? backgroundFillColor : this.color, backgroundFillStyle, 0.2, backgroundLineColor, backgroundLineStyle);
        double xOffset = 0.7;
        double width = this.backgroundWidthScaled - 2.0 * xOffset;
        Corners digitArea = new Corners();
        digitArea.add((Point)new Corner(xOffset, yOffset, 10.0));
        digitArea.add((Point)new Corner(xOffset + width, yOffset, 10.0));
        digitArea.add((Point)new Corner(xOffset + width, yOffset + height, 10.0));
        digitArea.add((Point)new Corner(xOffset, yOffset + height, 10.0));
        Rectangle r = digitArea.getBounds();
        Color textColor = this.color == null ? textColorBright : (this.color.foregroundColor.getGray().r >= 128 ? textColorDark : textColorBright);
        device.text(r, textAlignment, this.countString, textStyle, height, textColor, false);
    }

    @Override
    public Point getPosition(Rectangle area) {
        return new Point(area.lowerRight.x - 6.5, area.upperLeft.y - 3.0);
    }

    @Override
    public Rectangle getBoundary() {
        return new Rectangle(Math.floor(-0.1), Math.floor(-0.1), Math.ceil(this.backgroundWidthScaled + 0.1), Math.ceil(6.1));
    }
}

