/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.operating;

import com.arcway.lib.operating.AbstractProcessor;
import com.arcway.lib.operating.CancelMode;
import com.arcway.lib.operating.EXProcessingCanceled;
import com.arcway.lib.operating.IProcessMonitor;
import com.arcway.lib.operating.IProcessStepLabel;

public abstract class Monitor
implements AbstractProcessor.IMonitorQuantifiedWithCancel,
AbstractProcessor.IMonitorUnquantifiedWithCancel {
    private final AbstractProcessor processor;
    private final CancelMode cancelMode;
    private final IProcessMonitor processMonitor;
    private boolean isTaskToCancel = false;

    public static Monitor createProcessingMonitor(AbstractProcessor processor, CancelMode cancelMode, AbstractProcessor.QuantificationMode quantificationMode, IProcessMonitor processMonitor) {
        Monitor processingState;
        if (quantificationMode == AbstractProcessor.QuantificationMode.QUANTIFIED_PROCESS) {
            processingState = new ProcessingStateQuantified(processor, cancelMode, processMonitor);
        } else if (quantificationMode == AbstractProcessor.QuantificationMode.UNQUANTIFIED_PROCESS) {
            processingState = new ProcessingStateUnquantified(processor, cancelMode, processMonitor);
        } else {
            throw new IllegalArgumentException();
        }
        return processingState;
    }

    private Monitor(AbstractProcessor processor, CancelMode cancelMode, IProcessMonitor processMonitor) {
        this.processor = processor;
        this.cancelMode = cancelMode;
        this.processMonitor = processMonitor;
    }

    public abstract void initTask();

    public abstract void beginTask(int var1);

    @Override
    public abstract void reportUnquantifiedProgress(IProcessStepLabel var1);

    @Override
    public abstract void reportQuantifiedProgress(int var1, IProcessStepLabel var2);

    @Override
    public abstract void reportQuantifiedProgress(int var1);

    public boolean isTaskToCancel() {
        if (!this.isTaskToCancel && this.getCancelMode() == CancelMode.CAN_BE_CANCELED) {
            this.isTaskToCancel = this.getProcessMonitor().isTaskToCancel();
        }
        return this.isTaskToCancel;
    }

    @Override
    public void checkForCancel() throws EXProcessingCanceled {
        if (this.isTaskToCancel()) {
            throw new EXProcessingCanceled();
        }
    }

    public abstract void reportCancelingInProgress();

    public abstract void endTask();

    protected final IProcessMonitor getProcessMonitor() {
        return this.processMonitor;
    }

    protected final AbstractProcessor getProcessor() {
        return this.processor;
    }

    protected final CancelMode getCancelMode() {
        return this.cancelMode;
    }

    /* synthetic */ Monitor(AbstractProcessor abstractProcessor, CancelMode cancelMode, IProcessMonitor iProcessMonitor, Monitor monitor) {
        this(abstractProcessor, cancelMode, iProcessMonitor);
    }

    private static class ProcessingStateQuantified
    extends Monitor {
        private ProcessingStateQuantified(AbstractProcessor processor, CancelMode cancelMode, IProcessMonitor processMonitor) {
            super(processor, cancelMode, processMonitor, null);
        }

        @Override
        public void initTask() {
            this.getProcessMonitor().initTask(this.getProcessor().getProcessorLabelProvider().getProcessLabel(), this.getCancelMode());
        }

        @Override
        public void beginTask(int workTotal) {
            this.getProcessMonitor().beginQuantifiedTask(workTotal);
        }

        @Override
        public void reportUnquantifiedProgress(IProcessStepLabel whatsNext) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reportQuantifiedProgress(int workSinceBeginning, IProcessStepLabel whatsNext) {
            this.getProcessMonitor().reportQuantifiedProgress(workSinceBeginning, whatsNext);
        }

        @Override
        public void reportQuantifiedProgress(int workSinceBeginning) {
            this.getProcessMonitor().reportQuantifiedProgress(workSinceBeginning);
        }

        @Override
        public void reportCancelingInProgress() {
            this.getProcessMonitor().reportCancelingInProgress();
        }

        @Override
        public void endTask() {
            this.getProcessMonitor().endTask();
        }
    }

    private static class ProcessingStateUnquantified
    extends Monitor {
        private ProcessingStateUnquantified(AbstractProcessor processor, CancelMode cancelMode, IProcessMonitor processMonitor) {
            super(processor, cancelMode, processMonitor, null);
        }

        @Override
        public void initTask() {
            this.getProcessMonitor().initTask(this.getProcessor().getProcessorLabelProvider().getProcessLabel(), this.getCancelMode());
        }

        @Override
        public void beginTask(int workTotal) {
            this.getProcessMonitor().beginUnquantifiedTask();
        }

        @Override
        public void reportUnquantifiedProgress(IProcessStepLabel whatsNext) {
            this.getProcessMonitor().reportUnquantifiedProgress(whatsNext);
        }

        @Override
        public void reportQuantifiedProgress(int workSinceBeginning, IProcessStepLabel whatsNext) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reportQuantifiedProgress(int workSinceBeginning) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reportCancelingInProgress() {
            this.getProcessMonitor().reportCancelingInProgress();
        }

        @Override
        public void endTask() {
            this.getProcessMonitor().endTask();
        }
    }
}

