/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.codec.data.codecs.canonicalstring;

import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.codec.data.EXDataAssemblingFailed;
import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.EXUnknownFlagOrPropertyOrChildRoleForStructuredData;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.IElementaryDataFactory;
import com.arcway.lib.codec.data.IElementaryDataType;
import com.arcway.lib.codec.data.IKey;
import com.arcway.lib.codec.data.IStructuredDataFactory;
import com.arcway.lib.codec.data.IStructuredDataType;
import com.arcway.lib.codec.data.Key;
import com.arcway.lib.codec.data.SubDataType;
import com.arcway.lib.codec.data.codecs.canonicalstring.EXCanonicalStringDecodingFailed;
import com.arcway.lib.codec.data.codecs.canonicalstring.EXExcessCharacters;
import com.arcway.lib.codec.data.codecs.canonicalstring.EXMalformedCanonicalString;
import com.arcway.lib.codec.data.codecs.canonicalstring.EXPrematureEndOfCanonicalString;
import com.arcway.lib.codec.data.codecs.canonicalstring.EXPropertyDataFoundForChild;
import com.arcway.lib.codec.data.codecs.canonicalstring.EXSeveralSubDatasFoundForProperty;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.tuples.ThreeTuple;
import com.arcway.lib.java.tuples.Tuple;

public class CanonicalStringCoDecForData {
    private static final char OBJECT_START_DELIMITER_CHARACTER = '(';
    private static final char OBJECT_END_DELIMITER_CHARACTER = ')';
    private static final char ROLES_SEPARATOR_CHARACTER = ',';
    private static final char ROLEKEY_SEPARATOR_CHARACTER = '=';

    public static String encodeIntoCanonicalString(IDataType dataType, Object data) {
        StringBuilder canonicalStringBuilder = new StringBuilder();
        CanonicalStringCoDecForData.encodeIntoCanonicalString(dataType, data, canonicalStringBuilder);
        return canonicalStringBuilder.toString();
    }

    private static void encodeIntoCanonicalString(IDataType dataType, Object data, StringBuilder canonicalString) {
        Class<? extends IDataType> type = dataType.getStructureType();
        IDataType concreteDataType = dataType.getConcreteDataType();
        if (!concreteDataType.isNull(data)) {
            if (IElementaryDataType.class.isAssignableFrom(type)) {
                IElementaryDataType elementaryDataType = (IElementaryDataType)concreteDataType;
                CanonicalStringCoDecForData.encodeElementaryDataIntoCanonicalString(elementaryDataType, data, canonicalString);
            } else if (IStructuredDataType.class.isAssignableFrom(type)) {
                IStructuredDataType structuredDataType = (IStructuredDataType)concreteDataType;
                CanonicalStringCoDecForData.encodeStructuredDataIntoCanonicalString(structuredDataType, data, canonicalString);
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    private static void encodeElementaryDataIntoCanonicalString(IElementaryDataType sourceDataType, Object sourceData, StringBuilder canonicalString) {
        canonicalString.append('(');
        canonicalString.append(CanonicalStringCoDecForData.encodeSpecialCharacters(sourceDataType.getValueAsString(sourceData)));
        canonicalString.append(')');
    }

    private static void encodeStructuredDataIntoCanonicalString(IStructuredDataType sourceDataType, Object sourceData, StringBuilder canonicalString) {
        canonicalString.append('(');
        IList_<IKey> allFlagAndPropertyAndChildRolesAsList = sourceDataType.getFlagAndPropertyAndChildRoles(sourceData);
        boolean first = true;
        for (IKey role : allFlagAndPropertyAndChildRolesAsList) {
            SubDataType roleType = sourceDataType.getSubDataType(role);
            if (roleType.isFlag()) {
                if (!sourceDataType.isSet(sourceData, role)) continue;
                first = CanonicalStringCoDecForData.startNextRole(first, canonicalString);
                canonicalString.append(role.toCanonicalString());
                continue;
            }
            if (roleType.isProperty() || roleType.isChild()) {
                first = CanonicalStringCoDecForData.startNextRole(first, canonicalString);
                IDataType dataTypeOfPropertyOrChild = sourceDataType.getDataTypeOfPropertyOrChildren(sourceData, role);
                canonicalString.append(role.toCanonicalString()).append('=');
                if (roleType.isProperty()) {
                    Object propertyData = sourceDataType.getProperty(sourceData, role);
                    CanonicalStringCoDecForData.encodeIntoCanonicalString(dataTypeOfPropertyOrChild, propertyData, canonicalString);
                    continue;
                }
                canonicalString.append('(');
                IList_<? extends Object> childDatas = sourceDataType.getChildren(sourceData, role);
                for (Object e : childDatas) {
                    CanonicalStringCoDecForData.encodeIntoCanonicalString(dataTypeOfPropertyOrChild, e, canonicalString);
                }
                canonicalString.append(')');
                continue;
            }
            throw new UnsupportedOperationException();
        }
        canonicalString.append(')');
    }

    private static boolean startNextRole(boolean first, StringBuilder canonicalString) {
        if (!first) {
            canonicalString.append(',');
        }
        return false;
    }

    public static Object decodeFromCanonicalString(IDataType dataType, String canonicalString) throws EXCanonicalStringDecodingFailed, EXDataCreationFailed {
        ThreeTuple<Object, Integer, EXDataCreationFailed> objectAndEndIndex = CanonicalStringCoDecForData.decodeFromCanonicalString(dataType, canonicalString, 0);
        if (objectAndEndIndex.getComponent3() != null) {
            throw objectAndEndIndex.getComponent3();
        }
        int endIndex = objectAndEndIndex.getComponent2();
        if (endIndex != canonicalString.length()) {
            throw new EXCanonicalStringDecodingFailed(new EXExcessCharacters(endIndex));
        }
        return objectAndEndIndex.getComponent1();
    }

    private static ThreeTuple<Object, Integer, EXDataCreationFailed> decodeFromCanonicalString(IDataType dataType, String canonicalString, int beginIndex) throws EXCanonicalStringDecodingFailed, EXDataCreationFailed {
        Object data;
        int currentIndex = beginIndex;
        EXDataCreationFailed exception = null;
        Class<? extends IDataType> type = dataType.getStructureType();
        IDataType concreteDataType = dataType.getConcreteDataType();
        if (canonicalString.length() == currentIndex || canonicalString.charAt(currentIndex) != '(') {
            char nextCharacter;
            if (canonicalString.length() > currentIndex && (nextCharacter = canonicalString.charAt(currentIndex)) != ')' && nextCharacter != ',') {
                throw new EXCanonicalStringDecodingFailed(new EXMalformedCanonicalString(currentIndex, nextCharacter, '('));
            }
            data = concreteDataType.createNullDataElement();
        } else {
            ++currentIndex;
            if (IElementaryDataType.class.isAssignableFrom(type)) {
                IElementaryDataType elementaryDataType = (IElementaryDataType)concreteDataType;
                Tuple<Object, Integer> dataAndIndex = CanonicalStringCoDecForData.decodeElementaryData(elementaryDataType, canonicalString, currentIndex);
                data = dataAndIndex.getT1();
                currentIndex = dataAndIndex.getT2();
            } else if (IStructuredDataType.class.isAssignableFrom(type)) {
                IStructuredDataType structuredDataType = (IStructuredDataType)concreteDataType;
                ThreeTuple<Object, Integer, EXDataCreationFailed> dataAndIndex = CanonicalStringCoDecForData.decodeStructuredData(structuredDataType, canonicalString, currentIndex);
                data = dataAndIndex.getComponent1();
                currentIndex = dataAndIndex.getComponent2();
                exception = dataAndIndex.getComponent3();
            } else {
                throw new IllegalArgumentException("Data type is neither elementary nor structured");
            }
        }
        return new ThreeTuple<Object, Integer, Object>(data, currentIndex, exception);
    }

    private static Tuple<Object, Integer> decodeElementaryData(IElementaryDataType elementaryDataType, String canonicalString, int currentIndex) throws EXCanonicalStringDecodingFailed, EXDataCreationFailed {
        int currentIndex_ = currentIndex;
        IElementaryDataFactory dataFactory = elementaryDataType.createDataFactory();
        int objectEndDelimiterIndex = canonicalString.indexOf(41, currentIndex_);
        if (objectEndDelimiterIndex == -1) {
            throw new EXCanonicalStringDecodingFailed(new EXPrematureEndOfCanonicalString());
        }
        String value = CanonicalStringCoDecForData.decodeSpecialCharacters(canonicalString.substring(currentIndex_, objectEndDelimiterIndex));
        currentIndex_ = objectEndDelimiterIndex + 1;
        dataFactory.setCharacters(value);
        Object data = dataFactory.createDataElement();
        return new Tuple<Object, Integer>(data, currentIndex_);
    }

    private static ThreeTuple<Object, Integer, EXDataCreationFailed> decodeStructuredData(IStructuredDataType targetDataType, String canonicalString, int currentIndex) throws EXCanonicalStringDecodingFailed, EXDataCreationFailed {
        int currentIndex_ = currentIndex;
        IStructuredDataFactory dataFactory = targetDataType.createDataFactory();
        if (canonicalString.length() < currentIndex_ + 1) {
            throw new EXCanonicalStringDecodingFailed(new EXPrematureEndOfCanonicalString());
        }
        boolean endOfDataReached = false;
        if (canonicalString.charAt(currentIndex_) == ')') {
            endOfDataReached = true;
            ++currentIndex_;
        }
        while (!endOfDataReached) {
            int endOfRoleIndex = 0;
            int objectEndDelimiterIndex = canonicalString.indexOf(41, currentIndex_);
            if (objectEndDelimiterIndex == -1) {
                throw new EXCanonicalStringDecodingFailed(new EXPrematureEndOfCanonicalString());
            }
            endOfRoleIndex = objectEndDelimiterIndex;
            int rolesSeparatorIndex = canonicalString.indexOf(44, currentIndex_);
            if (rolesSeparatorIndex != -1 && rolesSeparatorIndex < endOfRoleIndex) {
                endOfRoleIndex = rolesSeparatorIndex;
            } else {
                rolesSeparatorIndex = -1;
            }
            int roleKeySeparatorIndex = canonicalString.indexOf(61, currentIndex_);
            if (roleKeySeparatorIndex != -1 && roleKeySeparatorIndex < endOfRoleIndex) {
                endOfRoleIndex = roleKeySeparatorIndex;
            } else {
                roleKeySeparatorIndex = -1;
            }
            String roleString = canonicalString.substring(currentIndex_, endOfRoleIndex);
            Key role = Key.getCanonicalKeyInstance(roleString);
            currentIndex_ = endOfRoleIndex;
            SubDataType roleType = targetDataType.getSubDataType(role);
            if (roleType == null) {
                EXCanonicalStringDecodingFailed exception = new EXCanonicalStringDecodingFailed(new EXUnknownFlagOrPropertyOrChildRoleForStructuredData(role));
                CanonicalStringCoDecForData.handleErroneousRole(dataFactory, role, exception);
                if (canonicalString.charAt(currentIndex_) == '=') {
                    currentIndex_ = CanonicalStringCoDecForData.handleUnknownRole(canonicalString, currentIndex_ + 1);
                }
            } else {
                currentIndex_ = CanonicalStringCoDecForData.handleRole(role, roleType, dataFactory, canonicalString, currentIndex_);
            }
            if (canonicalString.length() < currentIndex_ + 1) {
                throw new EXCanonicalStringDecodingFailed(new EXPrematureEndOfCanonicalString());
            }
            if (canonicalString.charAt(currentIndex_) == ')') {
                endOfDataReached = true;
                ++currentIndex_;
                continue;
            }
            if (canonicalString.charAt(currentIndex_) == ',') {
                ++currentIndex_;
                continue;
            }
            throw new EXCanonicalStringDecodingFailed(new EXMalformedCanonicalString(currentIndex_, canonicalString.charAt(currentIndex_), ')'));
        }
        Object data = null;
        EXDataCreationFailed exception = null;
        try {
            data = dataFactory.createDataElement();
        }
        catch (EXDataCreationFailed eDCF) {
            exception = eDCF;
        }
        return new ThreeTuple<Object, Integer, EXDataCreationFailed>(data, currentIndex_, exception);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int handleRole(IKey role, SubDataType roleType, IStructuredDataFactory dataFactory, String canonicalString, int currentIndex) throws EXCanonicalStringDecodingFailed, EXDataCreationFailed {
        boolean mayBeProperty;
        int currentIndex_ = currentIndex;
        if (roleType.isFlag()) {
            dataFactory.setFlag(role);
            return currentIndex_;
        }
        if (!roleType.isProperty()) {
            if (!roleType.isChild()) throw new EXCanonicalStringDecodingFailed(new EXDecoderException("Unknown role type: role type = \"" + roleType.toString() + "\"/ role = \"" + role.toCanonicalString() + "\""));
        }
        if (canonicalString.length() < currentIndex_ + 1) {
            throw new EXCanonicalStringDecodingFailed(new EXPrematureEndOfCanonicalString());
        }
        if (canonicalString.charAt(currentIndex_) != '=') {
            throw new EXCanonicalStringDecodingFailed(new EXMalformedCanonicalString(currentIndex_, canonicalString.charAt(currentIndex_), '='));
        }
        IDataType dataTypeOfPropertyOrChild = dataFactory.getDataTypeOfPropertyOrChildren(role);
        boolean mayBeChild = canonicalString.length() >= ++currentIndex_ + 2 && canonicalString.charAt(currentIndex_) == '(' && (canonicalString.charAt(currentIndex_ + 1) == '(' || canonicalString.charAt(currentIndex_ + 1) == ')');
        boolean bl = mayBeProperty = canonicalString.length() >= currentIndex_ + 1 && (canonicalString.charAt(currentIndex_) == ',' || canonicalString.charAt(currentIndex_) == ')' || canonicalString.length() >= currentIndex_ + 2 && canonicalString.charAt(currentIndex_) == '(' && canonicalString.charAt(currentIndex_ + 1) != '(');
        if ((roleType.isProperty() || !mayBeChild) && mayBeProperty) {
            ThreeTuple<Object, Integer, EXDataCreationFailed> dataAndIndex;
            if (roleType.isChild()) {
                CanonicalStringCoDecForData.handleErroneousRole(dataFactory, role, new EXCanonicalStringDecodingFailed(new EXPropertyDataFoundForChild(role)));
            }
            if ((dataAndIndex = CanonicalStringCoDecForData.decodeFromCanonicalString(dataTypeOfPropertyOrChild, canonicalString, currentIndex_)).getComponent3() != null) {
                CanonicalStringCoDecForData.handleErroneousPropertyOrChild(dataFactory, role, dataAndIndex.getComponent3());
                return dataAndIndex.getComponent2();
            }
            try {
                dataFactory.addPropertyOrChild(role, dataAndIndex.getComponent1());
                return dataAndIndex.getComponent2();
            }
            catch (EXDataAssemblingFailed e) {
                throw new EXDataCreationFailed(e.getCausingException());
            }
        }
        if (!roleType.isChild()) {
            if (mayBeProperty) throw new EXCanonicalStringDecodingFailed(new EXMalformedCanonicalString(currentIndex_, canonicalString.charAt(currentIndex_), ')'));
        }
        if (!mayBeChild) throw new EXCanonicalStringDecodingFailed(new EXMalformedCanonicalString(currentIndex_, canonicalString.charAt(currentIndex_), ')'));
        if (roleType.isProperty()) {
            CanonicalStringCoDecForData.handleErroneousRole(dataFactory, role, new EXCanonicalStringDecodingFailed(new EXSeveralSubDatasFoundForProperty(role)));
        }
        ++currentIndex_;
        while (canonicalString.charAt(currentIndex_) == '(') {
            ThreeTuple<Object, Integer, EXDataCreationFailed> dataAndIndex = CanonicalStringCoDecForData.decodeFromCanonicalString(dataTypeOfPropertyOrChild, canonicalString, currentIndex_);
            if (dataAndIndex.getComponent3() != null) {
                CanonicalStringCoDecForData.handleErroneousPropertyOrChild(dataFactory, role, dataAndIndex.getComponent3());
            } else {
                try {
                    dataFactory.addPropertyOrChild(role, dataAndIndex.getComponent1());
                }
                catch (EXDataAssemblingFailed e) {
                    throw new EXDataCreationFailed(e.getCausingException());
                }
            }
            currentIndex_ = dataAndIndex.getComponent2();
        }
        if (canonicalString.charAt(currentIndex_) != ')') {
            throw new EXCanonicalStringDecodingFailed(new EXMalformedCanonicalString(currentIndex_, canonicalString.charAt(currentIndex_), ')'));
        }
        ++currentIndex_;
        return currentIndex_;
    }

    private static int handleUnknownRole(String canonicalString, int currentIndex) throws EXCanonicalStringDecodingFailed {
        int currentIndex_ = currentIndex;
        if (canonicalString.charAt(currentIndex_) == '(') {
            ++currentIndex_;
            int bracketCount = 1;
            while (bracketCount > 0 && currentIndex_ < canonicalString.length()) {
                if (canonicalString.charAt(currentIndex_) == '(') {
                    ++bracketCount;
                } else if (canonicalString.charAt(currentIndex_) == ')') {
                    --bracketCount;
                }
                ++currentIndex_;
            }
            if (bracketCount > 0) {
                throw new EXCanonicalStringDecodingFailed(new EXPrematureEndOfCanonicalString());
            }
        } else if (canonicalString.charAt(currentIndex_) != ')' && canonicalString.charAt(currentIndex_) != ',') {
            throw new EXCanonicalStringDecodingFailed(new EXMalformedCanonicalString(currentIndex_, canonicalString.charAt(currentIndex_), '('));
        }
        return currentIndex_;
    }

    private static void handleErroneousRole(IStructuredDataFactory dataFactory, IKey role, EXCanonicalStringDecodingFailed exception) throws EXCanonicalStringDecodingFailed {
        if (!dataFactory.isErroneousFlagOrPropertyOrChildToIgnore(role, exception)) {
            throw exception;
        }
    }

    private static void handleErroneousPropertyOrChild(IStructuredDataFactory dataFactory, IKey role, EXDataCreationFailed exception) throws EXDataCreationFailed {
        if (!dataFactory.isErroneousFlagOrPropertyOrChildToIgnore(role, exception)) {
            throw exception;
        }
    }

    private static String encodeSpecialCharacters(String original) {
        if (original.length() == 0) {
            return original;
        }
        int originalLength = original.length();
        char[] originalChars = new char[originalLength];
        original.getChars(0, originalLength, originalChars, 0);
        StringBuilder encodedResult = null;
        int lastReplacementIndex = -1;
        int i = 0;
        while (i < originalChars.length) {
            String replacement;
            char charAtI = originalChars[i];
            switch (charAtI) {
                case '_': {
                    replacement = "__";
                    break;
                }
                case '(': {
                    replacement = "_[";
                    break;
                }
                case ')': {
                    replacement = "_]";
                    break;
                }
                default: {
                    replacement = null;
                }
            }
            if (replacement != null) {
                int copylen;
                if (encodedResult == null) {
                    encodedResult = new StringBuilder(originalChars.length * 2);
                }
                if ((copylen = i - lastReplacementIndex - 1) > 0) {
                    encodedResult.append(originalChars, lastReplacementIndex + 1, copylen);
                }
                encodedResult.append(replacement);
                lastReplacementIndex = i;
            }
            ++i;
        }
        if (lastReplacementIndex == -1) {
            return original;
        }
        assert (encodedResult != null) : "can not get here when encodedResult == null";
        if (lastReplacementIndex != originalChars.length - 1) {
            assert (lastReplacementIndex < originalChars.length);
            int copylen = originalChars.length - lastReplacementIndex - 1;
            if (copylen > 0) {
                encodedResult.append(originalChars, lastReplacementIndex + 1, copylen);
            }
        }
        return encodedResult.toString();
    }

    private static String decodeSpecialCharacters(String encoded) {
        if (encoded.length() == 0) {
            return encoded;
        }
        int encodedLength = encoded.length();
        char[] encodedChars = new char[encodedLength];
        encoded.getChars(0, encodedLength, encodedChars, 0);
        StringBuilder decodedResult = null;
        int lastReplacedCharIndex = -1;
        int i = 0;
        while (i < encodedChars.length) {
            String replacement;
            char charAtI = encodedChars[i];
            if (charAtI == '_') {
                if (i + 1 < encodedChars.length) {
                    char charAtIp1 = encodedChars[i + 1];
                    switch (charAtIp1) {
                        case '_': {
                            replacement = "_";
                            break;
                        }
                        case '[': {
                            replacement = "(";
                            break;
                        }
                        case ']': {
                            replacement = ")";
                            break;
                        }
                        default: {
                            assert (false) : "invalid data";
                            replacement = null;
                            break;
                        }
                    }
                } else {
                    assert (false) : "invalid or truncated data";
                    replacement = null;
                }
            } else {
                replacement = null;
            }
            if (replacement != null) {
                int copylen;
                if (decodedResult == null) {
                    decodedResult = new StringBuilder(encodedChars.length);
                }
                if ((copylen = i - lastReplacedCharIndex - 1) > 0) {
                    decodedResult.append(encodedChars, lastReplacedCharIndex + 1, copylen);
                }
                decodedResult.append(replacement);
            }
            if (replacement != null) {
                lastReplacedCharIndex = i + 1;
                i += 2;
                continue;
            }
            ++i;
        }
        if (lastReplacedCharIndex == -1) {
            return encoded;
        }
        assert (decodedResult != null) : "can not get here when encodedResult == null";
        if (lastReplacedCharIndex != encodedChars.length - 1) {
            assert (lastReplacedCharIndex < encodedChars.length);
            int copylen = encodedChars.length - lastReplacedCharIndex - 1;
            if (copylen > 0) {
                decodedResult.append(encodedChars, lastReplacedCharIndex + 1, copylen);
            }
        }
        return decodedResult.toString();
    }
}

