/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.codec.data;

import com.arcway.lib.codec.data.IKey;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.stringtools.StringCanonicalizer;
import java.lang.ref.SoftReference;
import java.util.WeakHashMap;

public class Key
implements IKey {
    private static final WeakHashMap<String, SoftReference<Key>> validCanonicalKeyStrings = new WeakHashMap(1000, 0.5f);
    private final String canonicalString;

    public static void checkKeyStringToBeValid(String canonicalKeyString) {
        Key.getCanonicalKeyInstance(canonicalKeyString);
    }

    public static synchronized Key getCanonicalKeyInstance(String string) {
        Key validCanonicalKey = null;
        SoftReference<Key> wrValidKey = validCanonicalKeyStrings.get(string);
        if (wrValidKey != null) {
            validCanonicalKey = wrValidKey.get();
        }
        if (validCanonicalKey == null) {
            Assert.checkArgumentBeeingNotNull(string);
            Assert.checkStringToBeNotEmpty(string);
            Assert.checkStringToContainNoInvalidCharacters(string.substring(0, 1), "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_-");
            Assert.checkStringToContainNoInvalidCharacters(string.substring(1), ALLOWED_CHARACTERS_FOLLOWINGCHARS);
            String validCanonicalKeyString = StringCanonicalizer.getSystemWideCanonicalString(string);
            validCanonicalKey = new Key(validCanonicalKeyString);
            validCanonicalKeyStrings.put(validCanonicalKeyString, new SoftReference<Key>(validCanonicalKey));
        }
        return validCanonicalKey;
    }

    public static void checkKeyStringsToBeValid(ICollection_<String> canonicalKeyStrings) {
        for (String canonicalKeyString : canonicalKeyStrings) {
            Key.checkKeyStringToBeValid(canonicalKeyString);
        }
    }

    private Key(String canonicalString) {
        this.canonicalString = canonicalString;
    }

    @Override
    public String toCanonicalString() {
        return this.canonicalString;
    }
}

