/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.message;

import java.util.HashMap;

public class RequestFamily {
    private static final HashMap<String, RequestFamily> requestFamilyMap = new HashMap();
    private final String name;
    public static final RequestFamily REQUEST_FAMILY_FileTransfer = new RequestFamily("FileTransfer");
    public static final RequestFamily REQUEST_FAMILY_StandardRequest = new RequestFamily("StandardRequest");

    private RequestFamily(String name) {
        assert (!requestFamilyMap.containsKey(name));
        assert (name != null);
        assert (name.length() > 0);
        this.name = name;
        requestFamilyMap.put(name, this);
    }

    public String toString() {
        return this.name;
    }

    public static RequestFamily parseRequestFamily(String name) {
        assert (name != null);
        assert (name.length() > 0);
        assert (name.equals(name.trim()));
        RequestFamily requestFamily = requestFamilyMap.get(name);
        if (requestFamily == null) {
            assert (false);
            requestFamily = new RequestFamily(name);
        }
        return requestFamily;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        assert (obj instanceof RequestFamily);
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestFamily other = (RequestFamily)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

