/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.message;

import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.primitiveTypes.EOLong;
import de.plans.psc.shared.message.EOException;

public class EOServerResponse
extends EOEncodableObject {
    public static final String STATUS_OK = "ok";
    public static final String STATUS_EXCEPTION = "exception";
    public static final String XML_NAME = "ServerResponse";
    private static final String ATTR_TAG_STATUS_ID = "statusID";
    private String statusID = "ok";
    private EncodableObjectBase responseData;
    private EOException exception;
    private EOLong latestNotificationPacketSerial;

    public EOServerResponse(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public EOServerResponse(EncodableObjectBase responseData) {
        super(XML_NAME);
        this.setResponseData(responseData);
    }

    public EOServerResponse(EOException exception) {
        super(XML_NAME);
        this.setException(exception);
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, ATTR_TAG_STATUS_ID, this.statusID);
    }

    protected boolean setAttributeFromXML(String name, String value) {
        if (name.equals(ATTR_TAG_STATUS_ID)) {
            this.statusID = value;
            return true;
        }
        return false;
    }

    protected boolean hasChildren() {
        boolean hasChildren = this.responseData != null || this.exception != null || this.latestNotificationPacketSerial != null;
        return hasChildren;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        if (this.exception != null) {
            this.exception.writeXMLBody(writeContext, depth);
        }
        if (this.responseData != null) {
            this.responseData.writeXMLBody(writeContext, depth);
        }
        if (this.latestNotificationPacketSerial != null) {
            this.latestNotificationPacketSerial.writeXMLBody(writeContext, depth);
        }
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        if (newChild.getTag().equals("Exception")) {
            this.exception = (EOException)newChild;
            this.statusID = STATUS_EXCEPTION;
        } else if (newChild.getTag().equals("frame.datatype.long") && newChild instanceof EOLong && "NotificationPacketSerial".equals(((EOLong)newChild).getRole())) {
            this.latestNotificationPacketSerial = (EOLong)newChild;
        } else {
            this.responseData = newChild;
            this.statusID = STATUS_OK;
        }
        return true;
    }

    public boolean isExceptionMsg() {
        return this.statusID.equals(STATUS_EXCEPTION);
    }

    public EOException getException() {
        return this.exception;
    }

    public EncodableObjectBase getResponseData() {
        return this.responseData;
    }

    public boolean containsNotificationPacket() {
        return this.latestNotificationPacketSerial != null;
    }

    public EOLong getLatestNotificationPacketSerial() {
        return this.latestNotificationPacketSerial;
    }

    private void setException(EOException e) {
        this.statusID = STATUS_EXCEPTION;
        this.exception = e;
    }

    private void setResponseData(EncodableObjectBase responseData) {
        this.statusID = STATUS_OK;
        this.responseData = responseData;
    }

    public void attachLatestNotificationPacketSerial(EOLong p_latestNotificationPacketSerial) {
        this.latestNotificationPacketSerial = p_latestNotificationPacketSerial;
    }
}

