/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.message;

import de.plans.psc.shared.message.FieldName;
import de.plans.psc.shared.message.RequestFamily;
import de.plans.psc.shared.message.RequestID;
import de.plans.psc.shared.message.SegmentHeaderEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Set;

public class ClientSegmentHeader {
    public static final long ResponseBytesMissingBytesStartIndex_Undefined = -1L;
    public static final long RequestBytesTotalLength_Unkown = -1L;
    private final RequestID requestID;
    private final RequestFamily requestFamily;
    private final RequestID highestKnownRequestID;
    private final Set<RequestID> activeRequests;
    private final long requestBytesStartIndex;
    private final long requestBytesSegmentLength;
    private final long requestBytesTotalLength;
    private final long responseBytesMissingBytesStartIndex;
    private final long responseBytesMaxSegmentBytes;
    private final LinkedHashMap<String, String> extraFields;

    public ClientSegmentHeader(RequestID requestID, RequestFamily requestFamily, RequestID highestKnownRequestID, Set<RequestID> activeRequests, long requestBytesStartIndex, long requestBytesSegmentLength, long requestBytesTotalLength, long responseBytesMissingBytesStartIndex, long responseBytesMaxSegmentBytes, LinkedHashMap<String, String> extraFields) {
        this.requestID = requestID;
        this.requestFamily = requestFamily;
        this.highestKnownRequestID = highestKnownRequestID;
        this.activeRequests = activeRequests;
        this.requestBytesStartIndex = requestBytesStartIndex;
        this.requestBytesSegmentLength = requestBytesSegmentLength;
        this.requestBytesTotalLength = requestBytesTotalLength;
        this.responseBytesMissingBytesStartIndex = responseBytesMissingBytesStartIndex;
        this.responseBytesMaxSegmentBytes = responseBytesMaxSegmentBytes;
        this.extraFields = extraFields;
    }

    private ClientSegmentHeader(SegmentHeaderEncoder.RawSegmentHeaderData rawSegmentHeaderData) {
        LinkedHashMap<FieldName, String> fieldValueMap = rawSegmentHeaderData.getStandardFields();
        this.requestID = SegmentHeaderEncoder.decodeField_RequestID(fieldValueMap.get(FieldName.FIELD_NAME_RequestID));
        this.requestFamily = SegmentHeaderEncoder.decodeField_RequestFamily(fieldValueMap.get(FieldName.FIELD_NAME_RequestFamily));
        this.highestKnownRequestID = SegmentHeaderEncoder.decodeField_RequestID(fieldValueMap.get(FieldName.FIELD_NAME_HighestKnownRequestID));
        this.activeRequests = SegmentHeaderEncoder.decodeField_Set_RequestID(fieldValueMap.get(FieldName.FIELD_NAME_ActiveRequests));
        this.requestBytesStartIndex = SegmentHeaderEncoder.decodeField_Long(fieldValueMap.get(FieldName.FIELD_NAME_RequestBytesStartIndex));
        this.requestBytesSegmentLength = SegmentHeaderEncoder.decodeField_Long(fieldValueMap.get(FieldName.FIELD_NAME_RequestBytesSegmentLength));
        this.requestBytesTotalLength = SegmentHeaderEncoder.decodeField_Long(fieldValueMap.get(FieldName.FIELD_NAME_RequestBytesTotalLength));
        this.responseBytesMissingBytesStartIndex = SegmentHeaderEncoder.decodeField_Long(fieldValueMap.get(FieldName.FIELD_NAME_RequestBytesMissingBytesStartIndex));
        this.responseBytesMaxSegmentBytes = SegmentHeaderEncoder.decodeField_Long(fieldValueMap.get(FieldName.FIELD_NAME_RequestBytesMissingBytesLength));
        this.extraFields = rawSegmentHeaderData.getExtraFields();
    }

    public static ClientSegmentHeader parseStreamEncodedHeader(InputStream inputStream) throws IOException, SegmentHeaderEncoder.ExInvalidSegmentData {
        SegmentHeaderEncoder.RawSegmentHeaderData rawSegmentHeaderData = SegmentHeaderEncoder.decodeSegment(inputStream);
        return new ClientSegmentHeader(rawSegmentHeaderData);
    }

    public void serializeIntoStream(OutputStream responseStream) throws IOException {
        LinkedHashMap<FieldName, String> fieldValueMap = new LinkedHashMap<FieldName, String>();
        fieldValueMap.put(FieldName.FIELD_NAME_RequestID, SegmentHeaderEncoder.encodeField_RequestID(this.requestID));
        fieldValueMap.put(FieldName.FIELD_NAME_RequestFamily, SegmentHeaderEncoder.encodeField_RequestFamily(this.requestFamily));
        fieldValueMap.put(FieldName.FIELD_NAME_HighestKnownRequestID, SegmentHeaderEncoder.encodeField_RequestID(this.highestKnownRequestID));
        fieldValueMap.put(FieldName.FIELD_NAME_ActiveRequests, SegmentHeaderEncoder.encodeField_Set_RequestID(this.activeRequests));
        fieldValueMap.put(FieldName.FIELD_NAME_RequestBytesStartIndex, SegmentHeaderEncoder.encodeField_Long(this.requestBytesStartIndex));
        fieldValueMap.put(FieldName.FIELD_NAME_RequestBytesSegmentLength, SegmentHeaderEncoder.encodeField_Long(this.requestBytesSegmentLength));
        fieldValueMap.put(FieldName.FIELD_NAME_RequestBytesTotalLength, SegmentHeaderEncoder.encodeField_Long(this.requestBytesTotalLength));
        fieldValueMap.put(FieldName.FIELD_NAME_RequestBytesMissingBytesStartIndex, SegmentHeaderEncoder.encodeField_Long(this.responseBytesMissingBytesStartIndex));
        fieldValueMap.put(FieldName.FIELD_NAME_RequestBytesMissingBytesLength, SegmentHeaderEncoder.encodeField_Long(this.responseBytesMaxSegmentBytes));
        responseStream.write(SegmentHeaderEncoder.encodeSegment(new SegmentHeaderEncoder.RawSegmentHeaderData(fieldValueMap, this.extraFields)));
    }

    public RequestID getRequestID() {
        return this.requestID;
    }

    public RequestFamily getRequestFamily() {
        return this.requestFamily;
    }

    public RequestID getHighestKnownRequestID() {
        return this.highestKnownRequestID;
    }

    public Set<RequestID> getActiveRequests() {
        return this.activeRequests;
    }

    public long getRequestBytesStartIndex() {
        assert (this.requestBytesStartIndex >= 0L);
        return this.requestBytesStartIndex;
    }

    public long getRequestBytesSegmentLength() {
        assert (this.requestBytesTotalLength >= 0L);
        return this.requestBytesSegmentLength;
    }

    public long getRequestBytesTotalLength() {
        assert (this.requestBytesTotalLength >= -1L);
        return this.requestBytesTotalLength;
    }

    public long getResponseBytesMissingBytesStartIndex() {
        return this.responseBytesMissingBytesStartIndex;
    }

    public long getResponseBytesMaxSegmentBytes() {
        return this.responseBytesMaxSegmentBytes;
    }

    public LinkedHashMap<String, String> getExtraFields() {
        return this.extraFields;
    }
}

