/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared;

import de.plans.psc.shared.IPermissionsTemplateProvider;
import de.plans.psc.shared.Messages;
import de.plans.psc.shared.message.EOPermission;
import java.util.ArrayList;
import java.util.List;

public class PSCPermissionConstants {
    public static final String SUB_SET_UID_SERVER = "SERVER";
    public static final String SUB_SET_TYPE_SERVER = "SERVER";
    public static final String PERMISSION_UID_ADMIN = "admin";
    public static final String OPERATION_ADMIN = "adminServer";
    public static final String OPERAND_TYPE_ADMIN = "admin";
    public static final String PERMISSION_UID_OPERATOR = "operator";
    public static final String OPERATION_OPERATOR = "serverOperator";
    public static final String OPERAND_TYPE_OPERATOR = "operator";
    private static List<EOPermission> permissionTemplates = null;
    private static List<EOPermission> mandatoryPermissions = null;
    public static final String ADD_GROUP_PERMISSION_NOTIFICATION = "psc.permission.group.add";
    public static final String DELETE_GROUP_PERMISSION_NOTIFICATION = "psc.permission.group.delete";
    public static final String ADD_USER_PERMISSION_NOTIFICATION = "psc.permission.user.add";
    public static final String DELETE_USER_PERMISSION_NOTIFICATION = "psc.permission.user.delete";
    public static final String ADD_STAKEHOLER_ROLE_PERMISSION_NOTIFICATION = "psc.permission.stakeholderrole.add";
    public static final String DELETE_STAKEHOLDER_ROLE_PERMISSION_NOTIFICATION = "psc.permission.stakeholderrole.delete";
    private static List<IPermissionsTemplateProvider> permissionTemplateProviders = new ArrayList<IPermissionsTemplateProvider>();

    public static List<EOPermission> getPermissionTemplates() {
        if (permissionTemplates == null) {
            permissionTemplates = new ArrayList<EOPermission>();
            EOPermission userAdminPermission = new EOPermission();
            userAdminPermission.setSubSetUID("SERVER");
            userAdminPermission.setSubSetType("SERVER");
            userAdminPermission.setOperation(OPERATION_ADMIN);
            userAdminPermission.setOperandType("admin");
            permissionTemplates.add(userAdminPermission);
            EOPermission operatorPermission = new EOPermission();
            operatorPermission.setSubSetUID("SERVER");
            operatorPermission.setSubSetType("SERVER");
            operatorPermission.setOperation(OPERATION_OPERATOR);
            operatorPermission.setOperandType("operator");
            permissionTemplates.add(operatorPermission);
        }
        return permissionTemplates;
    }

    public static void addTemplateProvider(IPermissionsTemplateProvider templateProvider) {
        List<EOPermission> newTemplates = templateProvider.getTemplates();
        PSCPermissionConstants.getPermissionTemplates().addAll(newTemplates);
        permissionTemplateProviders.add(templateProvider);
    }

    public static String getPermissionName(EOPermission p) {
        if ("SERVER".equals(p.getSubSetUID()) && "SERVER".equals(p.getSubSetType()) && OPERATION_ADMIN.equals(p.getOperation()) && "admin".equals(p.getOperandType())) {
            return Messages.getString("PSCPermissionConstants.Administrate_System_10");
        }
        if ("SERVER".equals(p.getSubSetUID()) && "SERVER".equals(p.getSubSetType()) && OPERATION_OPERATOR.equals(p.getOperation()) && "operator".equals(p.getOperandType())) {
            return Messages.getString("PSCPermissionConstants.Operator_(Dump_Server)_1");
        }
        int i = 0;
        while (i < permissionTemplateProviders.size()) {
            IPermissionsTemplateProvider provider = permissionTemplateProviders.get(i);
            String name = provider.getPermissionName(p);
            if (name != null) {
                return name;
            }
            ++i;
        }
        return null;
    }

    public static List<EOPermission> getMandatoryPermissions() {
        if (mandatoryPermissions == null) {
            mandatoryPermissions = new ArrayList<EOPermission>();
            EOPermission userAdminPermission = new EOPermission();
            userAdminPermission.setSubSetUID("SERVER");
            userAdminPermission.setSubSetType("SERVER");
            userAdminPermission.setOperation(OPERATION_ADMIN);
            userAdminPermission.setOperandType("admin");
            userAdminPermission.setOwnerID("Administrators");
            userAdminPermission.setOwnerTypeGroup();
            userAdminPermission.setPermissionUID("admin");
            mandatoryPermissions.add(userAdminPermission);
        }
        return mandatoryPermissions;
    }

    public static boolean isMandatoryPermission(EOPermission permission) {
        if (permission.getOwnerID().equals("Administrator") && permission.isOwnerTypeUser()) {
            return true;
        }
        if (permission.getOwnerID().equals("Administrators") && permission.isOwnerTypeGroup()) {
            return true;
        }
        for (EOPermission mandatoryPermission : PSCPermissionConstants.getMandatoryPermissions()) {
            if (!permission.getPermissionUID().equals(mandatoryPermission.getPermissionUID())) continue;
            return true;
        }
        return false;
    }
}

