/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.swt;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.dialogs.IProgressMonitorTask;
import de.plans.psc.client.dialogs.ProgressMonitorIF;
import de.plans.psc.client.dialogs.swt.Messages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RemainingTimeProgressDialog
implements ProgressMonitorIF {
    private static final ILogger logger = Logger.getLogger(RemainingTimeProgressDialog.class);
    private IProgressMonitorTask monitoredTask;
    private IProgressMonitor progressMonitor;
    private String taskName = "Executing ...";
    private static final int NUM_WORK_UNITS = 100;
    private final long startTimeMillis = System.currentTimeMillis();
    private int workedUnits = 0;
    private final Shell toplevelShell;

    public RemainingTimeProgressDialog(Display display) {
        this.toplevelShell = new Shell(display);
    }

    private void cancelTask() {
        if (this.monitoredTask != null) {
            this.monitoredTask.cancelTask();
        }
    }

    private void executeTask(IProgressMonitorTask taskToMonitor) {
        this.monitoredTask = taskToMonitor;
        if (this.monitoredTask != null) {
            this.monitoredTask.startTask();
        }
        this.monitoredTask = null;
    }

    @Override
    public void setProgress(double progress) {
        String timeRemaining;
        long timeRunning = System.currentTimeMillis() - this.startTimeMillis;
        if (progress < 0.01) {
            timeRemaining = "?";
        } else {
            long secondsRemaining = (long)((double)timeRunning * (1.0 - progress) / progress / 1000.0);
            timeRemaining = Long.toString(secondsRemaining);
        }
        this.setProgress(timeRemaining, progress);
    }

    @Override
    public void executeTaskWithProgressReporting(final IProgressMonitorTask task, boolean cancelable) {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.toplevelShell);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                RemainingTimeProgressDialog.this.progressMonitor = monitor;
                RemainingTimeProgressDialog.this.progressMonitor.beginTask(RemainingTimeProgressDialog.this.taskName, 100);
                RemainingTimeProgressDialog.this.executeTask(task);
            }
        };
        try {
            progressMonitorDialog.run(true, cancelable, op);
        }
        catch (InvocationTargetException e) {
            logger.error("could not execute", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error("could not execute", (Throwable)e);
        }
    }

    @Override
    public void setAborted(String reason) {
        if (this.progressMonitor != null) {
            this.progressMonitor.subTask(String.valueOf(Messages.getString("DlgDisplayProgress.ABORTED___1")) + reason);
            this.progressMonitor.setCanceled(true);
        }
    }

    public void setProgress(String timeRemaining, double progress) {
        int newWorkUnits = (int)(100.0 * progress);
        if (newWorkUnits > this.workedUnits) {
            if (this.progressMonitor != null) {
                this.progressMonitor.subTask(String.valueOf(Messages.getString("DlgDisplayProgress.Time_remaining___2")) + timeRemaining + Messages.getString("DlgDisplayProgress.s_3"));
                this.progressMonitor.worked(newWorkUnits - this.workedUnits);
            }
            this.workedUnits = newWorkUnits;
        }
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            this.cancelTask();
        }
    }

    @Override
    public void setEnd() {
        if (this.progressMonitor != null) {
            this.progressMonitor.done();
        }
    }

    @Override
    public void setTaskName(String name) {
        this.taskName = name;
        if (this.progressMonitor != null) {
            this.progressMonitor.setTaskName(name);
        }
    }

    @Override
    public void setSubTaskName(String subTaskName) {
        if (this.progressMonitor != null) {
            this.progressMonitor.subTask(subTaskName);
        }
    }
}

