/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.swt;

import de.plans.lib.xml.parameter.EOParameterSetList;
import de.plans.lib.xml.parameter.XMLConfigParameterMgr;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.dialogs.swt.Messages;
import de.plans.psc.shared.message.EOServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PSCServerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ILabelProvider,
IStructuredContentProvider,
ISelectionChangedListener {
    private ListViewer viewer;
    private Button btnAdd;
    private Button btnModify;
    private Button btnDelete;
    private Composite preferencePageParent;
    private Text fldServerName;
    private Text fldServerURL;
    private Text fldServerID;
    private XMLConfigParameterMgr parameterMgr;
    private EOParameterSetList parameterServerList;
    private List localServerList;
    private int state = 0;
    private static final int VIEW = 0;
    private static final int MODIFY = 1;
    private static final int ADD = 2;
    boolean modified = false;
    EOServer currentServer;

    public void init(IWorkbench workbench) {
        this.parameterMgr = PSCClientServiceFacade.getFacade().getParameterManager();
        this.parameterServerList = (EOParameterSetList)this.parameterMgr.getSubtree("serverList");
        this.localServerList = new ArrayList();
        this.localServerList.addAll(this.parameterServerList.getArrayList());
    }

    protected Control createContents(Composite parent) {
        this.preferencePageParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.preferencePageParent.setLayout((Layout)layout);
        this.preferencePageParent.setFont(parent.getFont());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.preferencePageParent.setLayoutData((Object)gridData);
        this.createContent();
        this.setWidgetState();
        this.modified = false;
        return this.preferencePageParent;
    }

    private void createContent() {
        this.viewer = new ListViewer(this.preferencePageParent, 2048);
        this.viewer.setLabelProvider((IBaseLabelProvider)this);
        this.viewer.setContentProvider((IContentProvider)this);
        this.viewer.setInput((Object)this);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.viewer.getList().setLayoutData((Object)gridData);
        Composite btnBar = new Composite(this.preferencePageParent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        btnBar.setLayout((Layout)layout);
        this.btnAdd = new Button(btnBar, 8);
        this.btnAdd.setText(Messages.getString("PSCServerPreferencePage.Add_1"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnAdd.setLayoutData((Object)gridData);
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PSCServerPreferencePage.this.addServer();
            }
        });
        this.btnModify = new Button(btnBar, 8);
        this.btnModify.setText(Messages.getString("PSCServerPreferencePage.Modify_2"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnModify.setLayoutData((Object)gridData);
        this.btnModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PSCServerPreferencePage.this.modifyServer();
            }
        });
        this.btnDelete = new Button(btnBar, 8);
        this.btnDelete.setText(Messages.getString("PSCServerPreferencePage.Delete_3"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.btnDelete.setLayoutData((Object)gridData);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PSCServerPreferencePage.this.deleteServer();
            }
        });
        Group grpDetails = new Group(this.preferencePageParent, 32);
        grpDetails.setText(Messages.getString("PSCServerPreferencePage.Details_4"));
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        grpDetails.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        grpDetails.setLayoutData((Object)gridData);
        Label lblServerName = new Label((Composite)grpDetails, 0);
        lblServerName.setText(Messages.getString("PSCServerPreferencePage.Name__5"));
        lblServerName.setLayoutData((Object)new GridData(128));
        this.fldServerName = new Text((Composite)grpDetails, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fldServerName.setLayoutData((Object)gridData);
        this.fldServerName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent arg) {
                PSCServerPreferencePage.this.checkValidState();
            }
        });
        Label lblServerURL = new Label((Composite)grpDetails, 0);
        lblServerURL.setText(Messages.getString("PSCServerPreferencePage.URL__6"));
        lblServerURL.setLayoutData((Object)new GridData(128));
        this.fldServerURL = new Text((Composite)grpDetails, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fldServerURL.setLayoutData((Object)gridData);
        this.fldServerURL.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent arg) {
                PSCServerPreferencePage.this.checkValidState();
            }
        });
        Label lblServerID = new Label((Composite)grpDetails, 0);
        lblServerID.setText(Messages.getString("PSCServerPreferencePage.ID__7"));
        lblServerID.setLayoutData((Object)new GridData(128));
        this.fldServerID = new Text((Composite)grpDetails, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fldServerID.setLayoutData((Object)gridData);
        this.fldServerID.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent arg) {
                PSCServerPreferencePage.this.checkValidState();
            }
        });
    }

    private void addServer() {
        this.state = 2;
        this.setWidgetState();
        this.displayServerDetails(null);
    }

    private void deleteServer() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                this.localServerList.remove(iterator.next());
            }
            this.viewer.refresh();
            this.modified = true;
            this.state = 0;
            this.setWidgetState();
        }
    }

    private void modifyServer() {
        this.state = 1;
        this.setWidgetState();
        this.displayServerDetails(this.getFirstSelectedServer());
    }

    protected void performDefaults() {
        super.performDefaults();
        this.localServerList = this.parameterServerList.getArrayList();
        this.viewer.refresh();
        this.displayServerDetails(this.getFirstSelectedServer());
        this.setWidgetState();
    }

    public void performApply() {
        switch (this.state) {
            case 0: {
                break;
            }
            case 2: {
                EOServer newServer = new EOServer();
                newServer.setServerID(this.fldServerID.getText());
                newServer.setServerName(this.fldServerName.getText());
                newServer.setServerURL(this.fldServerURL.getText());
                this.localServerList.add(newServer);
                this.viewer.add((Object)newServer);
                this.viewer.getList().select(this.viewer.getList().getItemCount());
                this.modified = true;
                this.state = 0;
                this.setWidgetState();
                break;
            }
            case 1: {
                this.currentServer.setServerName(this.fldServerName.getText());
                this.currentServer.setServerURL(this.fldServerURL.getText());
                this.viewer.update((Object)this.currentServer, null);
                this.modified = true;
                this.state = 0;
                this.setWidgetState();
                break;
            }
            default: {
                this.state = 0;
            }
        }
    }

    public boolean performOk() {
        if (this.modified) {
            try {
                this.parameterServerList.setNewElements(this.localServerList);
                this.parameterMgr.commitParameters();
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    private void setWidgetState() {
        boolean serverSelected = !this.viewer.getSelection().isEmpty();
        switch (this.state) {
            case 0: {
                this.fldServerName.setEditable(false);
                this.fldServerID.setEditable(false);
                this.fldServerURL.setEditable(false);
                if (serverSelected) {
                    this.btnDelete.setEnabled(true);
                    this.btnModify.setEnabled(true);
                    this.btnAdd.setEnabled(true);
                    break;
                }
                this.btnDelete.setEnabled(false);
                this.btnModify.setEnabled(false);
                this.btnAdd.setEnabled(true);
                break;
            }
            case 2: {
                this.fldServerName.setEditable(true);
                this.fldServerID.setEditable(true);
                this.fldServerURL.setEditable(true);
                this.btnDelete.setEnabled(false);
                this.btnModify.setEnabled(false);
                this.btnAdd.setEnabled(false);
                break;
            }
            case 1: {
                this.fldServerName.setEditable(true);
                this.fldServerID.setEditable(false);
                this.fldServerURL.setEditable(true);
                this.btnDelete.setEnabled(false);
                this.btnModify.setEnabled(false);
                this.btnAdd.setEnabled(true);
                break;
            }
        }
    }

    private void checkValidState() {
        switch (this.state) {
            case 0: {
                this.setValid(true);
                break;
            }
            case 2: {
                if (this.fldServerName.getText().length() == 0) {
                    this.setErrorMessage(Messages.getString("PSCServerPreferencePage.Server_Name_is_missing._8"));
                    this.setValid(false);
                    return;
                }
                if (this.fldServerURL.getText().length() == 0) {
                    this.setErrorMessage(Messages.getString("PSCServerPreferencePage.Server_URL_is_missing._9"));
                    this.setValid(false);
                    return;
                }
                if (this.fldServerID.getText().length() == 0) {
                    this.setErrorMessage(Messages.getString("PSCServerPreferencePage.Server_ID_is_missing._10"));
                    this.setValid(false);
                    return;
                }
                int i = 0;
                while (i < this.parameterServerList.size()) {
                    if (this.fldServerID.getText().equals(((EOServer)this.parameterServerList.getArrayList().get(i)).getServerID())) {
                        this.setErrorMessage(Messages.getString("PSCServerPreferencePage.Server_ID_already_in_use._11"));
                        this.setValid(false);
                        return;
                    }
                    ++i;
                }
                this.setErrorMessage(null);
                this.setValid(true);
                break;
            }
            case 1: {
                if (this.fldServerName.getText().length() == 0) {
                    this.setErrorMessage(Messages.getString("PSCServerPreferencePage.Server_Name_is_missing._12"));
                    this.setValid(false);
                    return;
                }
                if (this.fldServerURL.getText().length() == 0) {
                    this.setErrorMessage(Messages.getString("PSCServerPreferencePage.Server_URL_is_missing._13"));
                    this.setValid(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setValid(true);
                break;
            }
        }
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        EOServer server = (EOServer)element;
        return String.valueOf(server.getServerName()) + " (" + server.getServerURL() + ")";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Object[] getElements(Object inputElement) {
        return this.localServerList.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.displayServerDetails(this.getFirstSelectedServer());
        this.setWidgetState();
    }

    private EOServer getFirstSelectedServer() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        return (EOServer)selection.getFirstElement();
    }

    private void displayServerDetails(EOServer data) {
        this.currentServer = data;
        if (data == null) {
            this.fldServerID.setText("");
            this.fldServerName.setText("");
            this.fldServerURL.setText("");
        } else {
            this.fldServerID.setText(data.getServerID());
            this.fldServerName.setText(data.getServerName());
            this.fldServerURL.setText(data.getServerURL());
        }
    }
}

