/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.admin.swt;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.internal.misc.StringMatcher;

public class LabelTextMatchFilter
extends ViewerFilter {
    private final ILabelProvider labelProvider;
    private StringMatcher fMatcher;

    public LabelTextMatchFilter(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void setFilter(String pattern) {
        this.fMatcher = LabelTextMatchFilter.isAllMatchPattern(pattern) ? null : new StringMatcher(String.valueOf(pattern.trim()) + '*', true, false);
    }

    private static boolean isAllMatchPattern(String pattern) {
        if (pattern == null) {
            return true;
        }
        String trimmedPattern = pattern.trim();
        while (trimmedPattern.startsWith("*")) {
            trimmedPattern = trimmedPattern.substring(1);
        }
        return trimmedPattern.length() == 0;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.fMatcher != null) {
            return this.fMatcher.match(this.labelProvider.getText(element));
        }
        return true;
    }
}

