/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.admin.swt;

import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.client.dialogs.admin.CtrlAdminUsers;
import de.plans.psc.client.dialogs.admin.DlgAdminUsersIF;
import de.plans.psc.client.dialogs.admin.swt.GroupListWrapper;
import de.plans.psc.client.dialogs.admin.swt.Messages;
import de.plans.psc.client.dialogs.admin.swt.PermissionListWrapper;
import de.plans.psc.client.dialogs.admin.swt.UIPnlUserData;
import de.plans.psc.client.dialogs.admin.swt.UserListWrapper;
import de.plans.psc.client.dialogs.swt.IServerSelectionListener;
import de.plans.psc.client.dialogs.swt.UIPnlSelectServerDropList;
import de.plans.psc.client.model.GroupListModel;
import de.plans.psc.client.model.PermissionListModel;
import de.plans.psc.client.model.User;
import de.plans.psc.client.model.UserGroup;
import de.plans.psc.client.model.UserListModel;
import de.plans.psc.client.model.UserWithGroups;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DlgAdminUsers
extends TitleAreaDialog
implements DlgAdminUsersIF,
ISelectionChangedListener,
IServerSelectionListener {
    private static final int BTN_ID_EDIT_USERDATA = 100;
    private static final int BTN_ID_CHANGE_PASSWD = 101;
    private static final int BTN_ID_ADD_USER = 102;
    private static final int BTN_ID_DELETE_USER = 103;
    private static final int BTN_ID_EDIT_PERMISSIONS = 104;
    private static final int BTN_ID_EDIT_GROUPS = 105;
    private CtrlAdminUsers ctrl;
    private UserListWrapper userListWrapper;
    private UserListModel userListModel;
    private PermissionListWrapper permissionListWrapper;
    private PermissionListModel permissionListModel;
    private GroupListWrapper groupListWrapper;
    private final GroupListModel groupListModel = new GroupListModel();
    private Text fldFind;
    private Label lblFind;
    private UIPnlUserData userDetails;
    private UIPnlSelectServerDropList serverCombo;
    private Map<Integer, Button> buttons;
    private Button btnClose;
    private Button btnOk;
    private boolean isUserAdmin = false;
    private String serverID;
    UserWithGroups selectedUser;
    private boolean selectUser = false;

    public DlgAdminUsers(Shell shell) {
        this(shell, null);
    }

    public DlgAdminUsers(Shell shell, String serverID) {
        super(shell);
        this.serverID = serverID;
        this.selectUser = serverID != null;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.create();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.getString("DlgAdminUsers.User_Administration_1"));
        this.setTitle(Messages.getString("DlgAdminUsers.User_Administration_Dialog_13"));
        return this.initComponents(parent);
    }

    private Control initComponents(Composite parent) {
        this.buttons = new HashMap<Integer, Button>();
        Composite baseArea = new Composite(parent, 0);
        baseArea.setLayoutData((Object)new GridData(1808));
        baseArea.setLayout((Layout)new GridLayout());
        Group grpServers = new Group(baseArea, 0);
        grpServers.setText(Messages.getString("DlgAdminUsers.Available_Servers_2"));
        grpServers.setLayoutData((Object)new GridData(768));
        grpServers.setLayout((Layout)new GridLayout());
        grpServers.setEnabled(!this.selectUser);
        this.serverCombo = new UIPnlSelectServerDropList((Composite)grpServers, this);
        this.serverCombo.setEnabled(!this.selectUser);
        this.serverCombo.setLayoutData(new GridData(768));
        SashForm rootPanel = new SashForm(baseArea, 0);
        rootPanel.setLayout((Layout)new GridLayout(2, false));
        rootPanel.setLayoutData((Object)new GridData(1808));
        Composite leftPart = new Composite((Composite)rootPanel, 0);
        leftPart.setLayout((Layout)new GridLayout());
        leftPart.setLayoutData((Object)new GridData(1808));
        Composite findArea = new Composite(leftPart, 0);
        findArea.setLayoutData((Object)new GridData(768));
        findArea.setLayout((Layout)new GridLayout(2, false));
        this.lblFind = new Label(findArea, 0);
        this.lblFind.setText(Messages.getString("DlgAdminUsers.Find__3"));
        this.lblFind.setLayoutData((Object)new GridData());
        this.fldFind = new Text(findArea, 2048);
        this.fldFind.setLayoutData((Object)new GridData(768));
        this.fldFind.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DlgAdminUsers.this.fldFindKeyTyped();
            }
        });
        this.userListWrapper = new UserListWrapper(leftPart, 2562);
        GridData gridData = new GridData(1808);
        this.userListWrapper.getViewer().getList().setLayoutData((Object)gridData);
        this.userListWrapper.getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        Composite addDelBtnArea = new Composite(leftPart, 0);
        addDelBtnArea.setLayoutData((Object)new GridData(768));
        addDelBtnArea.setLayout((Layout)new GridLayout(2, true));
        this.createButtonForDialog(addDelBtnArea, 102, Messages.getString("DlgAdminUsers.Add_4"));
        this.createButtonForDialog(addDelBtnArea, 103, Messages.getString("DlgAdminUsers.Delete_5"));
        Composite rightPart = new Composite((Composite)rootPanel, 0);
        rightPart.setLayoutData((Object)new GridData(1808));
        rightPart.setLayout((Layout)new GridLayout());
        this.userDetails = new UIPnlUserData(rightPart, false);
        gridData = new GridData(1808);
        this.userDetails.setLayoutData(gridData);
        Composite buttonsArea = new Composite(rightPart, 0);
        buttonsArea.setLayoutData((Object)new GridData(768));
        buttonsArea.setLayout((Layout)new GridLayout(2, false));
        this.createButtonForDialog(buttonsArea, 100, Messages.getString("DlgAdminUsers.Edit_6"));
        this.createButtonForDialog(buttonsArea, 101, Messages.getString("DlgAdminUsers.Change_Password_7"));
        Label label = new Label(rightPart, 0);
        label.setVisible(false);
        Group privListPanel = new Group(rightPart, 0);
        privListPanel.setText(Messages.getString("DlgAdminUsers.Basic_permissions_8"));
        privListPanel.setLayoutData((Object)new GridData(1808));
        privListPanel.setLayout((Layout)new GridLayout());
        this.permissionListWrapper = new PermissionListWrapper((Composite)privListPanel, 2560);
        org.eclipse.swt.widgets.List list = this.permissionListWrapper.getViewer().getList();
        list.setLayoutData((Object)new GridData(1808));
        DlgAdminUsers.computeSizeOfList(list);
        Label groupPrivilegeLabel = new Label(rightPart, 64);
        groupPrivilegeLabel.setText(Messages.getString("DlgAdminUsers.___(G)_indicates_permissions_that_are_derived_from_n___a_group_membership_9"));
        groupPrivilegeLabel.setLayoutData((Object)new GridData(768));
        this.createButtonForDialog(rightPart, 104, Messages.getString("DlgAdminUsers.Edit_10"));
        label = new Label(rightPart, 0);
        label.setVisible(false);
        Group groupListPanel = new Group(rightPart, 0);
        groupListPanel.setText(Messages.getString("DlgAdminUsers.Groups_11"));
        groupListPanel.setLayoutData((Object)new GridData(1808));
        groupListPanel.setLayout((Layout)new GridLayout());
        this.groupListWrapper = new GroupListWrapper((Composite)groupListPanel, 2560);
        list = this.groupListWrapper.getViewer().getList();
        list.setLayoutData((Object)new GridData(1808));
        DlgAdminUsers.computeSizeOfList(list);
        this.createButtonForDialog(rightPart, 105, Messages.getString("DlgAdminUsers.Edit_12"));
        rightPart.setLayoutData((Object)new GridData(1808));
        this.makeButtonsEqualWidth();
        this.updateDialog();
        return baseArea;
    }

    private static void computeSizeOfList(org.eclipse.swt.widgets.List list) {
        int i = 0;
        while (i < 3) {
            list.add("");
            ++i;
        }
        int heigth = list.computeSize((int)-1, (int)-1).y;
        GridData gridData = (GridData)list.getLayoutData();
        gridData.heightHint = heigth;
        list.removeAll();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.selectUser) {
            this.btnOk = super.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.btnOk.setEnabled(false);
            super.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        } else {
            this.btnClose = super.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
            this.getShell().setDefaultButton(this.btnClose);
        }
    }

    private Button createButtonForDialog(Composite parent, final int id, String label) {
        Button button = new Button(parent, 0);
        button.setLayoutData((Object)new GridData(-1, -1, false, false));
        button.setText(label);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DlgAdminUsers.this.buttonPressed(id);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.buttons.put(new Integer(id), button);
        return button;
    }

    protected Button getButton(int id) {
        return this.buttons.get(new Integer(id));
    }

    private void makeButtonsEqualWidth() {
        int width = 0;
        for (Button button : this.buttons.values()) {
            int buttonWidth = button.computeSize((int)-1, (int)-1).x;
            width = Math.max(width, buttonWidth);
        }
        for (Button button : this.buttons.values()) {
            GridData gridData = (GridData)button.getLayoutData();
            gridData.widthHint = width;
        }
    }

    public void buttonPressed(int buttonID) {
        switch (buttonID) {
            case 12: {
                this.close();
                break;
            }
            case 0: {
                this.close();
                break;
            }
            case 1: {
                this.selectedUser = null;
                this.close();
                break;
            }
            case 102: {
                this.addUser();
                break;
            }
            case 101: {
                this.changePassword();
                break;
            }
            case 103: {
                this.deleteSelectedUser();
                break;
            }
            case 105: {
                this.editGroups();
                break;
            }
            case 104: {
                this.editPermissions();
                break;
            }
            case 100: {
                this.editUser();
                break;
            }
        }
    }

    @Override
    public void construct(CtrlAdminUsers control) {
        this.ctrl = control;
        if (this.serverCombo.size() == 1) {
            this.serverCombo.select(0);
            this.serverCombo.setEnabled(false);
        }
    }

    @Override
    public void construct(String idOfServer, UserListModel userList, boolean adminForUsers, PermissionListModel permissionModel) {
        this.userListModel = userList;
        this.userListWrapper.getViewer().setInput((Object)this.userListModel);
        this.isUserAdmin = adminForUsers;
        this.serverID = idOfServer;
        this.permissionListModel = permissionModel;
        this.refreshDialog();
    }

    @Override
    public void show() {
        this.open();
    }

    private void fldFindKeyTyped() {
        this.userListWrapper.setFilter("*" + this.fldFind.getText().toLowerCase());
        this.userListWrapper.setSelectionOnSingleDisplayedElement();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectedUser = (UserWithGroups)this.userListWrapper.getFirstSelectedUser();
        this.updateDialog();
    }

    private void updateDialog() {
        this.userDetails.setFields(this.selectedUser);
        if (this.selectedUser != null) {
            List<UserGroup> groups = this.selectedUser.getGroups();
            this.groupListModel.setGroups(groups);
            this.groupListWrapper.getViewer().setInput((Object)this.groupListModel);
            this.permissionListWrapper.clear();
            List<EOPermission> permissions = this.permissionListModel.getPermissionsOfUser(this.selectedUser.getUserName());
            this.permissionListWrapper.setPermissions(permissions);
            int i = 0;
            while (i < groups.size()) {
                UserGroup group = groups.get(i);
                List<EOPermission> groupPermissions = this.permissionListModel.getPermissionsOfGroup(group.getGroupName());
                this.permissionListWrapper.addDerivedPermissions(groupPermissions);
                ++i;
            }
            if (this.selectUser) {
                this.btnOk.setEnabled(true);
            }
            this.refreshDialog();
        } else {
            this.userDetails.clearFields();
            this.permissionListWrapper.clear();
            this.permissionListWrapper.setPermissions(new ArrayList());
            this.groupListModel.setGroups(new ArrayList());
            this.groupListWrapper.getViewer().setInput((Object)this.groupListModel);
            if (this.selectUser) {
                this.btnOk.setEnabled(false);
            }
            this.refreshDialog();
        }
    }

    private void refreshDialog() {
        if (this.serverID != null) {
            boolean isUserRealmWritable = this.ctrl.isUserRealmWritable();
            this.getButton(102).setEnabled(this.isUserAdmin && isUserRealmWritable);
            if (this.selectedUser != null) {
                boolean ordinaryUser = !this.selectedUser.isSuperAdmin();
                this.getButton(100).setEnabled(this.isUserAdmin && isUserRealmWritable);
                this.getButton(101).setEnabled(this.isUserAdmin && isUserRealmWritable);
                this.getButton(105).setEnabled(this.isUserAdmin && isUserRealmWritable);
                this.getButton(104).setEnabled(this.isUserAdmin);
                this.getButton(103).setEnabled(this.isUserAdmin && ordinaryUser && isUserRealmWritable);
                this.permissionListWrapper.getViewer().getList().setEnabled(true);
                this.groupListWrapper.getViewer().getList().setEnabled(true);
            } else {
                this.getButton(100).setEnabled(false);
                this.getButton(101).setEnabled(false);
                this.getButton(105).setEnabled(false);
                this.getButton(104).setEnabled(false);
                this.getButton(103).setEnabled(false);
                this.permissionListWrapper.getViewer().getList().setEnabled(false);
                this.groupListWrapper.getViewer().getList().setEnabled(false);
            }
            this.userListWrapper.getViewer().getList().setEnabled(true);
            this.fldFind.setEnabled(true);
        } else {
            this.getButton(102).setEnabled(false);
            this.getButton(100).setEnabled(false);
            this.getButton(101).setEnabled(false);
            this.getButton(105).setEnabled(false);
            this.getButton(104).setEnabled(false);
            this.getButton(103).setEnabled(false);
            this.userListWrapper.getViewer().getList().setEnabled(false);
            this.permissionListWrapper.getViewer().getList().setEnabled(false);
            this.groupListWrapper.getViewer().getList().setEnabled(false);
            this.fldFind.setEnabled(false);
        }
    }

    private void addUser() {
        User newUser = null;
        newUser = this.ctrl.doAddUser();
        this.userListWrapper.getViewer().setInput((Object)this.userListModel);
        if (newUser != null) {
            this.userListWrapper.getViewer().getList().setSelection(this.userListModel.indexOf(newUser));
            this.selectedUser = (UserWithGroups)newUser;
            this.updateDialog();
        } else {
            this.userDetails.clearFields();
            this.selectedUser = null;
            this.updateDialog();
        }
    }

    private void deleteSelectedUser() {
        if (this.selectedUser != null && !this.selectedUser.isSuperAdmin()) {
            this.ctrl.doDeleteUser(this.selectedUser);
        }
        this.selectedUser = null;
        this.userListWrapper.getViewer().refresh();
        this.updateDialog();
    }

    private void editUser() {
        User editedUser = this.ctrl.doEditUserData(this.selectedUser);
        this.userListWrapper.getViewer().setInput((Object)this.userListModel);
        if (editedUser != null) {
            this.userListWrapper.getViewer().getList().setSelection(new String[]{this.userListWrapper.getText(editedUser)});
            this.selectedUser = (UserWithGroups)editedUser;
            this.updateDialog();
        } else {
            this.userDetails.clearFields();
            this.selectedUser = null;
            this.updateDialog();
        }
    }

    private void changePassword() {
        this.ctrl.doChangePassword(this.selectedUser);
    }

    private void editGroups() {
        this.ctrl.doAssignGroups(this.selectedUser);
        this.groupListModel.setGroups(this.selectedUser.getGroups());
        this.groupListWrapper.getViewer().setInput((Object)this.groupListModel);
    }

    private void editPermissions() {
        this.ctrl.doAssignPermissions(this.selectedUser);
        this.updateDialog();
    }

    @Override
    public void serverSelected(ServerConnection serverConnection) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        this.ctrl.setServer(serverConnection);
        this.selectedUser = null;
        this.updateDialog();
    }

    public void selectUser(String idOfServer) {
        this.serverID = idOfServer;
        this.selectUser = true;
    }

    public UserWithGroups getSelectedUser() {
        return this.selectedUser;
    }
}

