/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication.transmissionprocessor;

import de.plans.psc.client.communication.IProgressProvidingRequestJob;
import de.plans.psc.client.communication.Messages;
import de.plans.psc.client.communication.transmissionprocessor.ProgressSummarySnapshot;
import org.eclipse.osgi.util.NLS;

public class RequestJobProgressSummary
implements IProgressProvidingRequestJob.IProgressSummary {
    private static final long KB_Bytes = 1024L;
    private final ProgressSummarySnapshot progress;

    public RequestJobProgressSummary(ProgressSummarySnapshot progress) {
        this.progress = progress;
    }

    @Override
    public String getTaskLabel(String durationString, String serverName) {
        return NLS.bind((String)Messages.getString("RequestJobProgressMonitor.Contacting_Server_01"), (Object[])new Object[]{durationString, serverName});
    }

    @Override
    public String getProgressMessage() {
        String summary;
        if (this.progress != null) {
            if (this.progress.getLastKnownServerSideRequestStatus() != null) {
                switch (this.progress.getLastKnownServerSideRequestStatus()) {
                    case ReceivingRequestData: {
                        summary = NLS.bind((String)Messages.getString("RequestJobProgressSummary.Sending_Request_KB_0123"), (Object[])new Object[]{RequestJobProgressSummary.getBytesInDisplayUnits(this.progress.getRequestNumBytesTransferred()), RequestJobProgressSummary.getBytesInDisplayUnits(this.progress.getRequestTotalStreamLength()), (long)this.progress.getSegmentCountSuccess(), (long)this.progress.getSegmentCountTotal()});
                        break;
                    }
                    case WaitingForProcessor: {
                        summary = NLS.bind((String)Messages.getString("RequestJobProgressSummary.Waiting_for_Server_01"), (Object[])new Object[]{(long)this.progress.getSegmentCountSuccess(), (long)this.progress.getSegmentCountTotal()});
                        break;
                    }
                    case InProgress: {
                        summary = NLS.bind((String)Messages.getString("RequestJobProgressSummary.Waiting_for_Server_In_Progress_01"), (Object[])new Object[]{(long)this.progress.getSegmentCountSuccess(), (long)this.progress.getSegmentCountTotal()});
                        break;
                    }
                    case ResponseDataAvailable: {
                        summary = NLS.bind((String)Messages.getString("RequestJobProgressSummary.Receiving_Response_KB_0123"), (Object[])new Object[]{RequestJobProgressSummary.getBytesInDisplayUnits(this.progress.getResponseNumBytesInBuffer()), RequestJobProgressSummary.getBytesInDisplayUnits(this.progress.getResponseTotalStreamLength()), (long)this.progress.getSegmentCountSuccess(), (long)this.progress.getSegmentCountTotal()});
                        break;
                    }
                    case FailedDueToInternalServerError: {
                        summary = Messages.getString("RequestJobProgressSummary.Request_failed");
                        break;
                    }
                    case Historic: {
                        assert (false) : "The progress dialog should have been closed before the request has become historic";
                        summary = Messages.getString("RequestJobProgressSummary.Historic_Request");
                        break;
                    }
                    default: {
                        assert (false);
                        summary = "Unkown.";
                        break;
                    }
                }
            } else if (this.progress.getResponseNumBytesInBuffer() > 0L || this.progress.getResponseTotalStreamLength() > 0L) {
                assert (false) : "Should never get here, because a body was received without a header containing ServerSideRequestStatus";
                summary = NLS.bind((String)Messages.getString("RequestJobProgressSummary.Receiving_Response_KB_0123"), (Object[])new Object[]{RequestJobProgressSummary.getBytesInDisplayUnits(this.progress.getResponseNumBytesInBuffer()), RequestJobProgressSummary.getBytesInDisplayUnits(this.progress.getResponseTotalStreamLength()), (long)this.progress.getSegmentCountSuccess(), (long)this.progress.getSegmentCountTotal()});
            } else {
                summary = NLS.bind((String)Messages.getString("RequestJobProgressSummary.Sending_Request_KB_0123"), (Object[])new Object[]{RequestJobProgressSummary.getBytesInDisplayUnits(this.progress.getRequestNumBytesTransferred()), RequestJobProgressSummary.getBytesInDisplayUnits(this.progress.getRequestTotalStreamLength()), (long)this.progress.getSegmentCountSuccess(), (long)this.progress.getSegmentCountTotal()});
            }
        } else {
            summary = Messages.getString("RequestJobProgressSummary.Preparing_Request");
        }
        return summary;
    }

    @Override
    public boolean isProgressBlocked() {
        if (this.progress != null) {
            return !this.progress.isLastSegmentSuccessfullyExchanged();
        }
        return true;
    }

    static String getBytesInDisplayUnits(long numBytes) {
        if (numBytes < 0L) {
            return "?";
        }
        if (numBytes == 0L) {
            return "0";
        }
        if (numBytes <= 1024L) {
            return "1";
        }
        return Long.toString((numBytes + 512L) / 1024L);
    }
}

