/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client;

import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class WorkspaceUIDAccessAgent {
    private static final ILogger LOGGER = Logger.getLogger(WorkspaceUIDAccessAgent.class);
    private static final String WORKSPACEUID_FILENAME = "workspace.uid";

    public static String getWorkspaceUID(File workspaceRootDirectory) {
        String workspaceUID = null;
        File workspaceUIDFile = new File(workspaceRootDirectory, WORKSPACEUID_FILENAME);
        if (workspaceUIDFile.exists()) {
            try {
                FileInputStream is = new FileInputStream(workspaceUIDFile);
                InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");
                StringBuffer stringbuf = new StringBuffer();
                char[] buf = new char[256];
                int n = reader.read(buf);
                while (n != -1) {
                    stringbuf.append(buf, 0, n);
                    n = reader.read(buf);
                }
                workspaceUID = stringbuf.toString();
                ((Reader)reader).close();
                ((InputStream)is).close();
            }
            catch (Exception e) {
                LOGGER.fatal("cannot read UID file", (Throwable)e);
            }
        } else {
            workspaceUID = UUIDGenerator.getUniqueID();
            try {
                FileOutputStream os = new FileOutputStream(workspaceUIDFile);
                boolean noWriteErrorOccured = false;
                try {
                    os.write(workspaceUID.getBytes("UTF-8"));
                    noWriteErrorOccured = true;
                }
                finally {
                    if (noWriteErrorOccured) {
                        os.close();
                    } else {
                        try {
                            os.close();
                        }
                        catch (Exception e) {
                            LOGGER.debug("Problem wile closing File stream (probably caused by a previous error)", (Throwable)e);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.fatal("cannot write UID file", (Throwable)e);
            }
        }
        return workspaceUID;
    }
}

