/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.psc.eclipse.client.update;

import com.arcway.lib.java.collectionmaps.SetMap;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.psc.eclipse.client.update.xmlconstraints.CompatibilityConstraints;
import com.arcway.psc.eclipse.client.update.xmlconstraints.CompatibilityConstraintsFileDecoder;
import com.arcway.psc.eclipse.client.update.xmlconstraints.FeatureConstraint;
import com.arcway.psc.eclipse.client.update.xmlconstraints.ItemConstraint;
import com.arcway.psc.eclipse.client.update.xmlconstraints.PluginConstraint;
import com.arcway.psc.eclipse.client.update.xmlconstraints.VersionConstraint;
import de.plans.psc.client.eclipseplugin.EclipsePlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.osgi.framework.Bundle;

public class EclipseClientCompatibilityChecker {
    private static final ILogger LOGGER = Logger.getLogger(EclipseClientCompatibilityChecker.class);
    private static final EclipseClientCompatibilityChecker singleInstance = new EclipseClientCompatibilityChecker();

    private EclipseClientCompatibilityChecker() {
    }

    public static EclipseClientCompatibilityChecker getInstance() {
        return singleInstance;
    }

    public boolean isClientCompatibleWithServer(File compatibilityConstraintsFile) {
        boolean clientIsCompatibleWithServer = false;
        if (compatibilityConstraintsFile == null) {
            clientIsCompatibleWithServer = true;
        } else {
            CompatibilityConstraints compatibilityConstraints = CompatibilityConstraintsFileDecoder.decode(compatibilityConstraintsFile);
            if (compatibilityConstraints == null) {
                clientIsCompatibleWithServer = false;
            } else {
                ClientVersionInfo clientVersionInfo = this.collectClientVersionInformation();
                clientIsCompatibleWithServer = this.checkCompliance(compatibilityConstraints, clientVersionInfo);
            }
        }
        return clientIsCompatibleWithServer;
    }

    private ClientVersionInfo collectClientVersionInformation() {
        Bundle[] bundles;
        IPlatformConfiguration.IFeatureEntry[] features;
        ClientVersionInfo clientVersionInfo = new ClientVersionInfo();
        IPlatformConfiguration config = ConfiguratorUtils.getCurrentPlatformConfiguration();
        IPlatformConfiguration.IFeatureEntry[] iFeatureEntryArray = features = config.getConfiguredFeatureEntries();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformConfiguration.IFeatureEntry element = iFeatureEntryArray[n2];
            String featureIdentifier = element.getFeatureIdentifier();
            if (clientVersionInfo.featureMap.get(featureIdentifier) == null) {
                clientVersionInfo.featureMap.put(featureIdentifier, new ArrayList());
            }
            clientVersionInfo.featureMap.get(featureIdentifier).add(element);
            ++n2;
        }
        Bundle[] bundleArray = bundles = EclipsePlugin.getDefault().getBundleContext().getBundles();
        int n3 = bundles.length;
        n = 0;
        while (n < n3) {
            Bundle bundle = bundleArray[n];
            Object fragmentHost = bundle.getHeaders().get("Fragment-Host");
            if (fragmentHost == null) {
                boolean pluginIsCurrentlyAvailableForUse;
                switch (bundle.getState()) {
                    case 32: {
                        pluginIsCurrentlyAvailableForUse = true;
                        break;
                    }
                    case 2: {
                        pluginIsCurrentlyAvailableForUse = false;
                        LOGGER.warn("Unresolved bundle/plugin " + bundle.getSymbolicName() + " with installation-state INSTALLED detected - Client compatibility check may produce inacurate results.");
                        break;
                    }
                    case 4: {
                        pluginIsCurrentlyAvailableForUse = true;
                        break;
                    }
                    case 8: {
                        pluginIsCurrentlyAvailableForUse = true;
                        break;
                    }
                    case 16: {
                        pluginIsCurrentlyAvailableForUse = true;
                        LOGGER.warn("Bundle/plugin " + bundle.getSymbolicName() + " has unexpected installation-state STOPPING - Client compatibility check may produce inacurate results.");
                        break;
                    }
                    case 1: {
                        pluginIsCurrentlyAvailableForUse = false;
                        LOGGER.warn("Bundle/plugin " + bundle.getSymbolicName() + " has unexpected installation-state UNINSTALLED - Client compatibility check may produce inacurate results.");
                        break;
                    }
                    default: {
                        pluginIsCurrentlyAvailableForUse = false;
                        LOGGER.warn("Bundle/plugin " + bundle.getSymbolicName() + " has a unforeseen installation-state " + bundle.getState() + " - Client compatibility check may produce inacurate results.");
                    }
                }
                if (pluginIsCurrentlyAvailableForUse) {
                    final String pluginId = bundle.getSymbolicName();
                    final PluginVersionIdentifier pluginVersion = new PluginVersionIdentifier(((String)bundle.getHeaders().get("Bundle-Version")).toString());
                    if (clientVersionInfo.pluginsMap.get(pluginId) == null) {
                        clientVersionInfo.pluginsMap.put(pluginId, new ArrayList());
                    }
                    clientVersionInfo.pluginsMap.get(pluginId).add(new IPluginInfo(){

                        @Override
                        public String getPluginId() {
                            return pluginId;
                        }

                        @Override
                        public PluginVersionIdentifier getVersion() {
                            return pluginVersion;
                        }
                    });
                }
            }
            ++n;
        }
        return clientVersionInfo;
    }

    private static void debugPrintBundleList_PlatformBundleGroups() {
        IBundleGroupProvider[] bundleGroupProviders;
        SetMap pluginVersions = new SetMap();
        IBundleGroupProvider[] iBundleGroupProviderArray = bundleGroupProviders = Platform.getBundleGroupProviders();
        int n = bundleGroupProviders.length;
        int n2 = 0;
        while (n2 < n) {
            IBundleGroup[] bundleGroups;
            IBundleGroupProvider bundleGroupProvider = iBundleGroupProviderArray[n2];
            IBundleGroup[] iBundleGroupArray = bundleGroups = bundleGroupProvider.getBundleGroups();
            int n3 = bundleGroups.length;
            int n4 = 0;
            while (n4 < n3) {
                Bundle[] groupBundles;
                IBundleGroup bundleGroup = iBundleGroupArray[n4];
                Bundle[] bundleArray = groupBundles = bundleGroup.getBundles();
                int n5 = groupBundles.length;
                int n6 = 0;
                while (n6 < n5) {
                    String value;
                    String key;
                    Enumeration e;
                    Dictionary headers;
                    String bundleVersion;
                    String symbolicName;
                    Bundle bundle = bundleArray[n6];
                    if (bundle.getState() != 1) {
                        symbolicName = bundle.getSymbolicName();
                        bundleVersion = null;
                        headers = bundle.getHeaders();
                        e = headers.keys();
                        while (e.hasMoreElements()) {
                            key = e.nextElement().toString();
                            value = headers.get(key).toString();
                            if (!key.equalsIgnoreCase("Bundle-Version")) continue;
                            bundleVersion = value;
                        }
                        if (symbolicName != null && bundleVersion != null) {
                            pluginVersions.add((Object)symbolicName, bundleVersion);
                        }
                    } else {
                        symbolicName = bundle.getSymbolicName();
                        bundleVersion = null;
                        headers = bundle.getHeaders();
                        e = headers.keys();
                        while (e.hasMoreElements()) {
                            key = e.nextElement().toString();
                            value = headers.get(key).toString();
                            if (!key.equalsIgnoreCase("Bundle-Version")) continue;
                            bundleVersion = value;
                        }
                        if (symbolicName != null) {
                            // empty if block
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        LOGGER.info("-----Start------- Platform.getBundleGroup.....() ------------");
        int pluginVersionsIndex = 0;
        for (String symbolicName : pluginVersions.keySet()) {
            LOGGER.info((++pluginVersionsIndex + "        ").substring(0, 5));
            LOGGER.info(":  " + symbolicName);
            for (String version : pluginVersions.get((Object)symbolicName)) {
                LOGGER.info("  " + version);
            }
            LOGGER.info("");
        }
        LOGGER.info("-----End------- Platform.getBundleGroup.....() ------------");
        LOGGER.info("");
        LOGGER.info("");
    }

    private static void debugPrintBundleList_BundleContext() {
        int ACTIVE = 0;
        int INSTALLED = 0;
        int RESOLVED = 0;
        int STARTING = 0;
        int STOPPING = 0;
        int UNINSTALLED = 0;
        int unknown = 0;
        int fragments = 0;
        Bundle[] contextBundles = EclipsePlugin.getDefault().getBundleContext().getBundles();
        LOGGER.info("-----Start------- EclipsePlugin.getDefault().getBundleContext().getBundles() ------------");
        int bundlesIndex = 0;
        Bundle[] bundleArray = contextBundles;
        int n = contextBundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getHeaders().get("Fragment-Host") != null) {
                LOGGER.info("Detected Fragment " + ++fragments + " : " + bundle.getSymbolicName());
            } else {
                LOGGER.info((++bundlesIndex + "        ").substring(0, 5));
                switch (bundle.getState()) {
                    case 32: {
                        LOGGER.info("ACTIVE     ");
                        ++ACTIVE;
                        break;
                    }
                    case 2: {
                        LOGGER.info("INSTALLED  ");
                        ++INSTALLED;
                        break;
                    }
                    case 4: {
                        LOGGER.info("RESOLVED   ");
                        ++RESOLVED;
                        break;
                    }
                    case 8: {
                        LOGGER.info("STARTING   ");
                        ++STARTING;
                        break;
                    }
                    case 16: {
                        LOGGER.info("STOPPING   ");
                        ++STOPPING;
                        break;
                    }
                    case 1: {
                        LOGGER.info("UNINSTALLED");
                        ++UNINSTALLED;
                        break;
                    }
                    default: {
                        ++unknown;
                        LOGGER.info("<unknown>  ");
                    }
                }
                LOGGER.info(":  " + bundle.getSymbolicName() + "  " + (String)bundle.getHeaders().get("Bundle-Version"));
            }
            ++n2;
        }
        LOGGER.info("");
        LOGGER.info("ACTIVE:      " + ACTIVE);
        LOGGER.info("INSTALLED:   " + INSTALLED);
        LOGGER.info("RESOLVED:    " + RESOLVED);
        LOGGER.info("STARTING:    " + STARTING);
        LOGGER.info("STOPPING:    " + STOPPING);
        LOGGER.info("UNINSTALLED: " + UNINSTALLED);
        LOGGER.info("unknown:     " + unknown);
        LOGGER.info("fragments:   " + fragments);
        LOGGER.info("-----End------- EclipsePlugin.getDefault().getBundleContext().getBundles() ------------");
    }

    private boolean checkFeatureCompliance(CompatibilityConstraints compatibilityConstraints, ClientVersionInfo clientVersionInfo) {
        Map<String, FeatureConstraint> featureConstraints = compatibilityConstraints.getFeatureConstraints();
        boolean complianceTestResult = true;
        for (FeatureConstraint featureConstraint : featureConstraints.values()) {
            String featureId = featureConstraint.getId();
            ArrayList installedFeaturesWithMatchingId = clientVersionInfo.featureMap.get(featureId);
            if (installedFeaturesWithMatchingId == null) {
                installedFeaturesWithMatchingId = new ArrayList();
            }
            if (ItemConstraint.Availability.MANDATORY == featureConstraint.getAvailability()) {
                if (installedFeaturesWithMatchingId.isEmpty()) {
                    complianceTestResult = false;
                }
            } else if (ItemConstraint.Availability.OPTIONAL != featureConstraint.getAvailability()) {
                if (ItemConstraint.Availability.PROHIBITED == featureConstraint.getAvailability()) {
                    if (!installedFeaturesWithMatchingId.isEmpty()) {
                        complianceTestResult = false;
                    }
                } else assert (false);
            }
            if (featureConstraint.getSingleton() && installedFeaturesWithMatchingId.size() > 1) {
                complianceTestResult = false;
            }
            for (IPlatformConfiguration.IFeatureEntry installedFeature : installedFeaturesWithMatchingId) {
                PluginVersionIdentifier installedFeatureVersion = new PluginVersionIdentifier(installedFeature.getFeatureVersion());
                for (VersionConstraint versionConstraint : featureConstraint.getVersionConstraints()) {
                    if (versionConstraint.isSatisfiedBy(installedFeatureVersion)) continue;
                    complianceTestResult = false;
                }
            }
        }
        return complianceTestResult;
    }

    private boolean checkCompliance(CompatibilityConstraints compatibilityConstraints, ClientVersionInfo clientVersionInfo) {
        boolean complianceTestResult = true;
        if (compatibilityConstraints.getFeatureConstraints().size() > 0) {
            if (clientVersionInfo.featureMap.size() > 0) {
                complianceTestResult = complianceTestResult && this.checkFeatureCompliance(compatibilityConstraints, clientVersionInfo);
            } else {
                LOGGER.debug("Checking of Feature constraints will be based on plugins - Client compatibility check may produce inacurate results.");
                Map<String, FeatureConstraint> featureConstraints = compatibilityConstraints.getFeatureConstraints();
                for (FeatureConstraint featureConstraint : featureConstraints.values()) {
                    String pluginId;
                    String featureId = featureConstraint.getId();
                    if ("com.arcway.cockpit.base".equals(featureId)) {
                        pluginId = "com.arcway.cockpit.fmca";
                    } else if ("com.arcway.cockpit.clientserver".equals(featureId)) {
                        pluginId = "com.arcway.cockpit.frameserverproxy";
                    } else if ("com.arcway.cockpit.standalone".equals(featureId)) {
                        pluginId = "com.arcway.cockpit.framestandaloneserverproxywithcommit";
                    } else if (featureId.startsWith("com.arcway.cockpit.")) {
                        pluginId = featureId;
                    } else {
                        pluginId = featureId;
                        LOGGER.warn("Checking of non com.arcway.cockpit features is not supported by this client but was requested for feature " + featureId + " - Client compatibility check may produce inacurate results.");
                    }
                    ArrayList installedPluginsWithMatchingId = clientVersionInfo.pluginsMap.get(pluginId);
                    if (installedPluginsWithMatchingId == null) {
                        installedPluginsWithMatchingId = new ArrayList(0);
                    }
                    if (ItemConstraint.Availability.MANDATORY == featureConstraint.getAvailability()) {
                        if (installedPluginsWithMatchingId.isEmpty()) {
                            complianceTestResult = false;
                        }
                    } else if (ItemConstraint.Availability.OPTIONAL != featureConstraint.getAvailability()) {
                        if (ItemConstraint.Availability.PROHIBITED == featureConstraint.getAvailability()) {
                            if (!installedPluginsWithMatchingId.isEmpty()) {
                                complianceTestResult = false;
                            }
                        } else assert (false);
                    }
                    if (featureConstraint.getSingleton() && installedPluginsWithMatchingId.size() > 1) {
                        complianceTestResult = false;
                    }
                    for (IPluginInfo installedPluginWithIdOfFeature : installedPluginsWithMatchingId) {
                        PluginVersionIdentifier installedPluginVersion = installedPluginWithIdOfFeature.getVersion();
                        for (VersionConstraint versionConstraint : featureConstraint.getVersionConstraints()) {
                            if (versionConstraint.isSatisfiedBy(installedPluginVersion)) continue;
                            complianceTestResult = false;
                        }
                    }
                }
            }
        }
        Map<String, PluginConstraint> pluginConstraints = compatibilityConstraints.getPluginConstraints();
        for (PluginConstraint pluginConstraint : pluginConstraints.values()) {
            String pluginId = pluginConstraint.getId();
            ArrayList installedPluginsWithMatchingId = clientVersionInfo.pluginsMap.get(pluginId);
            if (installedPluginsWithMatchingId == null) {
                installedPluginsWithMatchingId = new ArrayList(0);
            }
            if (ItemConstraint.Availability.MANDATORY == pluginConstraint.getAvailability()) {
                if (installedPluginsWithMatchingId.isEmpty()) {
                    complianceTestResult = false;
                }
            } else if (ItemConstraint.Availability.OPTIONAL != pluginConstraint.getAvailability()) {
                if (ItemConstraint.Availability.PROHIBITED == pluginConstraint.getAvailability()) {
                    if (!installedPluginsWithMatchingId.isEmpty()) {
                        complianceTestResult = false;
                    }
                } else assert (false);
            }
            if (pluginConstraint.getSingleton() && installedPluginsWithMatchingId.size() > 1) {
                complianceTestResult = false;
            }
            for (IPluginInfo installedPlugin : installedPluginsWithMatchingId) {
                PluginVersionIdentifier installedPluginVersion = installedPlugin.getVersion();
                for (VersionConstraint versionConstraint : pluginConstraint.getVersionConstraints()) {
                    if (versionConstraint.isSatisfiedBy(installedPluginVersion)) continue;
                    complianceTestResult = false;
                }
            }
        }
        return complianceTestResult;
    }

    private static class ClientVersionInfo {
        public HashMap<String, ArrayList<IPlatformConfiguration.IFeatureEntry>> featureMap = new HashMap();
        public HashMap<String, ArrayList<IPluginInfo>> pluginsMap = new HashMap();

        private ClientVersionInfo() {
        }
    }

    private static interface IPluginInfo {
        public String getPluginId();

        public PluginVersionIdentifier getVersion();
    }
}

