/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.encoding;

import de.plans.lib.xml.encoding.EOEncodableObjectWithRole;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public class EOList<E extends EncodableObjectBase>
extends EOEncodableObjectWithRole
implements List<E>,
RandomAccess {
    public static final String XML_NAME = "List";
    private ArrayList<E> elements;

    public EOList() {
        super(XML_NAME);
        this.elements = new ArrayList();
    }

    public EOList(int capacity) {
        super(XML_NAME);
        this.elements = new ArrayList(capacity);
    }

    public EOList(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
        this.elements = new ArrayList();
    }

    public EOList(Collection<? extends E> elements) {
        this();
        this.addAll(elements);
    }

    public EOList(EOList<? extends E> list) {
        this((Collection<E>)list);
        this.setRole(list.getRole());
    }

    public EOList(Collection<E> elements, String role) {
        this(elements);
        this.setRole(role);
    }

    public EOList(String role) {
        this();
        this.setRole(role);
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        return super.setAttributeFromXML(name, value);
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttributesToXML(writeContext);
    }

    @Override
    protected boolean hasChildren() {
        return !this.elements.isEmpty();
    }

    @Override
    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        for (EncodableObjectBase e : this.elements) {
            if (e == null) continue;
            e.writeXMLBody(writeContext, depth);
        }
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        this.elements.add(newChild);
        return true;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public E get(int i) {
        return (E)((EncodableObjectBase)this.elements.get(i));
    }

    public E getEOObject(int i) {
        return (E)((EncodableObjectBase)this.elements.get(i));
    }

    @Override
    public boolean isEmpty() {
        return this.elements == null || this.elements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        assert (a.getClass().getComponentType().isAssignableFrom(EncodableObjectBase.class) || EncodableObjectBase.class.isAssignableFrom(a.getClass().getComponentType()));
        return this.elements.toArray(a);
    }

    @Override
    public boolean add(E o) {
        return this.elements.add(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.elements.remove(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.elements.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c == null) {
            return false;
        }
        return this.elements.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (c == null) {
            return false;
        }
        return this.elements.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.elements.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.elements.retainAll(c);
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    @Override
    public E set(int index, E element) {
        return (E)((EncodableObjectBase)this.elements.set(index, element));
    }

    @Override
    public void add(int index, E element) {
        this.elements.add(index, element);
    }

    @Override
    public E remove(int index) {
        return (E)((EncodableObjectBase)this.elements.remove(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.elements.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.elements.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.elements.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.elements.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.elements.subList(fromIndex, toIndex);
    }

    public ArrayList<E> getElements() {
        return this.elements;
    }

    public void setElements(ArrayList<E> list) {
        this.elements = list;
    }
}

