/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.structure;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.structure.IStructureElement;
import de.plans.lib.structure.IStructureProvider;
import de.plans.lib.structure.Relation;
import de.plans.lib.structure.StructureLogging;
import de.plans.lib.structure.StructuredRelation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StructureProxy
extends StructureLogging {
    private static final ILogger LOGGER = Logger.getLogger(StructureProxy.class);
    private final Collection structureElementProxies;
    private final Map wrappedToProxy;
    private final IStructureProvider structureProvider;

    public StructureProxy(IStructureProvider structureProvider) {
        assert (structureProvider != null) : "relationProvider is null";
        this.structureProvider = structureProvider;
        Collection structureElementsToWrap = structureProvider.getAllElements();
        int sizeHint = structureElementsToWrap.size();
        this.structureElementProxies = new ArrayList(sizeHint);
        this.wrappedToProxy = new HashMap(sizeHint);
        for (Object structureElementToWrap : structureElementsToWrap) {
            StructureElementProxy proxy = new StructureElementProxy(structureElementToWrap);
            this.structureElementProxies.add(proxy);
            this.wrappedToProxy.put(structureElementToWrap, proxy);
        }
        for (StructureElementProxy currentProxy : this.structureElementProxies) {
            Object currentWrappedElement = currentProxy.getWrappedElement();
            Collection wrappedParentElements = structureProvider.getParents(currentWrappedElement);
            if (wrappedParentElements == null) {
                wrappedParentElements = Collections.EMPTY_LIST;
            }
            for (Object wrappedParentElement : wrappedParentElements) {
                StructureElementProxy parentProxy = (StructureElementProxy)this.wrappedToProxy.get(wrappedParentElement);
                currentProxy.addParent(parentProxy);
                parentProxy.addChild(currentProxy);
            }
            Collection wrappedChildElements = structureProvider.getChildren(currentWrappedElement);
            if (wrappedChildElements == null) {
                wrappedChildElements = Collections.EMPTY_LIST;
            }
            for (Object wrappedChildElement : wrappedChildElements) {
                if (structureProvider.getParents(wrappedChildElement) != null) continue;
                StructureElementProxy childProxy = (StructureElementProxy)this.wrappedToProxy.get(wrappedChildElement);
                currentProxy.addChild(childProxy);
                childProxy.addParent(currentProxy);
            }
        }
    }

    public Collection getAllProxyElements() {
        return this.getAllElements();
    }

    public void updateProxiedElementsRelations(Collection elementsToUpdate) {
        assert (elementsToUpdate != null) : "elementsToUpdate is null";
        super.updateElementsRelations(this.getStructureElements(elementsToUpdate));
    }

    public void removeProxiedElementsRelations(Collection elementsToRemove) {
        assert (elementsToRemove != null) : "elementsToRemove is null";
        super.removeElementsRelations(this.getStructureElements(elementsToRemove));
    }

    public void removeProxiedElementRelations(Object elementToRemove) {
        assert (elementToRemove != null) : "elementToRemove is null";
        super.removeElementRelations(this.getStructureElement(elementToRemove));
    }

    public void removeProxiedElement(Object elementToRemove) {
        assert (elementToRemove != null) : "elementToRemove is null";
        StructureElementProxy proxyToRemove = this.getStructureElement(elementToRemove);
        super.removeElementRelations(proxyToRemove);
        this.structureElementProxies.remove(proxyToRemove);
        this.wrappedToProxy.remove(elementToRemove);
    }

    public void createProxiedElementsRelations(Collection elementsToCreate) {
        assert (elementsToCreate != null) : "elementsToCreate is null";
        super.createElementsRelations(this.getStructureElements(elementsToCreate));
    }

    private Collection getStructureElements(Collection wrappedElements) {
        ArrayList<StructureElementProxy> wrappingElements = new ArrayList<StructureElementProxy>(wrappedElements.size());
        for (Object wrappedElement : wrappedElements) {
            StructureElementProxy wrappingElement = this.getStructureElement(wrappedElement);
            wrappingElements.add(wrappingElement);
        }
        return wrappingElements;
    }

    private StructureElementProxy getStructureElement(Object wrappedElement) {
        StructureElementProxy wrappingElement = (StructureElementProxy)this.wrappedToProxy.get(wrappedElement);
        assert (wrappingElement != null) : "element is not an element of the structure";
        return wrappingElement;
    }

    @Override
    protected int getNumberOfElements() {
        return this.structureElementProxies.size();
    }

    @Override
    protected Collection getAllElements() {
        return this.structureElementProxies;
    }

    @Override
    protected void createRelation(StructuredRelation relation) {
        StructureElementProxy child = (StructureElementProxy)relation.getChild();
        StructureElementProxy parent = (StructureElementProxy)relation.getParent();
        child.addParent(parent);
        parent.addChild(child);
        this.logRelationCreation(this.getWrappedRelation(child, parent));
    }

    @Override
    protected void removeRelation(StructuredRelation relation) {
        StructureElementProxy parent;
        StructureElementProxy child = (StructureElementProxy)relation.getChild();
        if (child == (parent = (StructureElementProxy)relation.getParent())) {
            LOGGER.error("child == parent");
        }
        child.removeParent(parent);
        parent.removeChild(child);
        this.logRelationRemoval(this.getWrappedRelation(child, parent));
    }

    private Relation getWrappedRelation(StructureElementProxy child, StructureElementProxy parent) {
        Object wrappedChild = child.getWrappedElement();
        Object wrappedParent = parent.getWrappedElement();
        Relation wrappedRelation = new Relation(wrappedChild, wrappedParent);
        return wrappedRelation;
    }

    @Override
    protected boolean isAncestor(IStructureElement ancestor, IStructureElement descendant) {
        Object wrappedAncestor = ((StructureElementProxy)ancestor).getWrappedElement();
        Object wrappedDescendant = ((StructureElementProxy)descendant).getWrappedElement();
        return this.structureProvider.isAncestor(wrappedAncestor, wrappedDescendant);
    }

    @Override
    protected int getStructureTypeHint() {
        return this.structureProvider.getStructureTypeHint();
    }

    public static class StructureElementProxy
    implements IStructureElement {
        private final Object wrappedElement;
        private final Collection childElements = new ArrayList();
        private final Collection parentElements = new ArrayList();

        StructureElementProxy(Object elementToWrap) {
            assert (elementToWrap != null) : "elementToWrap is null";
            this.wrappedElement = elementToWrap;
        }

        @Override
        public Collection getParents() {
            return this.parentElements;
        }

        @Override
        public Collection getChildren() {
            return this.childElements;
        }

        void addChild(StructureElementProxy child) {
            assert (child != null) : "child is null";
            assert (!this.childElements.contains(child)) : "child is already a child element";
            this.childElements.add(child);
        }

        void addParent(StructureElementProxy parent) {
            assert (parent != null) : "parent is null";
            if (this.parentElements.contains(parent)) {
                LOGGER.error("Parent: " + parent.wrappedElement);
                LOGGER.error("Child: " + this.wrappedElement);
                throw new NullPointerException();
            }
            assert (!this.parentElements.contains(parent)) : "parent is already a parent element";
            this.parentElements.add(parent);
        }

        void removeChild(StructureElementProxy child) {
            assert (child != null) : "child is null";
            assert (this.childElements.contains(child)) : "child is not a child element";
            this.childElements.remove(child);
        }

        void removeParent(StructureElementProxy parent) {
            assert (parent != null) : "parent is null";
            assert (this.parentElements.contains(parent)) : "parent is not a parent element";
            this.parentElements.remove(parent);
        }

        public Object getWrappedElement() {
            return this.wrappedElement;
        }
    }
}

