/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.structure;

import de.plans.lib.structure.AbstractStructureTraverserCheckVisitedElements;
import de.plans.lib.structure.FindStructureElementVisitor;
import de.plans.lib.structure.IRelative;
import de.plans.lib.structure.IStructureElement;
import de.plans.lib.structure.NOPVisitor;
import de.plans.lib.structure.RelativeAncestorsAreLower;
import de.plans.lib.structure.RelativeDescendantsAreLower;
import de.plans.lib.structure.StructureTraverserAllAncestors;
import de.plans.lib.structure.StructureTraverserAllDescendants;
import de.plans.lib.structure.StructureTraverserAllLowerElements;
import de.plans.lib.structure.StructuredRelation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public abstract class AbstractStructure {
    public static final int TYPEHINT_NONE = 1;
    public static final int TYPEHINT_NEARLY_TREE_WITH_ANCESTOR_ROOT = 2;
    public static final int TYPEHINT_NEARLY_TREE_WITH_DESCENDANT_ROOT = 3;
    public static final int TYPEHINT_TYPICALLY_MORE_PARENTS_THAN_CHILDREN = 4;
    public static final int TYPEHINT_TYPICALLY_MORE_CHILDREN_THAN_PARENTS = 5;

    public void updateElementsRelations(Collection elementsToUpdate) {
        assert (elementsToUpdate != null) : "elementsToCreate is null";
        Collection elementsNotToUpdate = this.getInverseElements(elementsToUpdate);
        this.removeElementsRelations(elementsToUpdate);
        this.createElementsRelations(elementsNotToUpdate, elementsToUpdate);
    }

    public void removeElementsRelations(Collection elementsToRemove) {
        assert (elementsToRemove != null) : "elementsToRemove is null";
        for (IStructureElement elementToRemove : elementsToRemove) {
            this.removeElementRelations(elementToRemove);
        }
    }

    public void removeElementRelations(IStructureElement elementToRemove) {
        StructuredRelation relationToRemove;
        assert (elementToRemove != null) : "elementToRemove is null";
        ArrayList<StructuredRelation> relationsToCreate = new ArrayList<StructuredRelation>();
        ArrayList<StructuredRelation> relationsToRemove = new ArrayList<StructuredRelation>();
        for (IStructureElement parent : elementToRemove.getParents()) {
            for (IStructureElement child : elementToRemove.getChildren()) {
                StructuredRelation relationToCreate = new StructuredRelation(child, parent);
                relationsToCreate.add(relationToCreate);
            }
        }
        for (IStructureElement parent : elementToRemove.getParents()) {
            relationToRemove = new StructuredRelation(elementToRemove, parent);
            relationsToRemove.add(relationToRemove);
        }
        for (IStructureElement child : elementToRemove.getChildren()) {
            relationToRemove = new StructuredRelation(child, elementToRemove);
            relationsToRemove.add(relationToRemove);
        }
        this.removeRelations(relationsToRemove);
        Iterator i = relationsToCreate.iterator();
        while (i.hasNext()) {
            StructuredRelation relationToCreate = (StructuredRelation)i.next();
            if (!this.isAncestorInStructure(relationToCreate.getStructuredParent(), relationToCreate.getStructuredChild())) continue;
            i.remove();
        }
        this.createRelations(relationsToCreate);
    }

    public void createElementsRelations(Collection elementsToCreate) {
        assert (elementsToCreate != null) : "elementsToCreate is null";
        Collection allElements = this.getInverseElements(elementsToCreate);
        this.createElementsRelations(allElements, elementsToCreate);
    }

    private void createElementsRelations(Collection allElements, Collection elementsToCreate) {
        for (IStructureElement element : elementsToCreate) {
            this.createElementRelations(allElements, element);
            allElements.add(element);
        }
    }

    private void createElementRelations(Collection allElements, IStructureElement elementToCreate) {
        StructuredRelation relationToCreate;
        ArrayList<StructuredRelation> relationsToCreate = new ArrayList<StructuredRelation>();
        ArrayList<StructuredRelation> relationsToRemove = new ArrayList<StructuredRelation>();
        Iterator i = elementToCreate.getParents().iterator();
        while (i.hasNext()) {
            IStructureElement parent = (IStructureElement)i.next();
            this.removeRelation(new StructuredRelation(elementToCreate, parent));
            i = elementToCreate.getParents().iterator();
        }
        i = elementToCreate.getChildren().iterator();
        while (i.hasNext()) {
            IStructureElement child = (IStructureElement)i.next();
            this.removeRelation(new StructuredRelation(child, elementToCreate));
            i = elementToCreate.getChildren().iterator();
        }
        AncestorsAreLowerComperator ancestorsAreLowerComperator = new AncestorsAreLowerComperator();
        DescendantsAreLowerComperator descendantsAreLowerComperator = new DescendantsAreLowerComperator();
        Collection parents = this.getPrecessors(allElements, elementToCreate, ancestorsAreLowerComperator);
        Collection children = this.getPrecessors(allElements, elementToCreate, descendantsAreLowerComperator);
        for (IStructureElement parent : parents) {
            relationToCreate = new StructuredRelation(elementToCreate, parent);
            relationsToCreate.add(relationToCreate);
        }
        for (IStructureElement child : children) {
            relationToCreate = new StructuredRelation(child, elementToCreate);
            relationsToCreate.add(relationToCreate);
        }
        this.createRelations(relationsToCreate);
        Collection parentCollection = elementToCreate.getParents();
        HashSet<IStructureElement> parentSet = new HashSet<IStructureElement>(parentCollection.size());
        for (IStructureElement parent : parentCollection) {
            parentSet.add(parent);
        }
        for (IStructureElement child : elementToCreate.getChildren()) {
            for (IStructureElement parent : child.getParents()) {
                if (!parentSet.contains(parent)) continue;
                StructuredRelation relationToRemove = new StructuredRelation(child, parent);
                relationsToRemove.add(relationToRemove);
            }
        }
        this.removeRelations(relationsToRemove);
    }

    private Collection getInverseElements(Collection elementsToUpdate) {
        Collection allElements = this.getAllElements();
        int numberOfAllElements = allElements.size();
        int numberOfElementsToUpdate = elementsToUpdate.size();
        int numberOfElementsNotToUpdate = numberOfAllElements - numberOfElementsToUpdate;
        HashSet setOfElementsToUpdate = new HashSet(numberOfElementsToUpdate);
        setOfElementsToUpdate.addAll(elementsToUpdate);
        ArrayList<IStructureElement> elementsNotToUpdate = new ArrayList<IStructureElement>(numberOfElementsNotToUpdate);
        for (IStructureElement element : allElements) {
            if (setOfElementsToUpdate.contains(element)) continue;
            elementsNotToUpdate.add(element);
        }
        return elementsNotToUpdate;
    }

    public boolean isAncestorInStructure(IStructureElement ancestor, IStructureElement descendant) {
        StructureTraverserAllLowerElements traverser;
        IStructureElement startElement;
        boolean startWithAncestor = false;
        switch (this.getStructureTypeHint()) {
            case 3: 
            case 4: {
                startWithAncestor = true;
            }
        }
        if (startWithAncestor) {
            startElement = ancestor;
            FindStructureElementVisitor visitor = new FindStructureElementVisitor(descendant);
            traverser = new StructureTraverserAllDescendants(this, visitor);
        } else {
            startElement = descendant;
            FindStructureElementVisitor visitor = new FindStructureElementVisitor(ancestor);
            traverser = new StructureTraverserAllAncestors(this, visitor);
        }
        return traverser.traverse(Collections.singleton(startElement), AbstractStructureTraverserCheckVisitedElements.MODE_DONT_PREVENT_MULTIPLE_VISITS);
    }

    private Collection getPrecessors(Collection allElements, IStructureElement element, IRelativeComperator comperator) {
        int sizeHint = allElements.size();
        HashSet<IStructureElement> surelyNotLower = new HashSet<IStructureElement>(sizeHint);
        HashSet<IStructureElement> surelyLower = new HashSet<IStructureElement>(sizeHint);
        HashSet<IStructureElement> possiblePrecessors = new HashSet<IStructureElement>();
        for (IStructureElement currentElement : allElements) {
            if (!comperator.getPrecessors(currentElement).isEmpty()) continue;
            if (comperator.isLower(currentElement, element)) {
                surelyLower.add(currentElement);
                possiblePrecessors.add(currentElement);
                continue;
            }
            surelyNotLower.add(currentElement);
        }
        ArrayList<IStructureElement> precessors = new ArrayList<IStructureElement>();
        Iterator getter = possiblePrecessors.iterator();
        while (getter.hasNext()) {
            IStructureElement possiblePrecessor = (IStructureElement)getter.next();
            getter.remove();
            boolean atLeastOneSuccessorIsLower = false;
            for (IStructureElement currentSuccessor : comperator.getSuccessors(possiblePrecessor)) {
                if (surelyNotLower.contains(currentSuccessor)) continue;
                if (surelyLower.contains(currentSuccessor)) {
                    atLeastOneSuccessorIsLower |= true;
                    continue;
                }
                if (comperator.isLower(currentSuccessor, element)) {
                    surelyLower.add(currentSuccessor);
                    possiblePrecessors.add(currentSuccessor);
                    atLeastOneSuccessorIsLower |= true;
                    continue;
                }
                surelyNotLower.add(currentSuccessor);
            }
            if (!atLeastOneSuccessorIsLower) {
                precessors.add(possiblePrecessor);
            }
            getter = possiblePrecessors.iterator();
        }
        return precessors;
    }

    private void createRelations(Collection relations) {
        for (StructuredRelation relation : relations) {
            this.createRelation(relation);
        }
    }

    private void removeRelations(Collection relations) {
        for (StructuredRelation relation : relations) {
            this.removeRelation(relation);
        }
    }

    public Collection getAllAncestors(Collection startElements) {
        assert (startElements != null) : "startElements is null";
        HashSet allAncestors = new HashSet(this.getNumberOfElements());
        StructureTraverserAllAncestors traverser = new StructureTraverserAllAncestors(this, NOPVisitor.INSTANCE);
        traverser.traverse(startElements, allAncestors);
        return allAncestors;
    }

    public Collection getAllDescendants(Collection startElements) {
        assert (startElements != null) : "startElements is null";
        HashSet allDescendants = new HashSet(this.getNumberOfElements());
        StructureTraverserAllDescendants traverser = new StructureTraverserAllDescendants(this, NOPVisitor.INSTANCE);
        traverser.traverse(startElements, allDescendants);
        return allDescendants;
    }

    protected abstract Collection getAllElements();

    protected abstract int getNumberOfElements();

    protected abstract void createRelation(StructuredRelation var1);

    protected abstract void removeRelation(StructuredRelation var1);

    protected abstract boolean isAncestor(IStructureElement var1, IStructureElement var2);

    protected abstract int getStructureTypeHint();

    private class AncestorsAreLowerComperator
    extends RelativeAncestorsAreLower
    implements IRelativeComperator {
        private AncestorsAreLowerComperator() {
        }

        @Override
        public boolean isLower(IStructureElement lowerElement, IStructureElement higherElement) {
            return AbstractStructure.this.isAncestor(lowerElement, higherElement);
        }
    }

    private class DescendantsAreLowerComperator
    extends RelativeDescendantsAreLower
    implements IRelativeComperator {
        private DescendantsAreLowerComperator() {
        }

        @Override
        public boolean isLower(IStructureElement lowerElement, IStructureElement higherElement) {
            return AbstractStructure.this.isAncestor(higherElement, lowerElement);
        }
    }

    private static interface IRelativeComperator
    extends IRelative {
        public boolean isLower(IStructureElement var1, IStructureElement var2);
    }
}

