/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.IStyledDocumentWithoutAWT;
import javax.swing.text.StyledEditorKitWithoutAWT;
import javax.swing.text.rtf.RTFGenerator;
import javax.swing.text.rtf.RTFReaderWithoutAWT;

public class RTFEditorKitWithoutAWT
extends StyledEditorKitWithoutAWT {
    @Override
    public String getContentType() {
        return "text/rtf";
    }

    @Override
    public void read(InputStream in, Document doc, int pos) throws IOException, BadLocationException {
        if (doc instanceof IStyledDocumentWithoutAWT) {
            RTFReaderWithoutAWT rdr = new RTFReaderWithoutAWT((IStyledDocumentWithoutAWT)doc);
            rdr.readFromStream(in);
            rdr.close();
        } else {
            super.read(in, doc, pos);
        }
    }

    @Override
    public void write(OutputStream out, Document doc, int pos, int len) throws IOException, BadLocationException {
        RTFGenerator.writeDocument(doc, out);
    }

    @Override
    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        if (doc instanceof IStyledDocumentWithoutAWT) {
            RTFReaderWithoutAWT rdr = new RTFReaderWithoutAWT((IStyledDocumentWithoutAWT)doc);
            rdr.readFromReader(in);
            rdr.close();
        } else {
            super.read(in, doc, pos);
        }
    }

    @Override
    public void write(Writer out, Document doc, int pos, int len) throws IOException, BadLocationException {
        throw new IOException("RTF is an 8-bit format");
    }
}

