/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util.valueranges;

import com.arcway.lib.java.SetterSuccess;
import de.plans.lib.util.valueranges.IValueRangeHelperList;
import de.plans.lib.util.valueranges.Messages;

public abstract class ValueRangeHelperListElement
implements IValueRangeHelperList {
    protected boolean lastCheckWasSuccessful = true;
    protected String lastErrorMessage_withoutDescription = "";
    protected String lastErrorMessage_part1 = "";
    protected String lastErrorMessage_part2 = "";
    protected boolean isUsingEmptyStringSymbol = true;

    @Override
    public boolean check(String valueToCheck) {
        boolean isEmptyString;
        assert (valueToCheck != null) : "value must not be null";
        boolean bl = isEmptyString = valueToCheck.equals("") || this.isUsingEmptyStringSymbol && valueToCheck.equals("");
        if (this.acceptsEmptyString() || !isEmptyString) {
            this.lastCheckWasSuccessful = true;
        } else {
            this.lastErrorMessage_part1 = Messages.getString("ValueRangeHelperListElement.ERROR_PART_I");
            this.lastErrorMessage_part2 = Messages.getString("ValueRangeHelperListElement.ERROR_PART_II");
            this.lastErrorMessage_withoutDescription = Messages.getString("ValueRangeHelperListElement.ERROR_WITHOUTDESCRIPTION");
            this.lastCheckWasSuccessful = false;
        }
        return this.lastCheckWasSuccessful;
    }

    @Override
    public SetterSuccess setPersistentValue(String newValue) {
        String[] possibleValues = this.getList();
        String oldValue = this.getThisElement();
        if (this.isUsingEmptyStringSymbol && this.acceptsEmptyString() && "".equals(newValue)) {
            this.setThisElement("");
            return oldValue == null || !oldValue.equals("") ? SetterSuccess.VALUE_CHANGED : SetterSuccess.VALUE_DID_NOT_CHANGE;
        }
        String[] stringArray = possibleValues;
        int n = possibleValues.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.equals(newValue)) {
                this.setThisElement(newValue);
                boolean valueChanged = oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue);
                return valueChanged ? SetterSuccess.VALUE_CHANGED : SetterSuccess.VALUE_DID_NOT_CHANGE;
            }
            ++n2;
        }
        this.createNewListElement(newValue);
        return SetterSuccess.VALUE_CHANGED;
    }

    @Override
    public String getDisplayFormat() {
        String displayString = this.getThisElement();
        if (this.isUsingEmptyStringSymbol) {
            if (displayString != null && !displayString.trim().equals("")) {
                return displayString;
            }
            return "";
        }
        if (displayString != null) {
            return displayString;
        }
        return "";
    }

    @Override
    public String[] getPossibleValues() {
        String[] possibleValues = this.getList();
        if (this.acceptsEmptyString() && this.isUsingEmptyStringSymbol) {
            String[] possibleValuesInclEmptyString = new String[possibleValues.length + 1];
            possibleValuesInclEmptyString[0] = "";
            int c = 0;
            while (c < possibleValues.length) {
                possibleValuesInclEmptyString[c + 1] = possibleValues[c];
                ++c;
            }
            return possibleValuesInclEmptyString;
        }
        return possibleValues;
    }

    @Override
    public String getErrorMessage(String description) {
        if (this.lastCheckWasSuccessful) {
            return "";
        }
        if (description == null) {
            return this.lastErrorMessage_withoutDescription;
        }
        return String.valueOf(this.lastErrorMessage_part1) + description + this.lastErrorMessage_part2;
    }

    protected abstract String[] getList();

    protected abstract String getThisElement();

    protected abstract void setThisElement(String var1);

    protected abstract void createNewListElement(String var1);

    protected abstract boolean acceptsEmptyString();
}

