/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util;

import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

public abstract class NumberVerifyListener
implements VerifyListener {
    public static final char MINUS = '-';
    public static final char COMMA = '.';
    private final Text text;
    private final boolean unsigned;
    private final boolean withComma;

    public NumberVerifyListener(Text text, boolean unsigned, boolean withComma) {
        assert (text != null) : "text must not be null";
        this.text = text;
        this.unsigned = unsigned;
        this.withComma = withComma;
    }

    public void verifyText(VerifyEvent e) {
        if (!this.isAlwaysAllowedChar(e.character)) {
            String content = this.text.getText();
            String firstPart = "";
            String lastPart = "";
            if (e.start > 0) {
                firstPart = content.substring(0, e.start);
            }
            if (e.end < content.length()) {
                lastPart = content.substring(e.end);
            }
            if ((content = String.valueOf(firstPart) + e.text + lastPart).length() > 0) {
                try {
                    this.parseNumber(content);
                    e.doit = true;
                }
                catch (NumberFormatException nfe) {
                    e.doit = false;
                }
                if (this.canInsertDigit() && this.isDigit(e.text)) {
                    try {
                        this.parseNumber(content);
                        e.doit = true;
                    }
                    catch (NumberFormatException nfe) {
                        e.doit = false;
                    }
                }
                e.doit = e.doit || this.canInsertMinus() && this.isMinus(e.text) || this.canInsertComma() && this.isComma(e.text) || this.canInsert(e.text, this.text.getCaretPosition(), this.text.getText(), content);
            }
        }
    }

    protected abstract void parseNumber(String var1) throws NumberFormatException;

    protected abstract boolean canInsert(String var1, int var2, String var3, String var4);

    private boolean isAlwaysAllowedChar(char character) {
        return character == '\b' || character == '\u007f';
    }

    protected boolean isDigit(String s) {
        int i = 0;
        while (i < s.length()) {
            boolean is;
            char ch = s.charAt(i);
            boolean bl = is = "0123456789".indexOf(ch) >= 0;
            if (!is) {
                if (i > 0 || s.length() == 1) {
                    return false;
                }
                if (ch != '-' || this.unsigned || ch == '.' && this.withComma) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private boolean canInsertDigit() {
        boolean can = this.text.getCaretPosition() > 0 || this.text.getText().indexOf(45) < 0;
        return can;
    }

    private boolean isMinus(String s) {
        if (s.length() == 1) {
            return s.charAt(0) == '-';
        }
        return false;
    }

    private boolean canInsertMinus() {
        boolean can = !this.unsigned && this.text.getCaretPosition() == 0 && this.text.getText().indexOf(45) < 0;
        return can;
    }

    private boolean canInsertComma() {
        boolean can = this.withComma && this.text.getCaretPosition() > 0 && this.text.getText().indexOf(46) < 0;
        return can;
    }

    private boolean isComma(String s) {
        if (s.length() == 1) {
            return s.charAt(0) == '.';
        }
        return false;
    }
}

