/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.widgetAdapter;

import com.arcway.lib.java.locale.LocalisationUtils;
import com.arcway.lib.ui.editor.playground.IEditorPlayground;
import com.arcway.lib.ui.editor.playground.PropertyPlayground;
import com.arcway.lib.ui.editor.widgetAdapter.AbstractPropertyWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapterManager;
import java.text.ParseException;
import java.util.Collection;
import java.util.Locale;

public abstract class AbstractFreeStringWidgetNumberPropertyWidgetAdapter
extends AbstractPropertyWidgetAdapter {
    private final PropertyPlayground<?, ?, ?, ?> playground;

    public AbstractFreeStringWidgetNumberPropertyWidgetAdapter(IWidgetAdapterManager widgetAdapterManager, Collection<IEditorPlayground> playgrounds) {
        super(widgetAdapterManager, playgrounds);
        this.playground = (PropertyPlayground)playgrounds.iterator().next();
    }

    @Override
    public final String getValue(IWidgetAdapter.WidgetUpdateMode mode) {
        Double playgroundValue = (Double)this.playground.getValue();
        if (mode == IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE) {
            return AbstractFreeStringWidgetNumberPropertyWidgetAdapter.convertPlaygroundValue(playgroundValue, this.getContentLocale());
        }
        if (mode == IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE_IF_PLAYGROUND_VALUE_DIFFERS) {
            String currentValue = (String)this.getWidget().getCurrentValue();
            try {
                Double newValue = LocalisationUtils.parseDoubleLocalized((String)currentValue, (Locale)this.getContentLocale());
                if (newValue == null && playgroundValue == null || newValue != null && newValue.equals(playgroundValue)) {
                    return currentValue;
                }
                return AbstractFreeStringWidgetNumberPropertyWidgetAdapter.convertPlaygroundValue(playgroundValue, this.getContentLocale());
            }
            catch (ParseException pE) {
                return AbstractFreeStringWidgetNumberPropertyWidgetAdapter.convertPlaygroundValue(playgroundValue, this.getContentLocale());
            }
        }
        assert (false);
        return "";
    }

    private static String convertPlaygroundValue(Double playgroundValue, Locale locale) {
        return LocalisationUtils.roundLocalized((Double)playgroundValue, (int)Integer.MAX_VALUE, (boolean)true, (boolean)false, (Locale)locale);
    }
}

