/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.playground;

import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISortedSet_;
import com.arcway.lib.listener.ListenerKey;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.ui.dialog.imports.ICompareModeChangeListener;
import com.arcway.lib.ui.dialog.imports.ICurrentModelAndModificationsAccessAgent_Import;
import com.arcway.lib.ui.dialog.imports.IImportModeChangeListener;
import com.arcway.lib.ui.dialog.imports.IImportModelAccess;
import com.arcway.lib.ui.editor.IPlaygroundManager;
import com.arcway.lib.ui.editor.datatype.IEditorMessage;
import com.arcway.lib.ui.editor.datatype.IEditorMessageSet;
import com.arcway.lib.ui.editor.datatype.IEditorModelAccess;
import com.arcway.lib.ui.editor.exception.EEXDataValidation;
import com.arcway.lib.ui.editor.exception.EEXLockDenied;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXObjectReferenceCannotBeResolved;
import com.arcway.lib.ui.editor.exception.EEXPermissionDenied;
import com.arcway.lib.ui.editor.exception.EEXRepositoryAccessException;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;
import com.arcway.lib.ui.editor.playground.AbstractPlayground;
import com.arcway.lib.ui.editor.playground.PlaygroundError;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;

public abstract class AbstractPropertyOrCategoryPlayground<WIDGET_ADAPTER_TYPE extends IDataWidgetAdapter, PROPERTY_OR_CATEGORY_VALUE, PROPERTY_OR_CATEGORY_VALUERANGEKEY, PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE extends PROPERTY_OR_CATEGORY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE extends PROPERTY_OR_CATEGORY_REFERENCE, OBJECT_REFERENCE>
extends AbstractPlayground<WIDGET_ADAPTER_TYPE, PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE> {
    private boolean isModificationPermitted = true;
    private boolean isModificationLocked;
    private IEditorMessage error = null;
    private IList_<PROPERTY_OR_CATEGORY_VALUERANGEKEY> valueRangeKeys;
    private ListenerKey compareModeChangeListenerKey = null;
    private ListenerKey importModeChangeListenerKey = null;

    public AbstractPropertyOrCategoryPlayground(IEditorModelAccess<PROPERTY_OR_CATEGORY_REFERENCE, PROPERTY_REFERENCE, OBJECT_TYPE_CATEGORY_REFERENCE, OBJECT_REFERENCE> modelAccessAgent, IPlaygroundManager playgroundManager) {
        super(modelAccessAgent, playgroundManager);
    }

    protected final void init() {
        this.fillPlayground();
        this.registerCompareModeChangeListenerIfNeeded();
        this.updateImportModeChangeListenerRegistration();
    }

    protected abstract PROPERTY_OR_CATEGORY_REFERENCE getPropertyOrCategoryReference();

    protected abstract OBJECT_REFERENCE getObjectReference();

    protected abstract IHasher_<? super PROPERTY_OR_CATEGORY_VALUE> getPropertyOrCategoryValueHasher();

    protected abstract PROPERTY_OR_CATEGORY_VALUE getDefaultValueForPropertyOrCategory() throws EEXLockDenied, EEXSnapshotClosed, EEXNotReproducibleSnapshot;

    protected abstract IList_<PROPERTY_OR_CATEGORY_VALUERANGEKEY> getValueRangeKeysForPropertyOrCatgeory() throws EEXObjectReferenceCannotBeResolved, EEXSnapshotClosed, EEXNotReproducibleSnapshot;

    protected abstract PROPERTY_OR_CATEGORY_VALUE getCurrentValueForPropertyOrCategory() throws EEXObjectReferenceCannotBeResolved, EEXNotReproducibleSnapshot, EEXSnapshotClosed;

    protected abstract boolean isPropertyOrCategoryModified();

    protected abstract PROPERTY_OR_CATEGORY_VALUE getModifiedPropertyOrCategoryValue();

    protected abstract PROPERTY_OR_CATEGORY_VALUE getToBePropertyOrCategoryValue() throws EEXRepositoryAccessException, EEXNotReproducibleSnapshot, EEXSnapshotClosed;

    protected abstract void setNewPropertyOrCategoryValue(PROPERTY_OR_CATEGORY_VALUE var1) throws EEXRepositoryAccessException, EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXDataValidation, JvmExternalResourceInteractionException;

    protected abstract void resetPropertyOrCategoryValue(PROPERTY_OR_CATEGORY_VALUE var1) throws EEXRepositoryAccessException, EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXDataValidation, JvmExternalResourceInteractionException;

    protected abstract void refreshPropertyOrCategoryValue() throws EEXRepositoryAccessException, EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXDataValidation, JvmExternalResourceInteractionException;

    protected abstract void checkPermissionForModifyData() throws EEXPermissionDenied, EEXSnapshotClosed, EEXNotReproducibleSnapshot;

    protected abstract void acquireModifyLockForPropertyOrCategory() throws EEXLockDenied, EEXSnapshotClosed, EEXNotReproducibleSnapshot;

    protected abstract void releaseModifyLockForPropertyOrCategory();

    protected abstract IEditorMessageSet getPropertyOrCategoryMessages() throws EEXNotReproducibleSnapshot;

    protected abstract boolean mayInfluencePlaygroundVisibility();

    private void registerCompareModeChangeListenerIfNeeded() {
        IImportModelAccess importModelAccess;
        IEditorModelAccess modelAccessAgent = this.getModelAccessAgent();
        if (modelAccessAgent instanceof IImportModelAccess && (importModelAccess = (IImportModelAccess)modelAccessAgent).getCurrentModelAndModificationsAccessAgent().isCompareModeDepending(this.getPropertyOrCategoryReference())) {
            this.compareModeChangeListenerKey = new ListenerKey();
            importModelAccess.addCompareModeChangeListener(this.compareModeChangeListenerKey, new ICompareModeChangeListener(){

                public void dispose() {
                    AbstractPropertyOrCategoryPlayground.this.deregisterCompareModeChangeListener();
                }

                @Override
                public void compareModeChanged() {
                    AbstractPropertyOrCategoryPlayground.this.refreshPlayground();
                    AbstractPropertyOrCategoryPlayground.this.updateAdapters(null);
                }
            });
        }
    }

    private void deregisterCompareModeChangeListener() {
        if (this.compareModeChangeListenerKey != null) {
            IImportModelAccess importModelAccess = (IImportModelAccess)this.getModelAccessAgent();
            importModelAccess.removeCompareModeChangeListener(this.compareModeChangeListenerKey);
            this.compareModeChangeListenerKey = null;
        }
    }

    private void updateImportModeChangeListenerRegistration() {
        IEditorModelAccess modelAccessAgent = this.getModelAccessAgent();
        if (modelAccessAgent instanceof IImportModelAccess) {
            IImportModelAccess importModelAccess = (IImportModelAccess)modelAccessAgent;
            if (importModelAccess.getCurrentModelAndModificationsAccessAgent().isImportModeDepending(this.getPropertyOrCategoryReference())) {
                if (this.importModeChangeListenerKey == null) {
                    this.importModeChangeListenerKey = new ListenerKey();
                    importModelAccess.addImportModeChangeListener(this.importModeChangeListenerKey, this.getObjectReference(), new IImportModeChangeListener(){

                        public void dispose() {
                            AbstractPropertyOrCategoryPlayground.this.deregisterImportModeChangeListener();
                        }

                        @Override
                        public void importModeChanged() {
                            AbstractPropertyOrCategoryPlayground.this.resetSnapshotOrImportModeOrCompareModeDependentState();
                            AbstractPropertyOrCategoryPlayground.this.updateAdapters(null);
                        }
                    });
                }
            } else {
                this.deregisterImportModeChangeListener();
            }
        }
    }

    private void deregisterImportModeChangeListener() {
        if (this.importModeChangeListenerKey != null) {
            IImportModelAccess importModelAccess = (IImportModelAccess)this.getModelAccessAgent();
            importModelAccess.removeImportModeChangeListener(this.importModeChangeListenerKey, this.getObjectReference());
            this.importModeChangeListenerKey = null;
        }
    }

    private void resetSnapshotOrImportModeOrCompareModeDependentState() {
        this.valueRangeKeys = null;
    }

    @Override
    public void dispose() {
        this.deregisterImportModeChangeListener();
        this.deregisterCompareModeChangeListener();
    }

    @Override
    public void updateAdapters(IWidgetAdapter initiatingWidgetAdapter) {
        this.sendUpdateSignalToAdapters(initiatingWidgetAdapter);
    }

    private PROPERTY_OR_CATEGORY_VALUE getCurrentValue() {
        PROPERTY_OR_CATEGORY_VALUE currentValue = null;
        try {
            currentValue = this.getCurrentValueForPropertyOrCategory();
        }
        catch (EEXObjectReferenceCannotBeResolved eEXObjectReferenceCannotBeResolved) {
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(new PlaygroundError(exNRS));
        }
        catch (EEXSnapshotClosed e) {
            this.setError(new PlaygroundError(e));
        }
        return currentValue;
    }

    private void fillPlayground() {
        if (!this.isPropertyOrCategoryModified()) {
            try {
                this.getCurrentValueForPropertyOrCategory();
            }
            catch (EEXObjectReferenceCannotBeResolved exVCNBR) {
                try {
                    PROPERTY_OR_CATEGORY_VALUE defaultValue = this.getDefaultValueForPropertyOrCategory();
                    this.setNewPropertyOrCategoryValue(defaultValue);
                }
                catch (EEXNotReproducibleSnapshot exNRS) {
                    this.setError(new PlaygroundError(exNRS));
                }
                catch (EEXDataValidation e) {
                    this.setError(new PlaygroundError(e, this.getPlaygroundManager()));
                }
                catch (JvmExternalResourceInteractionException e) {
                    this.setError(new PlaygroundError(e));
                }
                catch (EEXSnapshotClosed e) {
                    this.setError(new PlaygroundError(e));
                }
                catch (EEXRepositoryAccessException e) {
                    this.setError(new PlaygroundError(e, this.getPlaygroundManager()));
                }
            }
            catch (EEXNotReproducibleSnapshot exNRS) {
                this.setError(new PlaygroundError(exNRS));
            }
            catch (EEXSnapshotClosed e) {
                this.setError(new PlaygroundError(e));
            }
        }
        this.checkPermission();
    }

    @Override
    public boolean valueSet() {
        return this.isPropertyOrCategoryModified();
    }

    public void setValue(PROPERTY_OR_CATEGORY_VALUE newValue, IWidgetAdapter initiatingWidgetAdapter) {
        this.removeError();
        try {
            IHasher_<PROPERTY_OR_CATEGORY_VALUE> propertyValueHasher = this.getPropertyOrCategoryValueHasher();
            PROPERTY_OR_CATEGORY_VALUE currentValue = this.getCurrentValue();
            if (!propertyValueHasher.isEqual(newValue, currentValue)) {
                this.setNewPropertyOrCategoryValue(newValue);
            } else {
                this.resetPropertyOrCategoryValue(newValue);
            }
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(new PlaygroundError(exNRS));
        }
        catch (EEXDataValidation e) {
            this.setError(new PlaygroundError(e, this.getPlaygroundManager()));
        }
        catch (JvmExternalResourceInteractionException e) {
            this.setError(new PlaygroundError(e));
        }
        catch (EEXSnapshotClosed e) {
            this.setError(new PlaygroundError(e));
        }
        catch (EEXRepositoryAccessException e) {
            this.setError(new PlaygroundError(e, this.getPlaygroundManager()));
        }
        this.updateAdapters(initiatingWidgetAdapter);
        this.getPlaygroundManager().playgroundDataChanged(this.mayInfluencePlaygroundVisibility());
    }

    public Object getValue() {
        try {
            return this.getToBePropertyOrCategoryValue();
        }
        catch (EEXObjectReferenceCannotBeResolved eORNR) {
            return null;
        }
        catch (EEXSnapshotClosed eSC) {
            this.setError(new PlaygroundError(eSC));
            return null;
        }
        catch (EEXNotReproducibleSnapshot eNRS) {
            this.setError(new PlaygroundError(eNRS));
            return null;
        }
        catch (EEXRepositoryAccessException eSC) {
            this.setError(new PlaygroundError(eSC, this.getPlaygroundManager()));
            return null;
        }
    }

    public IList_<PROPERTY_OR_CATEGORY_VALUERANGEKEY> getValueRange() {
        try {
            if (this.valueRangeKeys == null) {
                this.valueRangeKeys = this.getValueRangeKeysForPropertyOrCatgeory();
            }
            return this.valueRangeKeys;
        }
        catch (EEXNotReproducibleSnapshot eNRS) {
            this.setError(new PlaygroundError(eNRS));
        }
        catch (EEXSnapshotClosed eSC) {
            this.setError(new PlaygroundError(eSC));
        }
        catch (EEXObjectReferenceCannotBeResolved eORCBR) {
            this.setError(new PlaygroundError(eORCBR, this.getPlaygroundManager()));
        }
        return new ArrayList_(0);
    }

    @Override
    public void refreshPlayground() {
        this.resetSnapshotOrImportModeOrCompareModeDependentState();
        this.removeError();
        try {
            this.refreshPropertyOrCategoryValue();
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(new PlaygroundError(exNRS));
        }
        catch (EEXRepositoryAccessException e) {
            this.setError(new PlaygroundError(e, this.getPlaygroundManager()));
        }
        catch (EEXSnapshotClosed e) {
            this.setError(new PlaygroundError(e));
        }
        catch (JvmExternalResourceInteractionException e) {
            this.setError(new PlaygroundError(e));
        }
        catch (EEXDataValidation e) {
            this.setError(new PlaygroundError(e, this.getPlaygroundManager()));
        }
    }

    public void checkPermission() {
        try {
            this.checkPermissionForModifyData();
            this.setModificationPermitted(true);
        }
        catch (EEXNotReproducibleSnapshot exNRS) {
            this.setError(new PlaygroundError(exNRS));
        }
        catch (EEXPermissionDenied e) {
            if (this.getCurrentModelAndModificationsAccessAgent() instanceof ICurrentModelAndModificationsAccessAgent_Import) {
                this.setModificationPermitted(true);
            }
            if (this.valueSet()) {
                try {
                    this.resetPropertyOrCategoryValue(this.getCurrentValue());
                }
                catch (EEXNotReproducibleSnapshot e1) {
                    this.setError(new PlaygroundError(e1));
                }
                catch (EEXSnapshotClosed e1) {
                    this.setError(new PlaygroundError(e1));
                }
                catch (EEXRepositoryAccessException e1) {
                    this.setError(new PlaygroundError(e, this.getPlaygroundManager()));
                }
                catch (EEXDataValidation e1) {
                    this.setError(new PlaygroundError(e, this.getPlaygroundManager()));
                }
                catch (JvmExternalResourceInteractionException e1) {
                    this.setError(new PlaygroundError(e, this.getPlaygroundManager()));
                }
            }
            this.setModificationPermitted(false);
            this.setPermissionMessageText(this.getMessageForException(e));
        }
        catch (EEXSnapshotClosed e) {
            this.setError(new PlaygroundError(e));
        }
    }

    public boolean isModificationPermitted() {
        return this.isModificationPermitted;
    }

    public void setModificationPermitted(boolean isModificationPermitted) {
        this.isModificationPermitted = isModificationPermitted;
    }

    @Override
    public void checkLock() throws EEXLockDenied {
        this.setLockMessageText(null);
        try {
            this.acquireModifyLockForPropertyOrCategory();
            this.isModificationLocked = true;
        }
        catch (EEXNotReproducibleSnapshot e) {
            this.setError(new PlaygroundError(e));
        }
        catch (EEXLockDenied e) {
            this.isModificationLocked = false;
            this.setLockMessageText(this.getMessageForException(e));
            throw e;
        }
        catch (EEXSnapshotClosed e) {
            this.setError(new PlaygroundError(e));
        }
    }

    @Override
    public boolean isModificationLocked() {
        return this.isModificationLocked;
    }

    @Override
    public void releaseLock() {
        this.releaseModifyLockForPropertyOrCategory();
        this.isModificationLocked = false;
    }

    @Override
    public boolean hasError() {
        return this.error != null;
    }

    @Override
    public void setError(PlaygroundError playgroundError) {
        if (playgroundError != null) {
            if (this.error == null || this.error.getMessageLevel().compareTo(playgroundError.getMessageLevel()) > 0) {
                this.error = playgroundError;
                this.getPlaygroundManager().errorInPlayground(this, playgroundError);
            }
        } else if (this.error != null && !this.error.getMessageLevel().isHigh()) {
            this.error = null;
        }
    }

    @Override
    public void updateWidgetMessages() throws EEXNotReproducibleSnapshot {
        IEditorMessageSet editorMessageSet = this.getPropertyOrCategoryMessages();
        ISortedSet_<? extends IEditorMessage> messages = editorMessageSet.getMessages();
        IEditorMessage editorMessage = messages.isEmpty() ? null : (IEditorMessage)messages.iterator().next();
        this.error = editorMessage;
        this.getPlaygroundManager().errorInPlayground(this, editorMessage);
        for (IWidgetAdapter element : this.getWidgetAdapters()) {
            element.updateWidgetMessageDisplay();
        }
    }

    @Override
    public IEditorMessage getError() {
        return this.error;
    }

    @Override
    public void removeError() {
        this.getPlaygroundManager().removeError(this);
        this.error = null;
    }
}

