/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.linestyles;

import com.arcway.lib.geometry.Arc;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.graphics.linestyles.ILineDrawProcessor;
import com.arcway.lib.graphics.linestyles.ILineStyleFigure;
import com.arcway.lib.graphics.linestyles.LineStyleCommand;

public class LineStyleFigureArc
extends Arc
implements ILineStyleFigure {
    private final double angleComingFrom;
    private final double aComingFrom;
    private final double angleGoingTo;
    private final double aGoingTo;
    private final boolean direction;
    private double aGo;

    public LineStyleFigureArc(double x, double y, double rx, double ry, double angleComingFrom, double a1, double a2, double arcLength, double angleGoingTo) {
        super(x, y, rx, ry, a1, a1);
        this.angleComingFrom = angleComingFrom;
        this.aComingFrom = a1;
        this.angleGoingTo = angleGoingTo;
        this.aGoingTo = a2;
        this.direction = Arc.getDirection(this.aComingFrom, this.aGoingTo);
        this.aGo = arcLength > 1.0E-10 ? (a2 - a1) / arcLength : 0.0;
    }

    @Override
    public void start_forward(double arcLength) {
        this.angleStart += this.aGo * arcLength;
    }

    @Override
    public void backward(double arcLength) {
        this.angleStart -= this.aGo * arcLength;
        this.angleEnd -= this.aGo * arcLength;
    }

    @Override
    public void end_forward(double arcLength) {
        this.angleEnd += this.aGo * arcLength;
    }

    private boolean isStart() {
        return Geo.equals(this.angleStart, this.aComingFrom);
    }

    private double getAngleOfTangent(double angleRadial) {
        double angleOfTangent = this.direction ? Geo.getNormalizedAngle(angleRadial - 90.0) : Geo.getNormalizedAngle(angleRadial + 90.0);
        return angleOfTangent;
    }

    private boolean isEnd() {
        return Geo.equals(this.angleEnd, this.aGoingTo);
    }

    @Override
    public void draw(LineStyleCommand command, ILineDrawProcessor lineDrawProcessor) {
        command.drawArc(lineDrawProcessor, this.isStart() ? this.angleComingFrom : this.getAngleOfTangent(this.angleStart), this, this.isEnd() ? this.angleGoingTo : this.getAngleOfTangent(this.angleEnd));
    }

    @Override
    public void next() {
        this.angleStart = this.angleEnd;
    }
}

