/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.linemarkers;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linemarkers.LineMarker;
import com.arcway.lib.graphics.linestyles.LineStyle;

public abstract class LineMarkerPolygon
extends LineMarker {
    protected Corner[] corners;

    @Override
    public abstract double arcLength(double var1);

    @Override
    public void draw(Device device, Point p, Color lineColor, double lineThickness, FillColor fillColor, double angle, double coronaWidth) {
        if (this.drawWithOutline()) {
            device.polygon(this.getPolygon(p, lineThickness, angle, coronaWidth), fillColor, FillStyle.SOLID, lineThickness, lineColor, LineStyle.SOLID);
        } else {
            device.polygon(this.getPolygon(p, lineThickness, angle, coronaWidth), new FillColor(lineColor), FillStyle.SOLID);
        }
    }

    private Polygon getPolygon(Point p, double lineThickness, double angle, double coronaWidth) {
        GeoVector hotspot = new GeoVector(p);
        GeoVector[] vectors = new GeoVector[this.corners.length];
        int i = 0;
        while (i < vectors.length) {
            GeoVector currentGeoVector = new GeoVector(this.corners[i]);
            currentGeoVector = currentGeoVector.turn(angle);
            vectors[i] = currentGeoVector = currentGeoVector.scale(lineThickness);
            ++i;
        }
        GeoVector center = this.getCenter(vectors);
        double explodeFactor = this.getExplodeFactor(vectors, center, coronaWidth);
        if (center != null) {
            hotspot = GeoVector.add(hotspot, center.scale(0.5 - explodeFactor / 2.0));
        }
        int i2 = 0;
        while (i2 < vectors.length) {
            GeoVector currentGeoVector = vectors[i2];
            currentGeoVector = currentGeoVector.scale(explodeFactor);
            vectors[i2] = currentGeoVector = GeoVector.add(hotspot, currentGeoVector);
            ++i2;
        }
        Corners cornersToDraw = new Corners();
        int i3 = 0;
        while (i3 < vectors.length) {
            Corner currentCorner = this.corners[i3];
            GeoVector currentGeoVector = vectors[i3];
            if (currentCorner.radiusInfinity) {
                cornersToDraw.add(new Corner(currentGeoVector.x, currentGeoVector.y));
            } else {
                cornersToDraw.add(new Corner(currentGeoVector.x, currentGeoVector.y, currentCorner.radius * lineThickness));
            }
            ++i3;
        }
        return new Polygon(cornersToDraw, true);
    }

    private double getExplodeFactor(GeoVector[] vectorsToExplode, GeoVector center, double distance) {
        double factor = 1.0;
        if (distance > 1.0E-10 && center != null) {
            GeoVector inverseCenter = center.turn180();
            double avgDistance = 0.0;
            GeoVector[] geoVectorArray = vectorsToExplode;
            int n = vectorsToExplode.length;
            int n2 = 0;
            while (n2 < n) {
                GeoVector currentVector = geoVectorArray[n2];
                avgDistance += GeoVector.add(currentVector, inverseCenter).abs();
                ++n2;
            }
            if ((avgDistance /= (double)vectorsToExplode.length) > 1.0E-10) {
                factor = (avgDistance + distance) / avgDistance;
            }
        }
        return factor;
    }

    private GeoVector getCenter(GeoVector[] vectorsToExplode) {
        GeoVector center;
        if (vectorsToExplode.length == 0) {
            center = null;
        } else if (vectorsToExplode.length == 1) {
            center = vectorsToExplode[0];
        } else {
            center = vectorsToExplode[0];
            int i = 1;
            while (i < vectorsToExplode.length) {
                center = GeoVector.add(center, vectorsToExplode[i]);
                ++i;
            }
            center = center.scale(1.0 / (double)vectorsToExplode.length);
        }
        return center;
    }

    @Override
    public boolean usesFillColor() {
        return this.drawWithOutline();
    }

    public abstract boolean drawWithOutline();
}

