/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.linemarkers;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.linemarkers.LineMarker;
import com.arcway.lib.graphics.linestyles.LineStyle;

public class LineMarkerCross
extends LineMarker {
    public LineMarkerCross() {
        this.setName("Cross");
    }

    @Override
    public double arcLength(double lineThickness) {
        return 0.0;
    }

    @Override
    public void draw(Device device, Point p, Color lineColor, double lineThickness, FillColor fillColor, double angle, double coronaWidth) {
        double size = lineThickness * 3.0;
        Corners line1 = new Corners();
        line1.add(new Corner(p.x - size, p.y - size, 0.0));
        line1.add(new Corner(p.x + size, p.y + size, 0.0));
        Corners line2 = new Corners();
        line2.add(new Corner(p.x + size, p.y - size, 0.0));
        line2.add(new Corner(p.x - size, p.y + size, 0.0));
        device.polyline(line1, lineThickness + 2.0 * coronaWidth, lineColor, LineStyle.SOLID);
        device.polyline(line2, lineThickness + 2.0 * coronaWidth, lineColor, LineStyle.SOLID);
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public boolean usesFillColor() {
        return false;
    }
}

