/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.StraightLine;
import com.arcway.lib.geometry.Transformation;

public class TurnedRectangle {
    private final Point center;
    private final Dimension dimension;
    private final Direction direction;
    private Points points;

    public TurnedRectangle(Point center, Dimension dimension, Direction direction) {
        this.center = center;
        this.dimension = dimension;
        this.direction = direction;
    }

    public TurnedRectangle(Rectangle rectangle, Direction direction) {
        this(rectangle.center(), rectangle.getDimension(), direction);
    }

    public TurnedRectangle(Rectangle rectangle) {
        this(rectangle.center(), rectangle.getDimension(), Direction.ANGLE_0);
    }

    public TurnedRectangle transform(Transformation transformation) {
        assert (transformation != null);
        GeoVector wHalf = this.getW().scale(0.5);
        GeoVector hHalf = this.getH().scale(0.5);
        Point centerTransformed = this.center.transform(transformation);
        GeoVector wHalfTransformed = wHalf.transform(this.center, transformation);
        GeoVector hHalfTransformed = hHalf.transform(this.center, transformation);
        double wTransformed = wHalfTransformed.abs() * 2.0;
        double hTransformed = hHalfTransformed.abs() * 2.0;
        Dimension dimensionTransformed = new Dimension(wTransformed, hTransformed);
        Direction directionTransformed = Geo.isZero(wTransformed) && Geo.isZero(hTransformed) ? this.direction : (wTransformed > hTransformed ? wHalfTransformed.getDirection() : hHalfTransformed.turn90().getDirection());
        return new TurnedRectangle(centerTransformed, dimensionTransformed, directionTransformed);
    }

    public Point getCenter() {
        return this.center;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public GeoVector getW() {
        return new GeoVector(this.dimension.width, this.direction);
    }

    public GeoVector getH() {
        return new GeoVector(this.dimension.height, this.direction.turn(270.0));
    }

    public Point getUpperLeft() {
        return this.center.movePoint(GeoVector.add(this.getW().scale(-0.5), this.getH().scale(-0.5)));
    }

    public Point getUpperRight() {
        return this.center.movePoint(GeoVector.add(this.getW().scale(0.5), this.getH().scale(-0.5)));
    }

    public Point getLowerRight() {
        return this.center.movePoint(GeoVector.add(this.getW().scale(0.5), this.getH().scale(0.5)));
    }

    public Point getLowerLeft() {
        return this.center.movePoint(GeoVector.add(this.getW().scale(-0.5), this.getH().scale(0.5)));
    }

    public Line getUpperBorder() {
        return new Line(this.getUpperLeft(), this.getUpperRight());
    }

    public Line getRightBorder() {
        return new Line(this.getUpperRight(), this.getLowerRight());
    }

    public Line getLowerBorder() {
        return new Line(this.getLowerRight(), this.getLowerLeft());
    }

    public Line getLeftBorder() {
        return new Line(this.getLowerLeft(), this.getUpperLeft());
    }

    public StraightLine getUpperStraightLine() {
        return new StraightLine(this.getUpperLeft(), this.direction);
    }

    public StraightLine getRightStraightLine() {
        return new StraightLine(this.getLowerRight(), this.direction.turn(90.0));
    }

    public StraightLine getLowerStraightLine() {
        return new StraightLine(this.getLowerRight(), this.direction);
    }

    public StraightLine getLeftStraightLine() {
        return new StraightLine(this.getUpperLeft(), this.direction.turn(90.0));
    }

    public double getArea() {
        return this.dimension.getArea();
    }

    public synchronized Points toPoints() {
        if (this.points == null) {
            this.points = new Points(4);
            this.points.add(this.getUpperLeft());
            this.points.add(this.getUpperRight());
            this.points.add(this.getLowerRight());
            this.points.add(this.getLowerLeft());
        }
        return this.points;
    }

    public Rectangle getOuterBounds() {
        return this.toPoints().getBounds();
    }

    public TurnedRectangle turnAndShrinkToBiggest(Direction directionOffset) {
        double hi;
        double wi;
        double hAbs;
        double wAbs;
        double alpha = directionOffset.getAngle();
        double alpha90 = Geo.getNormalizedAngle(alpha % 90.0);
        boolean angleIsFlipped = !Geo.equalsNormalizedStraightLineAngles(Geo.getNormalizedStraightLineAngle(alpha), alpha90);
        double alpha90Rad = Math.toRadians(alpha90);
        double sinAlpha = Math.sin(alpha90Rad);
        double cosAlpha = Math.cos(alpha90Rad);
        GeoVector w = this.getW();
        GeoVector h = this.getH();
        if (!angleIsFlipped) {
            wAbs = w.abs();
            hAbs = h.abs();
        } else {
            wAbs = h.abs();
            hAbs = w.abs();
        }
        if (Geo.equalsNormalizedStraightLineAngles(0.0, alpha90)) {
            wi = wAbs;
            hi = hAbs;
        } else if (Geo.equalsNormalizedStraightLineAngles(90.0, alpha90)) {
            wi = hAbs;
            hi = wAbs;
        } else if (Geo.isZero(wAbs) || Geo.isZero(hAbs)) {
            wi = 0.0;
            hi = 0.0;
        } else {
            try {
                double yj;
                double xj;
                double areaUpperRightAndLowerLeftTriangles;
                double areaUpperLeftAndLowerRightTriangles;
                double areaOfThis;
                double areaOfInner;
                double yi;
                double xi;
                if (!Geo.equals(alpha90, 45.0)) {
                    if (alpha90 < 45.0) {
                        double tanAlpha = Math.tan(alpha90Rad);
                        double tanSqrAlpha = tanAlpha * tanAlpha;
                        xi = (wAbs - hAbs * tanAlpha) / (1.0 - tanSqrAlpha);
                        yi = (wAbs * tanAlpha - hAbs * tanSqrAlpha) / (1.0 - tanSqrAlpha);
                    } else {
                        double cotAlpha = cosAlpha / sinAlpha;
                        double cotSqrAlpha = cotAlpha * cotAlpha;
                        xi = (hAbs * cotAlpha - wAbs * cotSqrAlpha) / (1.0 - cotSqrAlpha);
                        yi = (hAbs - wAbs * cotAlpha) / (1.0 - cotSqrAlpha);
                    }
                    if (xi < 0.0 || xi > wAbs || yi < 0.0 || yi > hAbs) {
                        throw new EXCantSetAllPointsOnBorders();
                    }
                } else if (Geo.equals(wAbs, hAbs)) {
                    xi = 0.5 * wAbs;
                    yi = 0.5 * hAbs;
                } else {
                    throw new EXCantSetAllPointsOnBorders();
                }
                if ((areaOfInner = (areaOfThis = this.getArea()) - (areaUpperLeftAndLowerRightTriangles = xi * yi) - (areaUpperRightAndLowerLeftTriangles = (xj = wAbs - xi) * (yj = hAbs - yi))) + 1.0E-10 < areaOfThis / 2.0) {
                    throw new EXCantSetAllPointsOnBorders();
                }
                wi = xi > yi ? xi / cosAlpha : yi / sinAlpha;
                hi = xj > yj ? xj / sinAlpha : yj / cosAlpha;
            }
            catch (EXCantSetAllPointsOnBorders e) {
                double sinus2Alpha = Math.sin(2.0 * alpha90Rad);
                double hHalf = 0.5 * hAbs;
                double wiBoundedOnH = hHalf / sinAlpha;
                double hiBoundedOnH = hHalf / cosAlpha;
                double wBoundedOnH = hAbs / sinus2Alpha;
                double wHalf = 0.5 * wAbs;
                double wiBoundedOnW = wHalf / cosAlpha;
                double hiBoundedOnW = wHalf / sinAlpha;
                double hBoundedOnW = wAbs / sinus2Alpha;
                if (wBoundedOnH < wAbs + 1.0E-10) {
                    assert (hBoundedOnW > hAbs);
                    wi = wiBoundedOnH;
                    hi = hiBoundedOnH;
                }
                wi = wiBoundedOnW;
                hi = hiBoundedOnW;
            }
        }
        Dimension turnedDimension = new Dimension(wi, hi);
        Direction turnedDirection = this.direction.turn(alpha);
        return new TurnedRectangle(this.center, turnedDimension, turnedDirection);
    }

    public boolean isInside(Point point) {
        assert (point != null);
        return this.toPoints().isInside(point);
    }

    private static class EXCantSetAllPointsOnBorders
    extends Exception {
    }
}

