/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Arc;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.InterceptRayPolygonProcessor;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.polygon.Polygon;

public class Ray {
    private final Point entryPoint;
    private final Direction direction;
    private final GeoVector directionVector;

    public Ray(Point entryPoint, Point throughPoint) {
        this.entryPoint = Point.getAsPoint(entryPoint);
        this.directionVector = new GeoVector(entryPoint, throughPoint);
        this.direction = this.directionVector.getDirection();
    }

    public Ray(Point entryPoint, Direction direction) {
        this.entryPoint = Point.getAsPoint(entryPoint);
        this.directionVector = new GeoVector(1.0, direction);
        this.direction = this.directionVector.getDirection();
    }

    public Ray(Point entryPoint, GeoVector directionVector) {
        this.entryPoint = Point.getAsPoint(entryPoint);
        this.directionVector = directionVector;
        this.direction = directionVector.getDirection();
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Point getEntryPoint() {
        return this.entryPoint;
    }

    public Points getIntersectionPoints(Polygon polygon) {
        InterceptRayPolygonProcessor pProcessor = new InterceptRayPolygonProcessor(this);
        polygon.process(pProcessor);
        return pProcessor.getInterceptPoints();
    }

    public boolean isOnRay(Point point) {
        GeoVector entryPointToPoint = new GeoVector(this.getEntryPoint(), point);
        return this.getDirection().equalsDirection(entryPointToPoint.getDirection());
    }

    public boolean isInEqualDirection(Ray ray) {
        return this.getDirection().equalsDirection(ray.getDirection());
    }

    public boolean isParallel(Line line) {
        boolean isParallel;
        if (line.isZeroLengthLine()) {
            isParallel = false;
        } else {
            GeoVector lineVector = new GeoVector(line.start, line.end);
            isParallel = this.getDirection().isParallel(lineVector.getDirection());
        }
        return isParallel;
    }

    public boolean isParallel(Ray ray) {
        return this.direction.isParallel(ray.direction);
    }

    public Point getInterceptPoint(Line line) {
        Point intersectPoint = null;
        assert (line != null);
        if (line.isZeroLengthLine()) {
            if (this.isOnRay(line.start)) {
                return Point.getAsPoint(line.start);
            }
            return null;
        }
        if (this.isParallel(line)) {
            return null;
        }
        double x1 = this.entryPoint.x;
        double y1 = this.entryPoint.y;
        double x2 = this.entryPoint.x + this.directionVector.x;
        double y2 = this.entryPoint.y + this.directionVector.y;
        double x3 = line.start.x;
        double y3 = line.start.y;
        double x4 = line.end.x;
        double y4 = line.end.y;
        double s = (x3 - x1) * (y2 - y1) + (y1 - y3) * (x2 - x1);
        s /= (x3 - x4) * (y2 - y1) + (y4 - y3) * (x2 - x1);
        double t = (x1 - x3) * (y4 - y3) + (y3 - y1) * (x4 - x3);
        if ((t /= (x1 - x2) * (y4 - y3) + (y2 - y1) * (x4 - x3)) < -1.0E-10 || s < -1.0E-10 || s > 1.0000000001) {
            return null;
        }
        intersectPoint = new Point((1.0 - t) * x1 + t * x2, (1.0 - t) * y1 + t * y2);
        return intersectPoint;
    }

    public Point getInterceptPoint(Ray ray) {
        Point intersectPoint = null;
        assert (ray != null);
        if (this.isOnRay(ray.entryPoint)) {
            return Point.getAsPoint(ray.entryPoint);
        }
        if (ray.isOnRay(this.entryPoint)) {
            return Point.getAsPoint(this.entryPoint);
        }
        if (this.isParallel(ray)) {
            return null;
        }
        double x1 = this.entryPoint.x;
        double y1 = this.entryPoint.y;
        double x2 = this.entryPoint.x + this.directionVector.x;
        double y2 = this.entryPoint.y + this.directionVector.y;
        double x3 = ray.entryPoint.x;
        double y3 = ray.entryPoint.y;
        double x4 = ray.entryPoint.x + ray.directionVector.x;
        double y4 = ray.entryPoint.y + ray.directionVector.y;
        double s = (x3 - x1) * (y2 - y1) + (y1 - y3) * (x2 - x1);
        s /= (x3 - x4) * (y2 - y1) + (y4 - y3) * (x2 - x1);
        double t = (x1 - x3) * (y4 - y3) + (y3 - y1) * (x4 - x3);
        if ((t /= (x1 - x2) * (y4 - y3) + (y2 - y1) * (x4 - x3)) < -1.0E-10 || s < -1.0E-10) {
            return null;
        }
        intersectPoint = new Point((1.0 - t) * x1 + t * x2, (1.0 - t) * y1 + t * y2);
        return intersectPoint;
    }

    public Points getInterceptPoints(Arc arc) {
        Point p2;
        double sqrt;
        Points points = new Points();
        double radius = arc.rx;
        if (radius < arc.ry) {
            radius = arc.ry;
        }
        GeoVector centerVector = new GeoVector(arc.center);
        double directionVector_sqr = GeoVector.mulScalar(this.directionVector, this.directionVector);
        if (Geo.equals(directionVector_sqr, 0.0)) {
            return points;
        }
        GeoVector entryVector = new GeoVector(this.entryPoint);
        double p = 2.0 * GeoVector.mulScalar(entryVector, this.directionVector);
        p -= 2.0 * GeoVector.mulScalar(this.directionVector, centerVector);
        p /= directionVector_sqr;
        double q = GeoVector.mulScalar(entryVector, entryVector);
        q -= 2.0 * GeoVector.mulScalar(entryVector, centerVector);
        q += GeoVector.mulScalar(centerVector, centerVector);
        q -= radius * radius;
        double under_sqrt = p * p / 4.0 - (q /= directionVector_sqr);
        if (under_sqrt > 1.0E-10) {
            sqrt = Math.sqrt(under_sqrt);
        } else if (under_sqrt > -1.0E-10) {
            sqrt = 0.0;
        } else {
            return points;
        }
        double t1 = -p / 2.0 + sqrt;
        double t2 = -p / 2.0 - sqrt;
        Point p1 = this.getPoint(t1);
        if (this.isInAngleIntervallOfArc(arc, p1) && this.isOnRay(p1)) {
            points.add(p1);
        }
        if (!p1.equalsPoint(p2 = this.getPoint(t2)) && this.isInAngleIntervallOfArc(arc, p2) && this.isOnRay(p2)) {
            points.add(p2);
        }
        return points;
    }

    private Point getPoint(double lambda) {
        double xe = this.entryPoint.x;
        double ye = this.entryPoint.y;
        double xr = this.directionVector.x;
        double yr = this.directionVector.y;
        double x = xe + lambda * xr;
        double y = ye + lambda * yr;
        return new Point(x, y);
    }

    private boolean isInAngleIntervallOfArc(Arc arc, Point point) {
        GeoVector centreInterception = new GeoVector(arc.center, point);
        return centreInterception.getDirection().isInInvervall(arc.angleStart, arc.angleEnd);
    }

    public boolean equalsRay(Ray ray) {
        return this.getEntryPoint().equalsPoint(ray.getEntryPoint()) && this.isInEqualDirection(ray);
    }
}

