/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class Dimension {
    private static final ILogger logger = Logger.getLogger(Dimension.class);
    public double width;
    public double height;

    public Dimension(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public Dimension(Dimension dimension) {
        assert (dimension != null);
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public Dimension(GeoVector v) {
        assert (v != null);
        this.width = v.x;
        this.height = v.y;
    }

    public double getArea() {
        return this.width * this.height;
    }

    public Dimension transform(Transformation transformation) {
        assert (transformation != null);
        Point p = new Point(this.width, this.height);
        Point transformed = transformation.transform(p);
        return new Dimension(transformed.x, transformed.y);
    }

    public String toString() {
        return "Dimension(width=" + this.width + ", height=" + this.height + ")";
    }

    public boolean equalsDimension(Dimension a) {
        return Geo.equals(a.width, this.width) && Geo.equals(a.height, this.height);
    }

    @Deprecated
    public boolean equals(Object obj) {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Dimension) {
            Dimension a = (Dimension)obj;
            return this.equalsDimension(a);
        }
        return false;
    }

    @Deprecated
    public int hashCode() {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        return new Double(this.width + this.height).hashCode();
    }
}

