/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.viewers;

import com.arcway.lib.eclipse.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;

public class UsableCheckboxTreeViewer
extends CheckboxTreeViewer
implements ICheckStateListener,
ITreeViewerListener {
    private ITreeContentProvider contentProvider;
    private int partialSelectionPolicy = 1;
    private int childSelectionPolicy = 4;
    public static final int PARTIAL_SELECTION_POLICY__SHOW_PARENT_GREY = 1;
    public static final int PARTIAL_SELECTION_POLICY__SELECT_PARENT = 2;
    public static final int PARTIAL_SELECTION_POLICY__DO_NOT_AFFECT_PARENT = 3;
    public static final int CHILDREN_SELECTION_POLICY__SELECT_CHILDREN = 4;
    public static final int CHILDREN_SELECTION_POLICY__DONT_SELECT_CHILDREN = 5;
    private Set<Object> uncheckableElements = Collections.emptySet();

    public UsableCheckboxTreeViewer(Composite parent) {
        super(parent);
        this.addCheckStateListener(this);
        this.addTreeListener(this);
        this.setUseHashlookup(true);
    }

    public UsableCheckboxTreeViewer(Composite parent, int partialSelectionPolicy) {
        this(parent);
        this.partialSelectionPolicy = partialSelectionPolicy;
    }

    public UsableCheckboxTreeViewer(Composite parent, int partialSelectionPolicy, int childSelectionPolicy, int style) {
        this(parent, partialSelectionPolicy, style);
        this.childSelectionPolicy = childSelectionPolicy;
    }

    public UsableCheckboxTreeViewer(Composite parent, int partialSelectionPolicy, int style) {
        super(parent, style);
        this.addCheckStateListener(this);
        this.addTreeListener(this);
        this.setUseHashlookup(true);
        this.partialSelectionPolicy = partialSelectionPolicy;
    }

    public void setUncheckableElements(Set<? extends Object> uncheckableElements) {
        this.uncheckableElements = new HashSet<Object>(uncheckableElements);
        for (Object object : uncheckableElements) {
            this.setChecked(object, false);
            this.setGrayed(object, true);
        }
    }

    public void setContentProvider(IContentProvider provider) {
        super.setContentProvider(provider);
        this.contentProvider = (ITreeContentProvider)provider;
    }

    public void setCheckedElements(Object[] elements) {
        TreeItem[] rootElements;
        super.setCheckedElements(elements);
        TreeItem[] treeItemArray = rootElements = this.getTree().getItems();
        int n = rootElements.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem rootElement = treeItemArray[n2];
            Object rootData = rootElement.getData();
            this.checkChildrenAndSetParents1(rootData);
            ++n2;
        }
    }

    private void checkChildrenAndSetParents1(Object rootData) {
        assert (rootData != null) : "rootItem is null";
        Object[] children = this.getFilteredChildren(rootData);
        if (children.length > 0) {
            boolean allBoxesAreUnchecked = true;
            boolean allBoxesAreChecked = true;
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (!this.contentProvider.hasChildren(child)) {
                    boolean isChecked = this.getChecked(child);
                    allBoxesAreChecked &= isChecked;
                    allBoxesAreUnchecked &= !isChecked;
                } else {
                    this.checkChildrenAndSetParents1(child);
                    allBoxesAreChecked &= this.getChecked(child) && !this.getGrayed(child);
                    allBoxesAreUnchecked &= !this.getChecked(child) && !this.getGrayed(child);
                }
                ++n2;
            }
            if (!this.uncheckableElements.contains(rootData)) {
                if (this.getChecked(rootData) && (this.partialSelectionPolicy == 3 || this.partialSelectionPolicy == 2)) {
                    this.setChecked(rootData, true);
                    this.setGrayed(rootData, false);
                } else if (allBoxesAreChecked) {
                    this.setChecked(rootData, this.partialSelectionPolicy == 1 || this.partialSelectionPolicy == 2);
                    this.setGrayed(rootData, false);
                } else if (allBoxesAreUnchecked) {
                    this.setChecked(rootData, false);
                    this.setGrayed(rootData, false);
                } else {
                    this.setChecked(rootData, this.partialSelectionPolicy == 1 || this.partialSelectionPolicy == 2);
                    this.setGrayed(rootData, this.partialSelectionPolicy == 1);
                }
            }
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (event.getChecked()) {
            if (this.uncheckableElements.contains(event.getElement())) {
                this.setChecked(event.getElement(), false);
                this.setGrayed(event.getElement(), true);
            } else {
                this.checkElementWithChildren(event.getElement(), true, this.childSelectionPolicy == 4);
                if (this.partialSelectionPolicy != 3) {
                    this.updateParents(event.getElement());
                }
            }
        } else {
            this.checkElementWithChildren(event.getElement(), false, this.childSelectionPolicy == 4);
            if (this.partialSelectionPolicy != 3) {
                this.updateParents(event.getElement());
            }
        }
    }

    private void checkElementWithChildren(Object element, boolean state, boolean withChildren) {
        if (!this.uncheckableElements.contains(element)) {
            this.setChecked(element, state);
            this.setGrayed(element, false);
        }
        if (withChildren) {
            LinkedList allDescendantItems = new LinkedList();
            this.getAllDescendants(element, allDescendantItems);
            for (Object descendant : allDescendantItems) {
                if (this.uncheckableElements.contains(descendant)) continue;
                this.setChecked(descendant, state);
                this.setGrayed(descendant, false);
            }
        }
    }

    private void getAllDescendants(Object item, Collection descendantList) {
        descendantList.add(item);
        Object[] children = this.contentProvider.getChildren(item);
        if (children != null) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.getAllDescendants(element, descendantList);
                ++n2;
            }
        }
    }

    private Item getTreeItem(Object element, Item[] rootItems) {
        Item[] itemArray = rootItems;
        int n = rootItems.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            Object data = item.getData();
            if (data != null && data.equals(element)) {
                return item;
            }
            if ((item = this.getTreeItem(element, this.getItems(item))) != null) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private void updateParents(Object childElement) {
        Item parentItem;
        Item childItem = this.getTreeItem(childElement, (Item[])this.getTree().getItems());
        if (childItem != null && (parentItem = this.getParentItem(childItem, (Item[])this.getTree().getItems())) != null) {
            if (this.allChildItemsHaveSameState(parentItem, false)) {
                if (this.partialSelectionPolicy == 1) {
                    this.setCheckedOfAllParents(parentItem, false, false);
                }
            } else if (this.allChildItemsHaveSameState(parentItem, true)) {
                this.setCheckedOfAllParents(parentItem, true, false);
            } else {
                this.setCheckedOfAllParents(parentItem, true, true);
            }
        }
    }

    private void setCheckedOfAllParents(Item firstParent, boolean checked, boolean grayed) {
        Item parentItem;
        Object data = firstParent.getData();
        if (data != null && !this.uncheckableElements.contains(data)) {
            this.setGrayed(data, grayed && this.partialSelectionPolicy == 1);
            this.setChecked(data, checked);
        }
        if ((parentItem = this.getParentItem(firstParent, (Item[])this.getTree().getItems())) != null) {
            if (this.allChildItemsHaveSameState(parentItem, false)) {
                this.setCheckedOfAllParents(parentItem, false, false);
            } else if (this.allChildItemsHaveSameState(parentItem, true)) {
                this.setCheckedOfAllParents(parentItem, true, false);
            } else {
                this.setCheckedOfAllParents(parentItem, true, true);
            }
        }
    }

    private boolean allChildItemsHaveSameState(Item parentItem, boolean checked) {
        Item[] children;
        Item[] itemArray = children = this.getItems(parentItem);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Item childItem = itemArray[n2];
            Object data = childItem.getData();
            if (data != null) {
                if (!this.uncheckableElements.contains(data) && this.getChecked(data) != checked) {
                    return false;
                }
                if (!this.allChildItemsHaveSameState(childItem, checked)) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private Item getParentItem(Item child, Item[] rootItems) {
        Item[] itemArray = rootItems;
        int n = rootItems.length;
        int n2 = 0;
        while (n2 < n) {
            Item item = itemArray[n2];
            if (this.isDirectParentItemOf(item, child)) {
                return item;
            }
            if ((item = this.getParentItem(child, this.getItems(item))) != null) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private boolean isDirectParentItemOf(Item parentItem, Item childItem) {
        Item[] childItems;
        Item[] itemArray = childItems = this.getItems(parentItem);
        int n = childItems.length;
        int n2 = 0;
        while (n2 < n) {
            Item element = itemArray[n2];
            if (childItem == element) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        Item item;
        Object expandedElement = event.getElement();
        if (this.getChecked(expandedElement) && !this.getGrayed(expandedElement) && (item = this.getTreeItem(expandedElement, (Item[])this.getTree().getItems())) != null) {
            Item[] childItems;
            Item[] itemArray = childItems = this.getItems(item);
            int n = childItems.length;
            int n2 = 0;
            while (n2 < n) {
                Item element = itemArray[n2];
                Object data = element.getData();
                if (data != null) {
                    this.setChecked(data, true);
                }
                ++n2;
            }
        }
    }

    public Collection getCheckedButNotGrayedElements() {
        ArrayList<Object> checked = new ArrayList<Object>(Arrays.asList(this.getCheckedElements()));
        Iterator i = checked.iterator();
        while (i.hasNext()) {
            Object element = i.next();
            if (!this.getGrayed(element)) continue;
            i.remove();
        }
        return checked;
    }

    public boolean addContextMenu(Collection<IMenuListener> iMenuListeners, boolean removeAllMenuItemsWhenShown) {
        if (this.getControl().getMenu() == null) {
            MenuManager contextMenuMgr = new MenuManager("UsableCheckboxTreeViewerMenuManager");
            contextMenuMgr.setRemoveAllWhenShown(removeAllMenuItemsWhenShown);
            for (IMenuListener listener : iMenuListeners) {
                contextMenuMgr.addMenuListener(listener);
            }
            Menu menu = contextMenuMgr.createContextMenu(this.getControl());
            this.getControl().setMenu(menu);
            return true;
        }
        return false;
    }

    public boolean activateSelectionContextMenu() {
        ArrayList<IMenuListener> iMenuListeners = new ArrayList<IMenuListener>();
        iMenuListeners.add(new SelectionContextMenuMenuListener());
        if (!this.addContextMenu(iMenuListeners, true)) {
            this.removeContextMenu();
            return this.addContextMenu(iMenuListeners, true);
        }
        return true;
    }

    public boolean removeContextMenu() {
        if (this.getControl().getMenu() == null) {
            return false;
        }
        this.getControl().setMenu(null);
        return true;
    }

    public class SelectionContextMenuMenuListener
    implements IMenuListener {
        private final IAction selectAllAction = new Action(Messages.getString("UsableCheckboxTreeViewer.SelectionContextMenuMenuListener.selectAll")){

            public void run() {
                Object[] grayedElements;
                TreeItem[] rootItems;
                Object changedElement = null;
                Collection checkedNodes = UsableCheckboxTreeViewer.this.getCheckedButNotGrayedElements();
                TreeItem[] treeItemArray = rootItems = UsableCheckboxTreeViewer.this.getTree().getItems();
                int n = rootItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (!checkedNodes.contains(item.getData())) {
                        changedElement = item.getData();
                        break;
                    }
                    ++n2;
                }
                if (!$assertionsDisabled && changedElement == null) {
                    throw new AssertionError();
                }
                Object[] objectArray = grayedElements = UsableCheckboxTreeViewer.this.getGrayedElements();
                int n3 = grayedElements.length;
                n = 0;
                while (n < n3) {
                    Object element = objectArray[n];
                    UsableCheckboxTreeViewer.this.setGrayed(element, false);
                    ++n;
                }
                UsableCheckboxTreeViewer.this.setAllChecked(true);
                UsableCheckboxTreeViewer.this.fireCheckStateChanged(new CheckStateChangedEvent((ICheckable)UsableCheckboxTreeViewer.this, changedElement, true));
            }
        };
        private final IAction deselectAllAction = new Action(Messages.getString("UsableCheckboxTreeViewer.SelectionContextMenuMenuListener.deselectAll")){

            public void run() {
                Object changedElement = UsableCheckboxTreeViewer.this.getCheckedElements()[0];
                UsableCheckboxTreeViewer.this.setAllChecked(false);
                UsableCheckboxTreeViewer.this.fireCheckStateChanged(new CheckStateChangedEvent((ICheckable)UsableCheckboxTreeViewer.this, changedElement, false));
            }
        };

        public void menuAboutToShow(IMenuManager manager) {
            TreeItem[] rootItems;
            manager.add(this.selectAllAction);
            manager.add(this.deselectAllAction);
            boolean enableSelectAll = false;
            Collection checkedNodes = UsableCheckboxTreeViewer.this.getCheckedButNotGrayedElements();
            TreeItem[] treeItemArray = rootItems = UsableCheckboxTreeViewer.this.getTree().getItems();
            int n = rootItems.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (!checkedNodes.contains(item.getData())) {
                    enableSelectAll = true;
                    break;
                }
                ++n2;
            }
            this.selectAllAction.setEnabled(enableSelectAll);
            this.deselectAllAction.setEnabled(UsableCheckboxTreeViewer.this.getCheckedElements().length != 0);
        }
    }
}

