/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.dialogs;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MessageAndRadioButtonDialog
extends MessageDialog
implements SelectionListener {
    private final String[] radioButtonLabels;
    private final boolean[] radioButtonEnabled;
    private int checkedRadioButtonId;

    public MessageAndRadioButtonDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String[] radioButtonLabels, boolean[] radioButtonEnabled) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.radioButtonLabels = radioButtonLabels;
        this.radioButtonEnabled = radioButtonEnabled;
        this.setReturnCode(-1);
    }

    protected Control createCustomArea(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        boolean selectionSet = false;
        int i = 0;
        while (i < this.radioButtonLabels.length) {
            Button radioButton = new Button(control, 16);
            radioButton.setText(this.radioButtonLabels[i]);
            radioButton.setEnabled(this.radioButtonEnabled[i]);
            radioButton.addSelectionListener((SelectionListener)this);
            radioButton.setData((Object)new Integer(i));
            if (!selectionSet && this.radioButtonEnabled[i]) {
                radioButton.setSelection(true);
                selectionSet = true;
                this.checkedRadioButtonId = i;
            }
            ++i;
        }
        return control;
    }

    protected void buttonPressed(int buttonId) {
        int returnCode = this.checkedRadioButtonId * 10 + buttonId;
        this.setReturnCode(returnCode);
        this.close();
    }

    public int getCheckedRadioButton() {
        return this.checkedRadioButtonId;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (((Button)e.getSource()).getSelection()) {
            this.checkedRadioButtonId = (Integer)((Button)e.getSource()).getData();
        }
    }
}

