/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.project.impl;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.AbstractOleEventsListener;
import com.arcway.lib.eclipse.ole.project.Project;
import com.arcway.lib.eclipse.ole.project._EProjectApp2;
import com.arcway.lib.eclipse.ole.project.impl.AssignmentImpl;
import com.arcway.lib.eclipse.ole.project.impl.EventInfoImpl;
import com.arcway.lib.eclipse.ole.project.impl.ResourceImpl;
import com.arcway.lib.eclipse.ole.project.impl.SelectionImpl;
import com.arcway.lib.eclipse.ole.project.impl.TaskImpl;
import com.arcway.lib.eclipse.ole.project.impl.ViewImpl;
import com.arcway.lib.eclipse.ole.project.impl.WindowImpl;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.Variant;

public class _EProjectApp2Listener
extends AbstractOleEventsListener {
    private final Set<_EProjectApp2> listeners = new HashSet<_EProjectApp2>();

    public _EProjectApp2Listener(ResourceManager resourceManager) {
        super(resourceManager);
    }

    public boolean addListener(_EProjectApp2 listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(_EProjectApp2 listener) {
        return this.listeners.remove(listener);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void handleEvent(OleEvent oleEvent) {
        Variant[] arguments;
        switch (oleEvent.type) {
            case 1: {
                this.fireNewProject(oleEvent);
                break;
            }
            case 6: {
                this.fireProjectBeforeTaskDelete(oleEvent);
                break;
            }
            case 7: {
                this.fireProjectBeforeResourceDelete(oleEvent);
                break;
            }
            case 8: {
                this.fireProjectBeforeAssignmentDelete(oleEvent);
                break;
            }
            case 9: {
                this.fireProjectBeforeTaskChange(oleEvent);
                break;
            }
            case 10: {
                this.fireProjectBeforeResourceChange(oleEvent);
                break;
            }
            case 11: {
                this.fireProjectBeforeAssignmentChange(oleEvent);
                break;
            }
            case 12: {
                this.fireProjectBeforeTaskNew(oleEvent);
                break;
            }
            case 13: {
                this.fireProjectBeforeResourceNew(oleEvent);
                break;
            }
            case 14: {
                this.fireProjectBeforeAssignmentNew(oleEvent);
                break;
            }
            case 2: {
                this.fireProjectBeforeClose(oleEvent);
                break;
            }
            case 4: {
                this.fireProjectBeforePrint(oleEvent);
                break;
            }
            case 3: {
                this.fireProjectBeforeSave(oleEvent);
                break;
            }
            case 5: {
                this.fireProjectCalculate(oleEvent);
                break;
            }
            case 15: {
                this.fireWindowGoalAreaChange(oleEvent);
                break;
            }
            case 16: {
                this.fireWindowSelectionChange(oleEvent);
                break;
            }
            case 17: {
                this.fireWindowBeforeViewChange(oleEvent);
                break;
            }
            case 18: {
                this.fireWindowViewChange(oleEvent);
                break;
            }
            case 19: {
                this.fireWindowActivate(oleEvent);
                break;
            }
            case 20: {
                this.fireWindowDeactivate(oleEvent);
                break;
            }
            case 21: {
                this.fireWindowSidepaneDisplayChange(oleEvent);
                break;
            }
            case 22: {
                this.fireWindowSidepaneTaskChange(oleEvent);
                break;
            }
            case 23: {
                this.fireWorkpaneDisplayChange(oleEvent);
                break;
            }
            case 24: {
                this.fireLoadWebPage(oleEvent);
                break;
            }
            case 25: {
                this.fireProjectAfterSave(oleEvent);
                break;
            }
            case 26: {
                this.fireProjectTaskNew(oleEvent);
                break;
            }
            case 27: {
                this.fireProjectResourceNew(oleEvent);
                break;
            }
            case 28: {
                this.fireProjectAssignmentNew(oleEvent);
                break;
            }
            case 29: {
                this.fireProjectBeforeSaveBaseline(oleEvent);
                break;
            }
            case 30: {
                this.fireProjectBeforeClearBaseline(oleEvent);
                break;
            }
            case 0x40000002: {
                this.fireProjectBeforeClose2(oleEvent);
                break;
            }
            case 0x40000004: {
                this.fireProjectBeforePrint2(oleEvent);
                break;
            }
            case 0x40000003: {
                this.fireProjectBeforeSave2(oleEvent);
                break;
            }
            case 0x40000006: {
                this.fireProjectBeforeTaskDelete2(oleEvent);
                break;
            }
            case 0x40000007: {
                this.fireProjectBeforeResourceDelete2(oleEvent);
                break;
            }
            case 0x40000008: {
                this.fireProjectBeforeAssignmentDelete2(oleEvent);
                break;
            }
            case 0x40000009: {
                this.fireProjectBeforeTaskChange2(oleEvent);
                break;
            }
            case 0x4000000A: {
                this.fireProjectBeforeResourceChange2(oleEvent);
                break;
            }
            case 0x4000000B: {
                this.fireProjectBeforeAssignmentChange2(oleEvent);
                break;
            }
            case 0x4000000C: {
                this.fireProjectBeforeTaskNew2(oleEvent);
                break;
            }
            case 0x4000000D: {
                this.fireProjectBeforeResourceNew2(oleEvent);
                break;
            }
            case 0x4000000E: {
                this.fireProjectBeforeAssignmentNew2(oleEvent);
                break;
            }
            case 31: {
                this.fireApplicationBeforeClose(oleEvent);
            }
        }
        Variant[] variantArray = arguments = oleEvent.arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Variant argument = variantArray[n2];
            argument.dispose();
            ++n2;
        }
    }

    private void fireNewProject(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.NewProject(pj);
        }
    }

    private void fireProjectBeforeTaskDelete(OleEvent oleEvent) {
        TaskImpl tsk = new TaskImpl(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeTaskDelete(tsk, cancel);
        }
    }

    private void fireProjectBeforeResourceDelete(OleEvent oleEvent) {
        ResourceImpl res = new ResourceImpl(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeResourceDelete(res, cancel);
        }
    }

    private void fireProjectBeforeAssignmentDelete(OleEvent oleEvent) {
        AssignmentImpl asg = new AssignmentImpl(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeAssignmentDelete(asg, cancel);
        }
    }

    private void fireProjectBeforeTaskChange(OleEvent oleEvent) {
        TaskImpl tsk = new TaskImpl(oleEvent.arguments[0], this.getResourceManager());
        int field = oleEvent.arguments[1].getInt();
        Variant newVal = oleEvent.arguments[2];
        boolean cancel = oleEvent.arguments[3].getBoolean();
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeTaskChange(tsk, field, newVal, cancel);
        }
    }

    private void fireProjectBeforeResourceChange(OleEvent oleEvent) {
        ResourceImpl res = new ResourceImpl(oleEvent.arguments[0], this.getResourceManager());
        int field = oleEvent.arguments[1].getInt();
        Variant newVal = oleEvent.arguments[2];
        boolean cancel = oleEvent.arguments[3].getBoolean();
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeResourceChange(res, field, newVal, cancel);
        }
    }

    private void fireProjectBeforeAssignmentChange(OleEvent oleEvent) {
        AssignmentImpl asg = new AssignmentImpl(oleEvent.arguments[0], this.getResourceManager());
        int field = oleEvent.arguments[1].getInt();
        Variant newVal = oleEvent.arguments[2];
        boolean cancel = oleEvent.arguments[3].getBoolean();
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeAssignmentChange(asg, field, newVal, cancel);
        }
    }

    private void fireProjectBeforeTaskNew(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeTaskNew(pj, cancel);
        }
    }

    private void fireProjectBeforeResourceNew(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeResourceNew(pj, cancel);
        }
    }

    private void fireProjectBeforeAssignmentNew(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeAssignmentNew(pj, cancel);
        }
    }

    private void fireProjectBeforeClose(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeClose(pj, cancel);
        }
    }

    private void fireProjectBeforePrint(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforePrint(pj, cancel);
        }
    }

    private void fireProjectBeforeSave(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        boolean saveAsUi = oleEvent.arguments[1].getBoolean();
        boolean cancel = oleEvent.arguments[2].getBoolean();
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeSave(pj, saveAsUi, cancel);
        }
    }

    private void fireProjectCalculate(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectCalculate(pj);
        }
    }

    private void fireWindowGoalAreaChange(OleEvent oleEvent) {
        WindowImpl window = new WindowImpl(oleEvent.arguments[0], this.getResourceManager());
        int goalArea = oleEvent.arguments[1].getInt();
        for (_EProjectApp2 l : this.listeners) {
            l.WindowGoalAreaChange(window, goalArea);
        }
    }

    private void fireWindowSelectionChange(OleEvent oleEvent) {
        WindowImpl window = new WindowImpl(oleEvent.arguments[0], this.getResourceManager());
        SelectionImpl sel = new SelectionImpl(oleEvent.arguments[1], this.getResourceManager());
        Variant selType = oleEvent.arguments[2];
        for (_EProjectApp2 l : this.listeners) {
            l.WindowSelectionChange(window, sel, selType);
        }
    }

    private void fireWindowBeforeViewChange(OleEvent oleEvent) {
        WindowImpl window = new WindowImpl(oleEvent.arguments[0], this.getResourceManager());
        ViewImpl prevView = new ViewImpl(oleEvent.arguments[1], this.getResourceManager());
        ViewImpl newView = new ViewImpl(oleEvent.arguments[2], this.getResourceManager());
        boolean projectHasViewWindow = oleEvent.arguments[3].getBoolean();
        EventInfoImpl info = new EventInfoImpl(oleEvent.arguments[4], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.WindowBeforeViewChange(window, prevView, newView, projectHasViewWindow, info);
        }
    }

    private void fireWindowViewChange(OleEvent oleEvent) {
        WindowImpl window = new WindowImpl(oleEvent.arguments[0], this.getResourceManager());
        ViewImpl prevView = new ViewImpl(oleEvent.arguments[1], this.getResourceManager());
        ViewImpl newView = new ViewImpl(oleEvent.arguments[2], this.getResourceManager());
        boolean success = oleEvent.arguments[3].getBoolean();
        for (_EProjectApp2 l : this.listeners) {
            l.WindowViewChange(window, prevView, newView, success);
        }
    }

    private void fireWindowActivate(OleEvent oleEvent) {
        WindowImpl activatedWindow = new WindowImpl(oleEvent.arguments[0], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.WindowActivate(activatedWindow);
        }
    }

    private void fireWindowDeactivate(OleEvent oleEvent) {
        WindowImpl deactivatedWindow = new WindowImpl(oleEvent.arguments[0], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.WindowDeactivate(deactivatedWindow);
        }
    }

    private void fireWindowSidepaneDisplayChange(OleEvent oleEvent) {
        WindowImpl window = new WindowImpl(oleEvent.arguments[0], this.getResourceManager());
        boolean close = oleEvent.arguments[1].getBoolean();
        for (_EProjectApp2 l : this.listeners) {
            l.WindowSidepaneDisplayChange(window, close);
        }
    }

    private void fireWindowSidepaneTaskChange(OleEvent oleEvent) {
        WindowImpl window = new WindowImpl(oleEvent.arguments[0], this.getResourceManager());
        int iD = oleEvent.arguments[1].getInt();
        boolean isGoalArea = oleEvent.arguments[2].getBoolean();
        for (_EProjectApp2 l : this.listeners) {
            l.WindowSidepaneTaskChange(window, iD, isGoalArea);
        }
    }

    private void fireWorkpaneDisplayChange(OleEvent oleEvent) {
        boolean displayState = oleEvent.arguments[0].getBoolean();
        for (_EProjectApp2 l : this.listeners) {
            l.WorkpaneDisplayChange(displayState);
        }
    }

    private void fireLoadWebPage(OleEvent oleEvent) {
        WindowImpl window = new WindowImpl(oleEvent.arguments[0], this.getResourceManager());
        String targetPage = oleEvent.arguments[1].getString();
        for (_EProjectApp2 l : this.listeners) {
            l.LoadWebPage(window, targetPage);
        }
    }

    private void fireProjectAfterSave(OleEvent oleEvent) {
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectAfterSave();
        }
    }

    private void fireProjectTaskNew(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        int iD = oleEvent.arguments[1].getInt();
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectTaskNew(pj, iD);
        }
    }

    private void fireProjectResourceNew(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        int iD = oleEvent.arguments[1].getInt();
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectResourceNew(pj, iD);
        }
    }

    private void fireProjectAssignmentNew(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        int iD = oleEvent.arguments[1].getInt();
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectAssignmentNew(pj, iD);
        }
    }

    private void fireProjectBeforeSaveBaseline(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        boolean interim = oleEvent.arguments[1].getBoolean();
        int bl = oleEvent.arguments[2].getInt();
        int interimCopy = oleEvent.arguments[3].getInt();
        int interimInto = oleEvent.arguments[4].getInt();
        boolean allTasks = oleEvent.arguments[5].getBoolean();
        boolean rollupToSummaryTasks = oleEvent.arguments[6].getBoolean();
        boolean rollupFromSubtasks = oleEvent.arguments[7].getBoolean();
        EventInfoImpl info = new EventInfoImpl(oleEvent.arguments[8], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeSaveBaseline(pj, interim, bl, interimCopy, interimInto, allTasks, rollupToSummaryTasks, rollupFromSubtasks, info);
        }
    }

    private void fireProjectBeforeClearBaseline(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        boolean interim = oleEvent.arguments[1].getBoolean();
        int bl = oleEvent.arguments[2].getInt();
        int interimFrom = oleEvent.arguments[3].getInt();
        boolean allTasks = oleEvent.arguments[4].getBoolean();
        EventInfoImpl info = new EventInfoImpl(oleEvent.arguments[5], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeClearBaseline(pj, interim, bl, interimFrom, allTasks, info);
        }
    }

    private void fireProjectBeforeClose2(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        EventInfoImpl info = new EventInfoImpl(oleEvent.arguments[1], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeClose2(pj, info);
        }
    }

    private void fireProjectBeforePrint2(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        EventInfoImpl info = new EventInfoImpl(oleEvent.arguments[1], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforePrint2(pj, info);
        }
    }

    private void fireProjectBeforeSave2(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        boolean saveAsUi = oleEvent.arguments[1].getBoolean();
        EventInfoImpl info = new EventInfoImpl(oleEvent.arguments[2], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeSave2(pj, saveAsUi, info);
        }
    }

    private void fireProjectBeforeTaskDelete2(OleEvent oleEvent) {
        TaskImpl tsk = new TaskImpl(oleEvent.arguments[0], this.getResourceManager());
        EventInfoImpl info = new EventInfoImpl(oleEvent.arguments[1], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeTaskDelete2(tsk, info);
        }
    }

    private void fireProjectBeforeResourceDelete2(OleEvent oleEvent) {
        ResourceImpl res = new ResourceImpl(oleEvent.arguments[0], this.getResourceManager());
        EventInfoImpl info = new EventInfoImpl(oleEvent.arguments[1], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeResourceDelete2(res, info);
        }
    }

    private void fireProjectBeforeAssignmentDelete2(OleEvent oleEvent) {
        AssignmentImpl asg = new AssignmentImpl(oleEvent.arguments[0], this.getResourceManager());
        EventInfoImpl info = new EventInfoImpl(oleEvent.arguments[1], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeAssignmentDelete2(asg, info);
        }
    }

    private void fireProjectBeforeTaskChange2(OleEvent oleEvent) {
        TaskImpl tsk = new TaskImpl(oleEvent.arguments[0], this.getResourceManager());
        int field = oleEvent.arguments[1].getInt();
        Variant newVal = oleEvent.arguments[2];
        EventInfoImpl info = new EventInfoImpl(oleEvent.arguments[3], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeTaskChange2(tsk, field, newVal, info);
        }
    }

    private void fireProjectBeforeResourceChange2(OleEvent oleEvent) {
        ResourceImpl res = new ResourceImpl(oleEvent.arguments[0], this.getResourceManager());
        int field = oleEvent.arguments[1].getInt();
        Variant newVal = oleEvent.arguments[2];
        EventInfoImpl info = new EventInfoImpl(oleEvent.arguments[3], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeResourceChange2(res, field, newVal, info);
        }
    }

    private void fireProjectBeforeAssignmentChange2(OleEvent oleEvent) {
        AssignmentImpl asg = new AssignmentImpl(oleEvent.arguments[0], this.getResourceManager());
        int field = oleEvent.arguments[1].getInt();
        Variant newVal = oleEvent.arguments[2];
        EventInfoImpl info = new EventInfoImpl(oleEvent.arguments[3], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeAssignmentChange2(asg, field, newVal, info);
        }
    }

    private void fireProjectBeforeTaskNew2(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        EventInfoImpl info = new EventInfoImpl(oleEvent.arguments[1], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeTaskNew2(pj, info);
        }
    }

    private void fireProjectBeforeResourceNew2(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        EventInfoImpl info = new EventInfoImpl(oleEvent.arguments[1], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeResourceNew2(pj, info);
        }
    }

    private void fireProjectBeforeAssignmentNew2(OleEvent oleEvent) {
        Project pj = new Project(oleEvent.arguments[0], this.getResourceManager());
        EventInfoImpl info = new EventInfoImpl(oleEvent.arguments[1], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.ProjectBeforeAssignmentNew2(pj, info);
        }
    }

    private void fireApplicationBeforeClose(OleEvent oleEvent) {
        EventInfoImpl info = new EventInfoImpl(oleEvent.arguments[0], this.getResourceManager());
        for (_EProjectApp2 l : this.listeners) {
            l.ApplicationBeforeClose(info);
        }
    }
}

