/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.project;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.TypeUtils;
import com.arcway.lib.eclipse.ole.project._EProjectDoc;
import com.arcway.lib.eclipse.ole.project._IProjectDoc;
import com.arcway.lib.eclipse.ole.project.impl._EProjectDocListener;
import com.arcway.lib.eclipse.ole.project.impl._IProjectDocImpl;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.text.MessageFormat;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;

public class Project
extends _IProjectDocImpl {
    private static final ILogger logger = Logger.getLogger(Project.class);
    public static final GUID CLSID = TypeUtils.IIDFromString((String)"{1019A320-508A-11CF-A49D-00AA00574C74}");
    private _EProjectDocListener fEProjectDoc;

    public Project(OleAutomation oleAutomation, ResourceManager resourceManager) {
        super(oleAutomation, resourceManager);
    }

    public Project(Variant variant, ResourceManager resourceManager) {
        super(variant, resourceManager);
    }

    public static _IProjectDoc create(int dwClsContext, ResourceManager resourceManager, boolean callingOleRunIsRequired) {
        if (!callingOleRunIsRequired) {
            int[] ppv = new int[1];
            int result = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIDispatch, (int[])ppv);
            if (result != 0) {
                OLE.error((int)1001, (int)result);
            }
            Variant v = new Variant(new IDispatch(ppv[0]));
            return new _IProjectDocImpl(v, resourceManager);
        }
        int[] ppv = new int[1];
        int coCreateInstanceResult = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIUnknown, (int[])ppv);
        if (coCreateInstanceResult != 0) {
            OLE.error((int)1001, (int)coCreateInstanceResult);
        }
        IUnknown objIUnknown = new IUnknown(ppv[0]);
        try {
            int[] ppvObject;
            int queryIDispatchResult;
            int oleRunResult = COM.OleRun((int)objIUnknown.getAddress());
            if (oleRunResult != 0) {
                logger.debug(MessageFormat.format("Initialisation of COM Server CLSID={0} failed. (errorcode={1}). ", CLSID.toString(), oleRunResult));
                OLE.error((int)1014, (int)coCreateInstanceResult);
            }
            if ((queryIDispatchResult = objIUnknown.QueryInterface(COM.IIDIDispatch, ppvObject = new int[1])) != 0) {
                try {
                    OLE.error((int)1003, (int)queryIDispatchResult);
                }
                catch (SWTException e) {
                    try {
                        Exception cause = new Exception(MessageFormat.format("Additional Information: Problem occured while trying to initialise COM Server CLSID={0}, objIUnknown.getAddress()={1}.). ", CLSID.toString(), String.valueOf(objIUnknown.getAddress())));
                        e.initCause((Throwable)cause);
                    }
                    catch (Exception e1) {
                        throw e;
                    }
                }
            }
            IDispatch disp = new IDispatch(ppvObject[0]);
            Variant appVariant = new Variant(disp);
            _IProjectDocImpl _IProjectDocImpl2 = new _IProjectDocImpl(appVariant, resourceManager);
            return _IProjectDocImpl2;
        }
        finally {
            objIUnknown.Release();
        }
    }

    public boolean add_EProjectDocListener(_EProjectDoc listener) {
        if (this.fEProjectDoc == null) {
            this.fEProjectDoc = new _EProjectDocListener(this.getResourceManager());
            this.addEventListener(_EProjectDoc.IID, 1, (OleListener)this.fEProjectDoc);
            this.addEventListener(_EProjectDoc.IID, 2, (OleListener)this.fEProjectDoc);
            this.addEventListener(_EProjectDoc.IID, 3, (OleListener)this.fEProjectDoc);
            this.addEventListener(_EProjectDoc.IID, 4, (OleListener)this.fEProjectDoc);
            this.addEventListener(_EProjectDoc.IID, 5, (OleListener)this.fEProjectDoc);
            this.addEventListener(_EProjectDoc.IID, 6, (OleListener)this.fEProjectDoc);
            this.addEventListener(_EProjectDoc.IID, 7, (OleListener)this.fEProjectDoc);
            this.addEventListener(_EProjectDoc.IID, 8, (OleListener)this.fEProjectDoc);
        }
        return this.fEProjectDoc.addListener(listener);
    }

    public boolean remove_EProjectDocListener(_EProjectDoc listener) {
        boolean bRtn = this.fEProjectDoc.removeListener(listener);
        if (this.fEProjectDoc.isEmpty()) {
            this.removeEventListener(_EProjectDoc.IID, 1, (OleListener)this.fEProjectDoc);
            this.removeEventListener(_EProjectDoc.IID, 2, (OleListener)this.fEProjectDoc);
            this.removeEventListener(_EProjectDoc.IID, 3, (OleListener)this.fEProjectDoc);
            this.removeEventListener(_EProjectDoc.IID, 4, (OleListener)this.fEProjectDoc);
            this.removeEventListener(_EProjectDoc.IID, 5, (OleListener)this.fEProjectDoc);
            this.removeEventListener(_EProjectDoc.IID, 6, (OleListener)this.fEProjectDoc);
            this.removeEventListener(_EProjectDoc.IID, 7, (OleListener)this.fEProjectDoc);
            this.removeEventListener(_EProjectDoc.IID, 8, (OleListener)this.fEProjectDoc);
            this.fEProjectDoc = null;
        }
        return bRtn;
    }
}

