/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.excel.impl;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.AbstractOleEventsListener;
import au.com.swz.swttocom.swt.types.pointer.BooleanPointer;
import com.arcway.lib.eclipse.ole.excel.DocEvents;
import com.arcway.lib.eclipse.ole.excel.impl.HyperlinkImpl;
import com.arcway.lib.eclipse.ole.excel.impl.PivotTableImpl;
import com.arcway.lib.eclipse.ole.excel.impl.RangeImpl;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.Variant;

public class DocEventsListener
extends AbstractOleEventsListener {
    private final Set<DocEvents> listeners = new HashSet<DocEvents>();

    public DocEventsListener(ResourceManager resourceManager) {
        super(resourceManager);
    }

    public boolean addListener(DocEvents listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(DocEvents listener) {
        return this.listeners.remove(listener);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void handleEvent(OleEvent oleEvent) {
        Variant[] arguments;
        switch (oleEvent.type) {
            case 1543: {
                this.fireSelectionChange(oleEvent);
                break;
            }
            case 1537: {
                this.fireBeforeDoubleClick(oleEvent);
                break;
            }
            case 1534: {
                this.fireBeforeRightClick(oleEvent);
                break;
            }
            case 304: {
                this.fireActivate(oleEvent);
                break;
            }
            case 1530: {
                this.fireDeactivate(oleEvent);
                break;
            }
            case 279: {
                this.fireCalculate(oleEvent);
                break;
            }
            case 1545: {
                this.fireChange(oleEvent);
                break;
            }
            case 1470: {
                this.fireFollowHyperlink(oleEvent);
                break;
            }
            case 2156: {
                this.firePivotTableUpdate(oleEvent);
            }
        }
        Variant[] variantArray = arguments = oleEvent.arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Variant argument = variantArray[n2];
            argument.dispose();
            ++n2;
        }
    }

    private void fireSelectionChange(OleEvent oleEvent) {
        RangeImpl target = new RangeImpl(oleEvent.arguments[0], this.getResourceManager());
        for (DocEvents l : this.listeners) {
            l.SelectionChange(target);
        }
    }

    private void fireBeforeDoubleClick(OleEvent oleEvent) {
        RangeImpl target = new RangeImpl(oleEvent.arguments[0], this.getResourceManager());
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[1].getByRef(), this.getResourceManager());
        for (DocEvents l : this.listeners) {
            l.BeforeDoubleClick(target, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireBeforeRightClick(OleEvent oleEvent) {
        RangeImpl target = new RangeImpl(oleEvent.arguments[0], this.getResourceManager());
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[1].getByRef(), this.getResourceManager());
        for (DocEvents l : this.listeners) {
            l.BeforeRightClick(target, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireActivate(OleEvent oleEvent) {
        for (DocEvents l : this.listeners) {
            l.Activate();
        }
    }

    private void fireDeactivate(OleEvent oleEvent) {
        for (DocEvents l : this.listeners) {
            l.Deactivate();
        }
    }

    private void fireCalculate(OleEvent oleEvent) {
        for (DocEvents l : this.listeners) {
            l.Calculate();
        }
    }

    private void fireChange(OleEvent oleEvent) {
        RangeImpl target = new RangeImpl(oleEvent.arguments[0], this.getResourceManager());
        for (DocEvents l : this.listeners) {
            l.Change(target);
        }
    }

    private void fireFollowHyperlink(OleEvent oleEvent) {
        HyperlinkImpl target = new HyperlinkImpl(oleEvent.arguments[0], this.getResourceManager());
        for (DocEvents l : this.listeners) {
            l.FollowHyperlink(target);
        }
    }

    private void firePivotTableUpdate(OleEvent oleEvent) {
        PivotTableImpl target = new PivotTableImpl(oleEvent.arguments[0], this.getResourceManager());
        for (DocEvents l : this.listeners) {
            l.PivotTableUpdate(target);
        }
    }
}

